rule win_snatch_loader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.snatch_loader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.snatch_loader"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 53 56 57 33db bfe71edec0 895dfc }
            // n = 6, score = 600
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   33db                 | xor                 ebx, ebx
            //   bfe71edec0           | mov                 edi, 0xc0de1ee7
            //   895dfc               | mov                 dword ptr [ebp - 4], ebx

        $sequence_1 = { 8975fc 66397102 740b 42 0fb7c2 6639744102 }
            // n = 6, score = 600
            //   8975fc               | mov                 dword ptr [ebp - 4], esi
            //   66397102             | cmp                 word ptr [ecx + 2], si
            //   740b                 | je                  0xd
            //   42                   | inc                 edx
            //   0fb7c2               | movzx               eax, dx
            //   6639744102           | cmp                 word ptr [ecx + eax*2 + 2], si

        $sequence_2 = { 85c0 7505 8b7dfc eb04 ffd0 8bf8 }
            // n = 6, score = 600
            //   85c0                 | test                eax, eax
            //   7505                 | jne                 7
            //   8b7dfc               | mov                 edi, dword ptr [ebp - 4]
            //   eb04                 | jmp                 6
            //   ffd0                 | call                eax
            //   8bf8                 | mov                 edi, eax

        $sequence_3 = { 53 56 57 ffd0 5f 85c0 }
            // n = 6, score = 600
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   ffd0                 | call                eax
            //   5f                   | pop                 edi
            //   85c0                 | test                eax, eax

        $sequence_4 = { 53 bb00040000 56 8bcb e8???????? 8bf0 }
            // n = 6, score = 600
            //   53                   | push                ebx
            //   bb00040000           | mov                 ebx, 0x400
            //   56                   | push                esi
            //   8bcb                 | mov                 ecx, ebx
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax

        $sequence_5 = { 83ec0c 56 33f6 8bd6 8975fc 66397102 }
            // n = 6, score = 600
            //   83ec0c               | sub                 esp, 0xc
            //   56                   | push                esi
            //   33f6                 | xor                 esi, esi
            //   8bd6                 | mov                 edx, esi
            //   8975fc               | mov                 dword ptr [ebp - 4], esi
            //   66397102             | cmp                 word ptr [ecx + 2], si

        $sequence_6 = { 53 56 33f6 8bd9 57 85c0 7522 }
            // n = 7, score = 600
            //   53                   | push                ebx
            //   56                   | push                esi
            //   33f6                 | xor                 esi, esi
            //   8bd9                 | mov                 ebx, ecx
            //   57                   | push                edi
            //   85c0                 | test                eax, eax
            //   7522                 | jne                 0x24

        $sequence_7 = { 85c0 8bce 0f457dfc e8???????? }
            // n = 4, score = 600
            //   85c0                 | test                eax, eax
            //   8bce                 | mov                 ecx, esi
            //   0f457dfc             | cmovne              edi, dword ptr [ebp - 4]
            //   e8????????           |                     

        $sequence_8 = { 5e eb03 83c704 83c304 41 833eff }
            // n = 6, score = 500
            //   5e                   | pop                 esi
            //   eb03                 | jmp                 5
            //   83c704               | add                 edi, 4
            //   83c304               | add                 ebx, 4
            //   41                   | inc                 ecx
            //   833eff               | cmp                 dword ptr [esi], -1

        $sequence_9 = { 52 ff750c e8???????? 8945fc 0bc0 }
            // n = 5, score = 500
            //   52                   | push                edx
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   e8????????           |                     
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   0bc0                 | or                  eax, eax

        $sequence_10 = { 68???????? 58 ffd0 8945f0 }
            // n = 4, score = 500
            //   68????????           |                     
            //   58                   | pop                 eax
            //   ffd0                 | call                eax
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax

        $sequence_11 = { 53 57 56 33db 6a04 6800300000 }
            // n = 6, score = 500
            //   53                   | push                ebx
            //   57                   | push                edi
            //   56                   | push                esi
            //   33db                 | xor                 ebx, ebx
            //   6a04                 | push                4
            //   6800300000           | push                0x3000

        $sequence_12 = { 41 3b4df8 72ee 8bc2 034508 5a 59 }
            // n = 7, score = 500
            //   41                   | inc                 ecx
            //   3b4df8               | cmp                 ecx, dword ptr [ebp - 8]
            //   72ee                 | jb                  0xfffffff0
            //   8bc2                 | mov                 eax, edx
            //   034508               | add                 eax, dword ptr [ebp + 8]
            //   5a                   | pop                 edx
            //   59                   | pop                 ecx

        $sequence_13 = { 734f ff7510 e8???????? 8945f8 0bc0 7440 3b45fc }
            // n = 7, score = 500
            //   734f                 | jae                 0x51
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   e8????????           |                     
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   0bc0                 | or                  eax, eax
            //   7440                 | je                  0x42
            //   3b45fc               | cmp                 eax, dword ptr [ebp - 4]

        $sequence_14 = { 0bc0 7440 3b45fc 773b 8b750c 8b7d10 }
            // n = 6, score = 500
            //   0bc0                 | or                  eax, eax
            //   7440                 | je                  0x42
            //   3b45fc               | cmp                 eax, dword ptr [ebp - 4]
            //   773b                 | ja                  0x3d
            //   8b750c               | mov                 esi, dword ptr [ebp + 0xc]
            //   8b7d10               | mov                 edi, dword ptr [ebp + 0x10]

        $sequence_15 = { 33c9 8a0431 0ac0 741f }
            // n = 4, score = 500
            //   33c9                 | xor                 ecx, ecx
            //   8a0431               | mov                 al, byte ptr [ecx + esi]
            //   0ac0                 | or                  al, al
            //   741f                 | je                  0x21

    condition:
        7 of them and filesize < 262144
}