rule win_socks5_systemz_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.socks5_systemz."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.socks5_systemz"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 57 50 ff15???????? c744242cffffffff 85ed 741d 8d4504 }
            // n = 7, score = 500
            //   57                   | push                edi
            //   50                   | push                eax
            //   ff15????????         |                     
            //   c744242cffffffff     | mov                 dword ptr [esp + 0x2c], 0xffffffff
            //   85ed                 | test                ebp, ebp
            //   741d                 | je                  0x1f
            //   8d4504               | lea                 eax, [ebp + 4]

        $sequence_1 = { 896c2414 eb0d 50 ff15???????? 8be8 89442414 896c241c }
            // n = 7, score = 500
            //   896c2414             | mov                 dword ptr [esp + 0x14], ebp
            //   eb0d                 | jmp                 0xf
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8be8                 | mov                 ebp, eax
            //   89442414             | mov                 dword ptr [esp + 0x14], eax
            //   896c241c             | mov                 dword ptr [esp + 0x1c], ebp

        $sequence_2 = { e8???????? 8b5c241c 8bd0 83c408 8bca }
            // n = 5, score = 500
            //   e8????????           |                     
            //   8b5c241c             | mov                 ebx, dword ptr [esp + 0x1c]
            //   8bd0                 | mov                 edx, eax
            //   83c408               | add                 esp, 8
            //   8bca                 | mov                 ecx, edx

        $sequence_3 = { 7408 83f9ff 7403 51 ffd3 8975a0 e9???????? }
            // n = 7, score = 500
            //   7408                 | je                  0xa
            //   83f9ff               | cmp                 ecx, -1
            //   7403                 | je                  5
            //   51                   | push                ecx
            //   ffd3                 | call                ebx
            //   8975a0               | mov                 dword ptr [ebp - 0x60], esi
            //   e9????????           |                     

        $sequence_4 = { 8d4900 8b0e e8???????? 83c608 3bf7 75f2 }
            // n = 6, score = 500
            //   8d4900               | lea                 ecx, [ecx]
            //   8b0e                 | mov                 ecx, dword ptr [esi]
            //   e8????????           |                     
            //   83c608               | add                 esi, 8
            //   3bf7                 | cmp                 esi, edi
            //   75f2                 | jne                 0xfffffff4

        $sequence_5 = { c744241c00000000 c6471801 e8???????? 8b7f4c 8b37 3bf7 7415 }
            // n = 7, score = 500
            //   c744241c00000000     | mov                 dword ptr [esp + 0x1c], 0
            //   c6471801             | mov                 byte ptr [edi + 0x18], 1
            //   e8????????           |                     
            //   8b7f4c               | mov                 edi, dword ptr [edi + 0x4c]
            //   8b37                 | mov                 esi, dword ptr [edi]
            //   3bf7                 | cmp                 esi, edi
            //   7415                 | je                  0x17

        $sequence_6 = { 8d442404 50 e8???????? f744240400000080 7479 53 }
            // n = 6, score = 500
            //   8d442404             | lea                 eax, [esp + 4]
            //   50                   | push                eax
            //   e8????????           |                     
            //   f744240400000080     | test                dword ptr [esp + 4], 0x80000000
            //   7479                 | je                  0x7b
            //   53                   | push                ebx

        $sequence_7 = { e8???????? c706???????? 8d4e14 8b470c 89460c 8b4710 894610 }
            // n = 7, score = 500
            //   e8????????           |                     
            //   c706????????         |                     
            //   8d4e14               | lea                 ecx, [esi + 0x14]
            //   8b470c               | mov                 eax, dword ptr [edi + 0xc]
            //   89460c               | mov                 dword ptr [esi + 0xc], eax
            //   8b4710               | mov                 eax, dword ptr [edi + 0x10]
            //   894610               | mov                 dword ptr [esi + 0x10], eax

    condition:
        7 of them and filesize < 1417216
}