rule win_sombrat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.sombrat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.sombrat"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 015f08 33c0 488b4c2470 4833cc }
            // n = 4, score = 200
            //   015f08               | mov                 edx, dword ptr [esi]
            //   33c0                 | add                 dword ptr [ebp - 0xf], eax
            //   488b4c2470           | inc                 ebp
            //   4833cc               | xor                 ecx, ecx

        $sequence_1 = { 016b08 488d05dc980500 41b9e7160000 4889442420 }
            // n = 4, score = 200
            //   016b08               | add                 dword ptr [edi + 8], ebx
            //   488d05dc980500       | dec                 eax
            //   41b9e7160000         | mov                 ecx, edi
            //   4889442420           | mov                 esi, eax

        $sequence_2 = { 015f08 488bcf e8???????? 8bf0 }
            // n = 4, score = 200
            //   015f08               | dec                 eax
            //   488bcf               | mov                 ecx, dword ptr [esp + 0x70]
            //   e8????????           |                     
            //   8bf0                 | dec                 eax

        $sequence_3 = { 016b08 33c0 e9???????? 33ff }
            // n = 4, score = 200
            //   016b08               | xor                 eax, eax
            //   33c0                 | dec                 eax
            //   e9????????           |                     
            //   33ff                 | mov                 eax, dword ptr [edi + 0x60]

        $sequence_4 = { 015f08 33c0 e9???????? 488b4760 }
            // n = 4, score = 200
            //   015f08               | add                 dword ptr [ebp - 0xf], eax
            //   33c0                 | inc                 ebp
            //   e9????????           |                     
            //   488b4760             | xor                 ecx, ecx

        $sequence_5 = { 015f08 83bfd800000016 0f856c020000 488b87c8000000 }
            // n = 4, score = 200
            //   015f08               | dec                 esp
            //   83bfd800000016       | lea                 ebx, [esp + 0x80]
            //   0f856c020000         | dec                 ecx
            //   488b87c8000000       | mov                 ebx, dword ptr [ebx + 0x38]

        $sequence_6 = { 01448c20 48ffc1 493bc9 7cf1 }
            // n = 4, score = 200
            //   01448c20             | add                 dword ptr [esp + ecx*4 + 0x20], eax
            //   48ffc1               | dec                 eax
            //   493bc9               | inc                 ecx
            //   7cf1                 | dec                 ecx

        $sequence_7 = { 0145f1 4533c9 4533c0 488b16 }
            // n = 4, score = 200
            //   0145f1               | dec                 esp
            //   4533c9               | sub                 eax, esi
            //   4533c0               | add                 dword ptr [esp + ecx*4 + 0x20], eax
            //   488b16               | dec                 eax

        $sequence_8 = { 014114 8b7508 837df800 8b5df4 0f84c3feffff }
            // n = 5, score = 100
            //   014114               | add                 dword ptr [ecx + 0x14], eax
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   837df800             | cmp                 dword ptr [ebp - 8], 0
            //   8b5df4               | mov                 ebx, dword ptr [ebp - 0xc]
            //   0f84c3feffff         | je                  0xfffffec9

        $sequence_9 = { 014620 ff36 114e24 8b442434 }
            // n = 4, score = 100
            //   014620               | add                 dword ptr [esi + 0x20], eax
            //   ff36                 | push                dword ptr [esi]
            //   114e24               | adc                 dword ptr [esi + 0x24], ecx
            //   8b442434             | mov                 eax, dword ptr [esp + 0x34]

        $sequence_10 = { 0144244a 894e0c ffb72c010000 ff15???????? }
            // n = 4, score = 100
            //   0144244a             | add                 dword ptr [esp + 0x4a], eax
            //   894e0c               | mov                 dword ptr [esi + 0xc], ecx
            //   ffb72c010000         | push                dword ptr [edi + 0x12c]
            //   ff15????????         |                     

        $sequence_11 = { 0145e4 8b55f8 83c40c 294644 }
            // n = 4, score = 100
            //   0145e4               | add                 dword ptr [ebp - 0x1c], eax
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   83c40c               | add                 esp, 0xc
            //   294644               | sub                 dword ptr [esi + 0x44], eax

        $sequence_12 = { 0000 e8???????? c70424???????? 8d5f0c }
            // n = 4, score = 100
            //   0000                 | add                 byte ptr [eax], al
            //   e8????????           |                     
            //   c70424????????       |                     
            //   8d5f0c               | lea                 ebx, [edi + 0xc]

        $sequence_13 = { 01041e 8b4508 42 8d7308 }
            // n = 4, score = 100
            //   01041e               | add                 dword ptr [esi + ebx], eax
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   42                   | inc                 edx
            //   8d7308               | lea                 esi, [ebx + 8]

        $sequence_14 = { 014620 f6460c04 8945e0 742d 85c0 7429 8b4de4 }
            // n = 7, score = 100
            //   014620               | add                 dword ptr [esi + 0x20], eax
            //   f6460c04             | test                byte ptr [esi + 0xc], 4
            //   8945e0               | mov                 dword ptr [ebp - 0x20], eax
            //   742d                 | je                  0x2f
            //   85c0                 | test                eax, eax
            //   7429                 | je                  0x2b
            //   8b4de4               | mov                 ecx, dword ptr [ebp - 0x1c]

        $sequence_15 = { 014648 d3eb 018ec81b0000 c746044c3f0000 837df000 0f8461020000 }
            // n = 6, score = 100
            //   014648               | add                 dword ptr [esi + 0x48], eax
            //   d3eb                 | shr                 ebx, cl
            //   018ec81b0000         | add                 dword ptr [esi + 0x1bc8], ecx
            //   c746044c3f0000       | mov                 dword ptr [esi + 4], 0x3f4c
            //   837df000             | cmp                 dword ptr [ebp - 0x10], 0
            //   0f8461020000         | je                  0x267

    condition:
        7 of them and filesize < 1466368
}