rule win_sparrow_door_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.sparrow_door."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.sparrow_door"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 e8???????? 33c0 8d4c242c }
            // n = 4, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   33c0                 | xor                 eax, eax
            //   8d4c242c             | lea                 ecx, [esp + 0x2c]

        $sequence_1 = { 51 53 57 6a40 6800100000 6800100000 6a00 }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   53                   | push                ebx
            //   57                   | push                edi
            //   6a40                 | push                0x40
            //   6800100000           | push                0x1000
            //   6800100000           | push                0x1000
            //   6a00                 | push                0

        $sequence_2 = { 50 8d742e08 53 e8???????? 8b442448 83c43c 85c0 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   8d742e08             | lea                 esi, [esi + ebp + 8]
            //   53                   | push                ebx
            //   e8????????           |                     
            //   8b442448             | mov                 eax, dword ptr [esp + 0x48]
            //   83c43c               | add                 esp, 0x3c
            //   85c0                 | test                eax, eax

        $sequence_3 = { ebb3 55 e8???????? 8b44241c 83c404 50 }
            // n = 6, score = 100
            //   ebb3                 | jmp                 0xffffffb5
            //   55                   | push                ebp
            //   e8????????           |                     
            //   8b44241c             | mov                 eax, dword ptr [esp + 0x1c]
            //   83c404               | add                 esp, 4
            //   50                   | push                eax

        $sequence_4 = { 89542434 8b9424e8200000 8d442449 56 33db 50 894c2444 }
            // n = 7, score = 100
            //   89542434             | mov                 dword ptr [esp + 0x34], edx
            //   8b9424e8200000       | mov                 edx, dword ptr [esp + 0x20e8]
            //   8d442449             | lea                 eax, [esp + 0x49]
            //   56                   | push                esi
            //   33db                 | xor                 ebx, ebx
            //   50                   | push                eax
            //   894c2444             | mov                 dword ptr [esp + 0x44], ecx

        $sequence_5 = { 8d442f08 50 e8???????? 33c0 8d4c242c }
            // n = 5, score = 100
            //   8d442f08             | lea                 eax, [edi + ebp + 8]
            //   50                   | push                eax
            //   e8????????           |                     
            //   33c0                 | xor                 eax, eax
            //   8d4c242c             | lea                 ecx, [esp + 0x2c]

        $sequence_6 = { 53 6a00 6a00 ff15???????? 8b4c2418 8b542414 6a00 }
            // n = 7, score = 100
            //   53                   | push                ebx
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   8b4c2418             | mov                 ecx, dword ptr [esp + 0x18]
            //   8b542414             | mov                 edx, dword ptr [esp + 0x14]
            //   6a00                 | push                0

        $sequence_7 = { 53 6a01 53 53 8d8c2498000000 }
            // n = 5, score = 100
            //   53                   | push                ebx
            //   6a01                 | push                1
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   8d8c2498000000       | lea                 ecx, [esp + 0x98]

        $sequence_8 = { 50 889c2448020000 e8???????? 83c40c }
            // n = 4, score = 100
            //   50                   | push                eax
            //   889c2448020000       | mov                 byte ptr [esp + 0x248], bl
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc

        $sequence_9 = { 896c2464 e8???????? 83c43c 85c0 752e 837c242464 }
            // n = 6, score = 100
            //   896c2464             | mov                 dword ptr [esp + 0x64], ebp
            //   e8????????           |                     
            //   83c43c               | add                 esp, 0x3c
            //   85c0                 | test                eax, eax
            //   752e                 | jne                 0x30
            //   837c242464           | cmp                 dword ptr [esp + 0x24], 0x64

    condition:
        7 of them and filesize < 155648
}