rule win_ssload_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.ssload."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ssload"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 31d2 8944240c 662e0f1f840000000000 0f1f4000 3b6c2408 7306 }
            // n = 6, score = 400
            //   31d2                 | xor                 edx, edx
            //   8944240c             | mov                 dword ptr [esp + 0xc], eax
            //   662e0f1f840000000000     | nop    word ptr cs:[eax + eax]
            //   0f1f4000             | nop                 dword ptr [eax]
            //   3b6c2408             | cmp                 ebp, dword ptr [esp + 8]
            //   7306                 | jae                 8

        $sequence_1 = { 04e3 89c1 89d8 bb3e000000 46 }
            // n = 5, score = 400
            //   04e3                 | add                 al, 0xe3
            //   89c1                 | mov                 ecx, eax
            //   89d8                 | mov                 eax, ebx
            //   bb3e000000           | mov                 ebx, 0x3e
            //   46                   | inc                 esi

        $sequence_2 = { 0fb66f01 0fb67702 0fb67f03 83e307 c1e312 }
            // n = 5, score = 400
            //   0fb66f01             | movzx               ebp, byte ptr [edi + 1]
            //   0fb67702             | movzx               esi, byte ptr [edi + 2]
            //   0fb67f03             | movzx               edi, byte ptr [edi + 3]
            //   83e307               | and                 ebx, 7
            //   c1e312               | shl                 ebx, 0x12

        $sequence_3 = { 0fb605???????? 84c0 0f8495010000 8b450c 85c0 7409 83f803 }
            // n = 7, score = 400
            //   0fb605????????       |                     
            //   84c0                 | test                al, al
            //   0f8495010000         | je                  0x19b
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   85c0                 | test                eax, eax
            //   7409                 | je                  0xb
            //   83f803               | cmp                 eax, 3

        $sequence_4 = { 31c0 40 31ff 31db }
            // n = 4, score = 400
            //   31c0                 | xor                 eax, eax
            //   40                   | inc                 eax
            //   31ff                 | xor                 edi, edi
            //   31db                 | xor                 ebx, ebx

        $sequence_5 = { 0fb7ce 25ff030000 c1e00a 81e1ff030000 }
            // n = 4, score = 400
            //   0fb7ce               | movzx               ecx, si
            //   25ff030000           | and                 eax, 0x3ff
            //   c1e00a               | shl                 eax, 0xa
            //   81e1ff030000         | and                 ecx, 0x3ff

        $sequence_6 = { 31c8 31cf 29c8 19cf 3d10270000 }
            // n = 5, score = 400
            //   31c8                 | xor                 eax, ecx
            //   31cf                 | xor                 edi, ecx
            //   29c8                 | sub                 eax, ecx
            //   19cf                 | sbb                 edi, ecx
            //   3d10270000           | cmp                 eax, 0x2710

        $sequence_7 = { 31c0 40 81fd80000000 721b b802000000 81fd00080000 720e }
            // n = 7, score = 400
            //   31c0                 | xor                 eax, eax
            //   40                   | inc                 eax
            //   81fd80000000         | cmp                 ebp, 0x80
            //   721b                 | jb                  0x1d
            //   b802000000           | mov                 eax, 2
            //   81fd00080000         | cmp                 ebp, 0x800
            //   720e                 | jb                  0x10

        $sequence_8 = { 034a10 894de0 8b45e0 3b45dc 7606 8b4de0 894ddc }
            // n = 7, score = 200
            //   034a10               | add                 ecx, dword ptr [edx + 0x10]
            //   894de0               | mov                 dword ptr [ebp - 0x20], ecx
            //   8b45e0               | mov                 eax, dword ptr [ebp - 0x20]
            //   3b45dc               | cmp                 eax, dword ptr [ebp - 0x24]
            //   7606                 | jbe                 8
            //   8b4de0               | mov                 ecx, dword ptr [ebp - 0x20]
            //   894ddc               | mov                 dword ptr [ebp - 0x24], ecx

        $sequence_9 = { 034214 50 8b4df8 51 e8???????? }
            // n = 5, score = 200
            //   034214               | add                 eax, dword ptr [edx + 0x14]
            //   50                   | push                eax
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   51                   | push                ecx
            //   e8????????           |                     

        $sequence_10 = { ffd1 83c408 ebbc 8b55fc 8b4208 50 e8???????? }
            // n = 7, score = 200
            //   ffd1                 | call                ecx
            //   83c408               | add                 esp, 8
            //   ebbc                 | jmp                 0xffffffbe
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   8b4208               | mov                 eax, dword ptr [edx + 8]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_11 = { 034110 50 8b550c 52 8b4de8 e8???????? }
            // n = 6, score = 200
            //   034110               | add                 eax, dword ptr [ecx + 0x10]
            //   50                   | push                eax
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]
            //   52                   | push                edx
            //   8b4de8               | mov                 ecx, dword ptr [ebp - 0x18]
            //   e8????????           |                     

        $sequence_12 = { 034228 8945c4 6a00 6a01 6800000010 }
            // n = 5, score = 200
            //   034228               | add                 eax, dword ptr [edx + 0x28]
            //   8945c4               | mov                 dword ptr [ebp - 0x3c], eax
            //   6a00                 | push                0
            //   6a01                 | push                1
            //   6800000010           | push                0x10000000

        $sequence_13 = { 034828 8b55fc 894a2c eb0a }
            // n = 4, score = 200
            //   034828               | add                 ecx, dword ptr [eax + 0x28]
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   894a2c               | mov                 dword ptr [edx + 0x2c], ecx
            //   eb0a                 | jmp                 0xc

        $sequence_14 = { 0345e8 2b45d4 8945dc e9???????? }
            // n = 4, score = 200
            //   0345e8               | add                 eax, dword ptr [ebp - 0x18]
            //   2b45d4               | sub                 eax, dword ptr [ebp - 0x2c]
            //   8945dc               | mov                 dword ptr [ebp - 0x24], eax
            //   e9????????           |                     

        $sequence_15 = { 03420c 50 ff15???????? 8945f8 837df800 }
            // n = 5, score = 200
            //   03420c               | add                 eax, dword ptr [edx + 0xc]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   837df800             | cmp                 dword ptr [ebp - 8], 0

    condition:
        7 of them and filesize < 4950016
}