rule win_suppobox_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.suppobox."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.suppobox"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 3bc8 7d10 a1???????? 2b05???????? }
            // n = 4, score = 200
            //   3bc8                 | cmp                 ecx, eax
            //   7d10                 | jge                 0x12
            //   a1????????           |                     
            //   2b05????????         |                     

        $sequence_1 = { 7412 8b0d???????? 030d???????? 890d???????? }
            // n = 4, score = 200
            //   7412                 | je                  0x14
            //   8b0d????????         |                     
            //   030d????????         |                     
            //   890d????????         |                     

        $sequence_2 = { 7412 a1???????? 2b05???????? a3???????? }
            // n = 4, score = 200
            //   7412                 | je                  0x14
            //   a1????????           |                     
            //   2b05????????         |                     
            //   a3????????           |                     

        $sequence_3 = { 8945f0 a1???????? 83e801 a3???????? }
            // n = 4, score = 200
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   a1????????           |                     
            //   83e801               | sub                 eax, 1
            //   a3????????           |                     

        $sequence_4 = { 7e10 a1???????? 0305???????? a3???????? }
            // n = 4, score = 200
            //   7e10                 | jle                 0x12
            //   a1????????           |                     
            //   0305????????         |                     
            //   a3????????           |                     

        $sequence_5 = { 7d10 a1???????? 3305???????? a3???????? }
            // n = 4, score = 200
            //   7d10                 | jge                 0x12
            //   a1????????           |                     
            //   3305????????         |                     
            //   a3????????           |                     

        $sequence_6 = { 890d???????? e8???????? 8bf0 e8???????? 03f0 }
            // n = 5, score = 200
            //   890d????????         |                     
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   e8????????           |                     
            //   03f0                 | add                 esi, eax

        $sequence_7 = { 01c6 39fe 0f8d2f020000 80bc2ef4f7ffff0a }
            // n = 4, score = 100
            //   01c6                 | add                 esi, eax
            //   39fe                 | cmp                 esi, edi
            //   0f8d2f020000         | jge                 0x235
            //   80bc2ef4f7ffff0a     | cmp                 byte ptr [esi + ebp - 0x80c], 0xa

        $sequence_8 = { 01c6 ebdb ff7510 57 }
            // n = 4, score = 100
            //   01c6                 | add                 esi, eax
            //   ebdb                 | jmp                 0xffffffdd
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   57                   | push                edi

        $sequence_9 = { 8d4801 83c601 39f7 898b00010000 881403 }
            // n = 5, score = 100
            //   8d4801               | lea                 ecx, [eax + 1]
            //   83c601               | add                 esi, 1
            //   39f7                 | cmp                 edi, esi
            //   898b00010000         | mov                 dword ptr [ebx + 0x100], ecx
            //   881403               | mov                 byte ptr [ebx + eax], dl

        $sequence_10 = { 8d4801 894ddc 0fbf4dd4 01c8 }
            // n = 4, score = 100
            //   8d4801               | lea                 ecx, [eax + 1]
            //   894ddc               | mov                 dword ptr [ebp - 0x24], ecx
            //   0fbf4dd4             | movsx               ecx, word ptr [ebp - 0x2c]
            //   01c8                 | add                 eax, ecx

        $sequence_11 = { 01c6 39fe 0f8d7e010000 80bc2ef4f7ffff0a }
            // n = 4, score = 100
            //   01c6                 | add                 esi, eax
            //   39fe                 | cmp                 esi, edi
            //   0f8d7e010000         | jge                 0x184
            //   80bc2ef4f7ffff0a     | cmp                 byte ptr [esi + ebp - 0x80c], 0xa

        $sequence_12 = { 8d4801 894e0c 0fb65001 80fa5f 0f94c3 }
            // n = 5, score = 100
            //   8d4801               | lea                 ecx, [eax + 1]
            //   894e0c               | mov                 dword ptr [esi + 0xc], ecx
            //   0fb65001             | movzx               edx, byte ptr [eax + 1]
            //   80fa5f               | cmp                 dl, 0x5f
            //   0f94c3               | sete                bl

        $sequence_13 = { 01bdacf7ffff 83c40c 83bdc8f7ffff00 8b95c8f7ffff }
            // n = 4, score = 100
            //   01bdacf7ffff         | add                 dword ptr [ebp - 0x854], edi
            //   83c40c               | add                 esp, 0xc
            //   83bdc8f7ffff00       | cmp                 dword ptr [ebp - 0x838], 0
            //   8b95c8f7ffff         | mov                 edx, dword ptr [ebp - 0x838]

        $sequence_14 = { 8d4801 890d???????? 8d8402199951bd dd8500f9ffff }
            // n = 4, score = 100
            //   8d4801               | lea                 ecx, [eax + 1]
            //   890d????????         |                     
            //   8d8402199951bd       | lea                 eax, [edx + eax - 0x42ae66e7]
            //   dd8500f9ffff         | fld                 qword ptr [ebp - 0x700]

        $sequence_15 = { 8d4801 8d8402ec432105 3d182b4547 890d???????? }
            // n = 4, score = 100
            //   8d4801               | lea                 ecx, [eax + 1]
            //   8d8402ec432105       | lea                 eax, [edx + eax + 0x52143ec]
            //   3d182b4547           | cmp                 eax, 0x47452b18
            //   890d????????         |                     

        $sequence_16 = { 01d7 68???????? 57 e8???????? }
            // n = 4, score = 100
            //   01d7                 | add                 edi, edx
            //   68????????           |                     
            //   57                   | push                edi
            //   e8????????           |                     

        $sequence_17 = { 8d4801 83c601 39fe 898b00010000 }
            // n = 4, score = 100
            //   8d4801               | lea                 ecx, [eax + 1]
            //   83c601               | add                 esi, 1
            //   39fe                 | cmp                 esi, edi
            //   898b00010000         | mov                 dword ptr [ebx + 0x100], ecx

        $sequence_18 = { 8d4801 83c601 81fe???????? 898b00010000 }
            // n = 4, score = 100
            //   8d4801               | lea                 ecx, [eax + 1]
            //   83c601               | add                 esi, 1
            //   81fe????????         |                     
            //   898b00010000         | mov                 dword ptr [ebx + 0x100], ecx

        $sequence_19 = { 01c9 4a 79f2 833b54 }
            // n = 4, score = 100
            //   01c9                 | add                 ecx, ecx
            //   4a                   | dec                 edx
            //   79f2                 | jns                 0xfffffff4
            //   833b54               | cmp                 dword ptr [ebx], 0x54

        $sequence_20 = { 01d8 3b85b0f7ffff 7e2f 8b95c8f7ffff }
            // n = 4, score = 100
            //   01d8                 | add                 eax, ebx
            //   3b85b0f7ffff         | cmp                 eax, dword ptr [ebp - 0x850]
            //   7e2f                 | jle                 0x31
            //   8b95c8f7ffff         | mov                 edx, dword ptr [ebp - 0x838]

        $sequence_21 = { 019dacf7ffff 83c40c 299dc4f7ffff e9???????? }
            // n = 4, score = 100
            //   019dacf7ffff         | add                 dword ptr [ebp - 0x854], ebx
            //   83c40c               | add                 esp, 0xc
            //   299dc4f7ffff         | sub                 dword ptr [ebp - 0x83c], ebx
            //   e9????????           |                     

    condition:
        7 of them and filesize < 1875968
}