rule win_svcready_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.svcready."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.svcready"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 33ce 33fd f7d0 c1cd03 8bd1 0bd0 }
            // n = 6, score = 500
            //   33ce                 | xor                 ecx, esi
            //   33fd                 | xor                 edi, ebp
            //   f7d0                 | not                 eax
            //   c1cd03               | ror                 ebp, 3
            //   8bd1                 | mov                 edx, ecx
            //   0bd0                 | or                  edx, eax

        $sequence_1 = { 8b400c 8b400c 8b7018 89442428 8974242c 8b4e3c 8b543178 }
            // n = 7, score = 500
            //   8b400c               | mov                 eax, dword ptr [eax + 0xc]
            //   8b400c               | mov                 eax, dword ptr [eax + 0xc]
            //   8b7018               | mov                 esi, dword ptr [eax + 0x18]
            //   89442428             | mov                 dword ptr [esp + 0x28], eax
            //   8974242c             | mov                 dword ptr [esp + 0x2c], esi
            //   8b4e3c               | mov                 ecx, dword ptr [esi + 0x3c]
            //   8b543178             | mov                 edx, dword ptr [ecx + esi + 0x78]

        $sequence_2 = { 33cd 33c1 a3???????? 8bc6 33c2 a3???????? 8b442410 }
            // n = 7, score = 500
            //   33cd                 | xor                 ecx, ebp
            //   33c1                 | xor                 eax, ecx
            //   a3????????           |                     
            //   8bc6                 | mov                 eax, esi
            //   33c2                 | xor                 eax, edx
            //   a3????????           |                     
            //   8b442410             | mov                 eax, dword ptr [esp + 0x10]

        $sequence_3 = { 58 83c23c 03d6 89542420 3bc8 7d35 83f904 }
            // n = 7, score = 500
            //   58                   | pop                 eax
            //   83c23c               | add                 edx, 0x3c
            //   03d6                 | add                 edx, esi
            //   89542420             | mov                 dword ptr [esp + 0x20], edx
            //   3bc8                 | cmp                 ecx, eax
            //   7d35                 | jge                 0x37
            //   83f904               | cmp                 ecx, 4

        $sequence_4 = { 3905???????? 0f95c0 c3 e9???????? 55 8bec 6a00 }
            // n = 7, score = 500
            //   3905????????         |                     
            //   0f95c0               | setne               al
            //   c3                   | ret                 
            //   e9????????           |                     
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   6a00                 | push                0

        $sequence_5 = { 3315???????? 33d9 8bf2 8bcb 3335???????? 33ca 33ee }
            // n = 7, score = 500
            //   3315????????         |                     
            //   33d9                 | xor                 ebx, ecx
            //   8bf2                 | mov                 esi, edx
            //   8bcb                 | mov                 ecx, ebx
            //   3335????????         |                     
            //   33ca                 | xor                 ecx, edx
            //   33ee                 | xor                 ebp, esi

        $sequence_6 = { 747f 3d00010000 743e 57 56 ff7514 8d44241c }
            // n = 7, score = 500
            //   747f                 | je                  0x81
            //   3d00010000           | cmp                 eax, 0x100
            //   743e                 | je                  0x40
            //   57                   | push                edi
            //   56                   | push                esi
            //   ff7514               | push                dword ptr [ebp + 0x14]
            //   8d44241c             | lea                 eax, [esp + 0x1c]

        $sequence_7 = { 53 8bd9 c744242000000000 56 8b08 8b4004 }
            // n = 6, score = 500
            //   53                   | push                ebx
            //   8bd9                 | mov                 ebx, ecx
            //   c744242000000000     | mov                 dword ptr [esp + 0x20], 0
            //   56                   | push                esi
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   8b4004               | mov                 eax, dword ptr [eax + 4]

        $sequence_8 = { 89442424 8974244c 895c2450 e8???????? 8b4c2424 c6043100 894c243c }
            // n = 7, score = 500
            //   89442424             | mov                 dword ptr [esp + 0x24], eax
            //   8974244c             | mov                 dword ptr [esp + 0x4c], esi
            //   895c2450             | mov                 dword ptr [esp + 0x50], ebx
            //   e8????????           |                     
            //   8b4c2424             | mov                 ecx, dword ptr [esp + 0x24]
            //   c6043100             | mov                 byte ptr [ecx + esi], 0
            //   894c243c             | mov                 dword ptr [esp + 0x3c], ecx

        $sequence_9 = { 50 ff760c ff15???????? 6a06 8d4c2424 51 }
            // n = 6, score = 500
            //   50                   | push                eax
            //   ff760c               | push                dword ptr [esi + 0xc]
            //   ff15????????         |                     
            //   6a06                 | push                6
            //   8d4c2424             | lea                 ecx, [esp + 0x24]
            //   51                   | push                ecx

    condition:
        7 of them and filesize < 1187840
}