rule win_threebyte_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.threebyte."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.threebyte"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 85c0 7411 8b55b8 52 ff15???????? 33c0 e9???????? }
            // n = 7, score = 200
            //   85c0                 | test                eax, eax
            //   7411                 | je                  0x13
            //   8b55b8               | mov                 edx, dword ptr [ebp - 0x48]
            //   52                   | push                edx
            //   ff15????????         |                     
            //   33c0                 | xor                 eax, eax
            //   e9????????           |                     

        $sequence_1 = { 8b85f0fdffff 8b08 8b95f0fdffff 52 ff510c 8985ecfdffff 83bdecfdffff00 }
            // n = 7, score = 200
            //   8b85f0fdffff         | mov                 eax, dword ptr [ebp - 0x210]
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   8b95f0fdffff         | mov                 edx, dword ptr [ebp - 0x210]
            //   52                   | push                edx
            //   ff510c               | call                dword ptr [ecx + 0xc]
            //   8985ecfdffff         | mov                 dword ptr [ebp - 0x214], eax
            //   83bdecfdffff00       | cmp                 dword ptr [ebp - 0x214], 0

        $sequence_2 = { c78524f7ffff00000000 c78514f7ffff00000000 8d8514f7ffff 50 8b8d18f7ffff 2b8d24f7ffff }
            // n = 6, score = 200
            //   c78524f7ffff00000000     | mov    dword ptr [ebp - 0x8dc], 0
            //   c78514f7ffff00000000     | mov    dword ptr [ebp - 0x8ec], 0
            //   8d8514f7ffff         | lea                 eax, [ebp - 0x8ec]
            //   50                   | push                eax
            //   8b8d18f7ffff         | mov                 ecx, dword ptr [ebp - 0x8e8]
            //   2b8d24f7ffff         | sub                 ecx, dword ptr [ebp - 0x8dc]

        $sequence_3 = { c6851cf8ffff73 c6851df8ffff00 8d85ccfcffff 50 6804010000 ff15???????? 8d8decfeffff }
            // n = 7, score = 200
            //   c6851cf8ffff73       | mov                 byte ptr [ebp - 0x7e4], 0x73
            //   c6851df8ffff00       | mov                 byte ptr [ebp - 0x7e3], 0
            //   8d85ccfcffff         | lea                 eax, [ebp - 0x334]
            //   50                   | push                eax
            //   6804010000           | push                0x104
            //   ff15????????         |                     
            //   8d8decfeffff         | lea                 ecx, [ebp - 0x114]

        $sequence_4 = { c685d2fdffff74 c685d3fdffff65 c685d4fdffff72 c685d5fdffff6e c685d6fdffff65 c685d7fdffff74 c685d8fdffff20 }
            // n = 7, score = 200
            //   c685d2fdffff74       | mov                 byte ptr [ebp - 0x22e], 0x74
            //   c685d3fdffff65       | mov                 byte ptr [ebp - 0x22d], 0x65
            //   c685d4fdffff72       | mov                 byte ptr [ebp - 0x22c], 0x72
            //   c685d5fdffff6e       | mov                 byte ptr [ebp - 0x22b], 0x6e
            //   c685d6fdffff65       | mov                 byte ptr [ebp - 0x22a], 0x65
            //   c685d7fdffff74       | mov                 byte ptr [ebp - 0x229], 0x74
            //   c685d8fdffff20       | mov                 byte ptr [ebp - 0x228], 0x20

        $sequence_5 = { ff500c 8b4df0 51 e8???????? 83c404 83c8ff e9???????? }
            // n = 7, score = 200
            //   ff500c               | call                dword ptr [eax + 0xc]
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   83c8ff               | or                  eax, 0xffffffff
            //   e9????????           |                     

        $sequence_6 = { 50 e8???????? 83c408 8945cc e9???????? c6852cfeffff77 c6852dfeffff69 }
            // n = 7, score = 200
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   8945cc               | mov                 dword ptr [ebp - 0x34], eax
            //   e9????????           |                     
            //   c6852cfeffff77       | mov                 byte ptr [ebp - 0x1d4], 0x77
            //   c6852dfeffff69       | mov                 byte ptr [ebp - 0x1d3], 0x69

        $sequence_7 = { 8d956cf7ffff 52 e8???????? 83c418 6a00 6800000004 }
            // n = 6, score = 200
            //   8d956cf7ffff         | lea                 edx, [ebp - 0x894]
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c418               | add                 esp, 0x18
            //   6a00                 | push                0
            //   6800000004           | push                0x4000000

        $sequence_8 = { 83c101 51 6a00 8b9520f7ffff 52 e8???????? 83c40c }
            // n = 7, score = 200
            //   83c101               | add                 ecx, 1
            //   51                   | push                ecx
            //   6a00                 | push                0
            //   8b9520f7ffff         | mov                 edx, dword ptr [ebp - 0x8e0]
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc

        $sequence_9 = { c68515feffff75 c68516feffff6e c68517feffff20 c68518feffff00 c68524feffff73 c68525feffff6c c68526feffff65 }
            // n = 7, score = 200
            //   c68515feffff75       | mov                 byte ptr [ebp - 0x1eb], 0x75
            //   c68516feffff6e       | mov                 byte ptr [ebp - 0x1ea], 0x6e
            //   c68517feffff20       | mov                 byte ptr [ebp - 0x1e9], 0x20
            //   c68518feffff00       | mov                 byte ptr [ebp - 0x1e8], 0
            //   c68524feffff73       | mov                 byte ptr [ebp - 0x1dc], 0x73
            //   c68525feffff6c       | mov                 byte ptr [ebp - 0x1db], 0x6c
            //   c68526feffff65       | mov                 byte ptr [ebp - 0x1da], 0x65

    condition:
        7 of them and filesize < 180224
}