rule win_tigerlite_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.tigerlite."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.tigerlite"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 754a 488d0d2b4a0000 e8???????? 488d15fb130100 488d0dd4130100 e8???????? }
            // n = 6, score = 100
            //   754a                 | jne                 0xd
            //   488d0d2b4a0000       | jne                 0x4c
            //   e8????????           |                     
            //   488d15fb130100       | dec                 eax
            //   488d0dd4130100       | lea                 ecx, [0x4a2b]
            //   e8????????           |                     

        $sequence_1 = { 488bd8 e8???????? 488bcb ff15???????? 488bcb 488bf8 e8???????? }
            // n = 7, score = 100
            //   488bd8               | lea                 edx, [esp + 0x30]
            //   e8????????           |                     
            //   488bcb               | mov                 word ptr [esp + 0x20], ax
            //   ff15????????         |                     
            //   488bcb               | dec                 ebp
            //   488bf8               | mov                 edi, ecx
            //   e8????????           |                     

        $sequence_2 = { eb0f 8b45f4 8b0485489d4100 804c180402 }
            // n = 4, score = 100
            //   eb0f                 | mov                 edi, eax
            //   8b45f4               | dec                 eax
            //   8b0485489d4100       | mov                 edx, edi
            //   804c180402           | cmp                 eax, -1

        $sequence_3 = { 48890d???????? 488905???????? 488d0517410000 48890d???????? 488905???????? }
            // n = 5, score = 100
            //   48890d????????       |                     
            //   488905????????       |                     
            //   488d0517410000       | dec                 eax
            //   48890d????????       |                     
            //   488905????????       |                     

        $sequence_4 = { 83e11f c1e106 8b0485489d4100 80640804fe ff15???????? 50 }
            // n = 6, score = 100
            //   83e11f               | mov                 esi, ecx
            //   c1e106               | movdqu              xmmword ptr [ebp - 0x17], xmm0
            //   8b0485489d4100       | jmp                 0x11
            //   80640804fe           | mov                 eax, dword ptr [ebp - 0xc]
            //   ff15????????         |                     
            //   50                   | mov                 eax, dword ptr [eax*4 + 0x419d48]

        $sequence_5 = { 488bd7 ff15???????? 83f8ff 0f8465020000 488d4c2451 33d2 41b8ff030000 }
            // n = 7, score = 100
            //   488bd7               | mov                 byte ptr [esp + 0x22], al
            //   ff15????????         |                     
            //   83f8ff               | dec                 eax
            //   0f8465020000         | arpl                dx, ax
            //   488d4c2451           | dec                 eax
            //   33d2                 | arpl                cx, cx
            //   41b8ff030000         | dec                 eax

        $sequence_6 = { 33c5 8945fc 53 56 8d85a4faffff 57 50 }
            // n = 7, score = 100
            //   33c5                 | je                  0x26e
            //   8945fc               | dec                 eax
            //   53                   | lea                 ecx, [esp + 0x51]
            //   56                   | xor                 edx, edx
            //   8d85a4faffff         | inc                 ecx
            //   57                   | mov                 eax, 0x3ff
            //   50                   | inc                 ecx

        $sequence_7 = { 2b349d489d4100 c1fe06 8bc3 c1e005 03f0 8975e4 }
            // n = 6, score = 100
            //   2b349d489d4100       | dec                 eax
            //   c1fe06               | lea                 edx, [0x1c5a8]
            //   8bc3                 | dec                 eax
            //   c1e005               | mov                 ecx, esi
            //   03f0                 | push                0x20
            //   8975e4               | mov                 edi, edx

        $sequence_8 = { 33c0 c644244000 3905???????? 89442441 750b }
            // n = 5, score = 100
            //   33c0                 | lea                 eax, [0x4117]
            //   c644244000           | xor                 eax, eax
            //   3905????????         |                     
            //   89442441             | mov                 byte ptr [esp + 0x40], 0
            //   750b                 | mov                 dword ptr [esp + 0x41], eax

        $sequence_9 = { 488d15bfd20000 483305???????? 488bcb 488905???????? ff15???????? 488d15b9d20000 }
            // n = 6, score = 100
            //   488d15bfd20000       | dec                 eax
            //   483305????????       |                     
            //   488bcb               | lea                 edx, [0x113fb]
            //   488905????????       |                     
            //   ff15????????         |                     
            //   488d15b9d20000       | dec                 eax

        $sequence_10 = { 6a20 8bfa 8bf1 f30f7f45e9 }
            // n = 4, score = 100
            //   6a20                 | mov                 ecx, ebx
            //   8bfa                 | dec                 eax
            //   8bf1                 | mov                 ecx, ebx
            //   f30f7f45e9           | dec                 eax

        $sequence_11 = { 7e32 0fb617 0fb64701 83e203 c1e804 03d2 }
            // n = 6, score = 100
            //   7e32                 | push                ebx
            //   0fb617               | push                esi
            //   0fb64701             | lea                 eax, [ebp - 0x55c]
            //   83e203               | push                edi
            //   c1e804               | push                eax
            //   03d2                 | push                esi

        $sequence_12 = { 56 33f6 ffb644854100 ff15???????? 898644854100 83c604 }
            // n = 6, score = 100
            //   56                   | mov                 eax, 0x10
            //   33f6                 | dec                 eax
            //   ffb644854100         | mov                 ecx, eax
            //   ff15????????         |                     
            //   898644854100         | cmp                 eax, -1
            //   83c604               | jne                 0x73

        $sequence_13 = { 7405 b9???????? e8???????? 833d????????06 750c eb27 c705????????00000000 }
            // n = 7, score = 100
            //   7405                 | or                  byte ptr [eax + ebx + 4], 2
            //   b9????????           |                     
            //   e8????????           |                     
            //   833d????????06       |                     
            //   750c                 | xor                 eax, ebp
            //   eb27                 | mov                 dword ptr [ebp - 4], eax
            //   c705????????00000000     |     

        $sequence_14 = { 488d542430 6689442420 0fb605???????? 4d8bf9 88442422 8b05???????? }
            // n = 6, score = 100
            //   488d542430           | lea                 ecx, [0x113d4]
            //   6689442420           | dec                 eax
            //   0fb605????????       |                     
            //   4d8bf9               | lea                 edx, [0xd2bf]
            //   88442422             | dec                 eax
            //   8b05????????         |                     

        $sequence_15 = { 4863c2 4863c9 488d14c8 420fbe940ab0730100 }
            // n = 4, score = 100
            //   4863c2               | mov                 ecx, ebx
            //   4863c9               | dec                 eax
            //   488d14c8             | lea                 edx, [0xd2b9]
            //   420fbe940ab0730100     | dec    eax

    condition:
        7 of them and filesize < 349184
}