rule win_tildeb_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.tildeb."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.tildeb"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83c404 51 ffd3 f6460c10 74a3 5d 8b5c2410 }
            // n = 7, score = 100
            //   83c404               | add                 esp, 4
            //   51                   | push                ecx
            //   ffd3                 | call                ebx
            //   f6460c10             | test                byte ptr [esi + 0xc], 0x10
            //   74a3                 | je                  0xffffffa5
            //   5d                   | pop                 ebp
            //   8b5c2410             | mov                 ebx, dword ptr [esp + 0x10]

        $sequence_1 = { 51 52 50 56 ffd7 8b542414 8b1d???????? }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   52                   | push                edx
            //   50                   | push                eax
            //   56                   | push                esi
            //   ffd7                 | call                edi
            //   8b542414             | mov                 edx, dword ptr [esp + 0x14]
            //   8b1d????????         |                     

        $sequence_2 = { 5e 81c494010000 c3 b808000000 5e }
            // n = 5, score = 100
            //   5e                   | pop                 esi
            //   81c494010000         | add                 esp, 0x194
            //   c3                   | ret                 
            //   b808000000           | mov                 eax, 8
            //   5e                   | pop                 esi

        $sequence_3 = { 56 57 8965e8 6a40 ff15???????? 50 ff15???????? }
            // n = 7, score = 100
            //   56                   | push                esi
            //   57                   | push                edi
            //   8965e8               | mov                 dword ptr [ebp - 0x18], esp
            //   6a40                 | push                0x40
            //   ff15????????         |                     
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_4 = { 8b0d???????? 51 ff15???????? e9???????? 6a00 6a02 68???????? }
            // n = 7, score = 100
            //   8b0d????????         |                     
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   e9????????           |                     
            //   6a00                 | push                0
            //   6a02                 | push                2
            //   68????????           |                     

        $sequence_5 = { 33dd 8bac24b4000000 33dd 8bac24ac000000 33dd 8bac24d0000000 }
            // n = 6, score = 100
            //   33dd                 | xor                 ebx, ebp
            //   8bac24b4000000       | mov                 ebp, dword ptr [esp + 0xb4]
            //   33dd                 | xor                 ebx, ebp
            //   8bac24ac000000       | mov                 ebp, dword ptr [esp + 0xac]
            //   33dd                 | xor                 ebx, ebp
            //   8bac24d0000000       | mov                 ebp, dword ptr [esp + 0xd0]

        $sequence_6 = { 8b442414 c6400101 8b442410 85c0 744b }
            // n = 5, score = 100
            //   8b442414             | mov                 eax, dword ptr [esp + 0x14]
            //   c6400101             | mov                 byte ptr [eax + 1], 1
            //   8b442410             | mov                 eax, dword ptr [esp + 0x10]
            //   85c0                 | test                eax, eax
            //   744b                 | je                  0x4d

        $sequence_7 = { 0bd9 8b8c24ac000000 33ea 03cb 33ef 03e9 }
            // n = 6, score = 100
            //   0bd9                 | or                  ebx, ecx
            //   8b8c24ac000000       | mov                 ecx, dword ptr [esp + 0xac]
            //   33ea                 | xor                 ebp, edx
            //   03cb                 | add                 ecx, ebx
            //   33ef                 | xor                 ebp, edi
            //   03e9                 | add                 ebp, ecx

        $sequence_8 = { 5b c3 8b3d???????? 6a02 53 56 ffd7 }
            // n = 7, score = 100
            //   5b                   | pop                 ebx
            //   c3                   | ret                 
            //   8b3d????????         |                     
            //   6a02                 | push                2
            //   53                   | push                ebx
            //   56                   | push                esi
            //   ffd7                 | call                edi

        $sequence_9 = { bf???????? f3ab 8d85e4f9ffff 50 8b8ddbf5ffff 81e1ff000000 51 }
            // n = 7, score = 100
            //   bf????????           |                     
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   8d85e4f9ffff         | lea                 eax, [ebp - 0x61c]
            //   50                   | push                eax
            //   8b8ddbf5ffff         | mov                 ecx, dword ptr [ebp - 0xa25]
            //   81e1ff000000         | and                 ecx, 0xff
            //   51                   | push                ecx

    condition:
        7 of them and filesize < 8532488
}