rule win_tinyturla_ng_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.tinyturla_ng."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.tinyturla_ng"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0f118090000000 8b81a0000000 418980a0000000 0fb781a4000000 66418980a4000000 4188b8a6000000 4c89442420 }
            // n = 7, score = 200
            //   0f118090000000       | je                  0x61e
            //   8b81a0000000         | mov                 eax, dword ptr [esp + 0x64]
            //   418980a0000000       | cmp                 eax, 5
            //   0fb781a4000000       | je                  0x617
            //   66418980a4000000     | test                eax, eax
            //   4188b8a6000000       | je                  0x62e
            //   4c89442420           | dec                 eax

        $sequence_1 = { 48897570 4c897578 c6456000 eb0d 488b5d40 41be0f000000 4032ff }
            // n = 7, score = 200
            //   48897570             | dec                 eax
            //   4c897578             | mov                 eax, ebx
            //   c6456000             | dec                 eax
            //   eb0d                 | cmp                 ebp, 8
            //   488b5d40             | jb                  0x749
            //   41be0f000000         | dec                 eax
            //   4032ff               | mov                 eax, dword ptr [ebx]

        $sequence_2 = { 498bdd 492bdc 48c1fb05 488bd3 488d4c2460 e8???????? 488bf8 }
            // n = 7, score = 200
            //   498bdd               | cmovae              edx, edi
            //   492bdc               | dec                 eax
            //   48c1fb05             | cmp                 esi, 4
            //   488bd3               | jne                 0x4a
            //   488d4c2460           | dec                 ecx
            //   e8????????           |                     
            //   488bf8               | mov                 ecx, esi

        $sequence_3 = { 0f114510 c745c068000000 c745fc00010000 488b442460 48894520 48894518 488b442468 }
            // n = 7, score = 200
            //   0f114510             | lea                 edx, [esp + 0x50]
            //   c745c068000000       | dec                 ecx
            //   c745fc00010000       | mov                 dword ptr [edi + 0x240], eax
            //   488b442460           | dec                 ecx
            //   48894520             | mov                 eax, edi
            //   48894518             | dec                 eax
            //   488b442468           | add                 esp, 0x20

        $sequence_4 = { 837c243800 7474 e8???????? 39442438 7474 0f28442430 660f7f442440 }
            // n = 7, score = 200
            //   837c243800           | dec                 esp
            //   7474                 | mov                 dword ptr [esp + 0x48], esi
            //   e8????????           |                     
            //   39442438             | dec                 eax
            //   7474                 | mov                 dword ptr [esp + 0x50], esi
            //   0f28442430           | je                  0x626
            //   660f7f442440         | dec                 eax

        $sequence_5 = { 488bce e8???????? b001 488b4df0 4833cc e8???????? }
            // n = 6, score = 200
            //   488bce               | mov                 ecx, edi
            //   e8????????           |                     
            //   b001                 | dec                 eax
            //   488b4df0             | mov                 dword ptr [esp + 8], ebx
            //   4833cc               | push                edi
            //   e8????????           |                     

        $sequence_6 = { e8???????? 84c0 0f8450010000 498d4d08 e8???????? 33f6 e9???????? }
            // n = 7, score = 200
            //   e8????????           |                     
            //   84c0                 | dec                 ecx
            //   0f8450010000         | mov                 dword ptr [ebx + 0x10], ebx
            //   498d4d08             | les                 esp, ptr [ecx - 0x3ddba6a5]
            //   e8????????           |                     
            //   33f6                 | vmovapd             xmm7, xmm4
            //   e9????????           |                     

        $sequence_7 = { 48b82700000000000080 eb27 4883fb16 b816000000 480f42d8 488d4b01 }
            // n = 6, score = 200
            //   48b82700000000000080     | lea    edx, [0x21e8b]
            //   eb27                 | dec                 eax
            //   4883fb16             | mov                 ecx, ebx
            //   b816000000           | dec                 eax
            //   480f42d8             | lea                 edx, [0x21e8c]
            //   488d4b01             | dec                 eax

        $sequence_8 = { e8???????? 488b45f0 4883f810 7232 488d5001 488b4dd8 488bc1 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   488b45f0             | mov                 eax, edx
            //   4883f810             | mov                 ecx, 7
            //   7232                 | mov                 eax, edi
            //   488d5001             | jmp                 0xffffffca
            //   488b4dd8             | dec                 eax
            //   488bc1               | arpl                cx, dx

        $sequence_9 = { 7734 498bc8 e8???????? 4c8933 48c1e605 4903f6 }
            // n = 6, score = 200
            //   7734                 | jmp                 0x36d
            //   498bc8               | dec                 eax
            //   e8????????           |                     
            //   4c8933               | mov                 eax, 0xffffffff
            //   48c1e605             | dec                 eax
            //   4903f6               | mov                 ecx, dword ptr [esp + 0x120]

    condition:
        7 of them and filesize < 635904
}