rule win_unidentified_003_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.unidentified_003."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_003"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? c70424???????? e8???????? 59 68???????? 891d???????? 891d???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   c70424????????       |                     
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   68????????           |                     
            //   891d????????         |                     
            //   891d????????         |                     

        $sequence_1 = { 83c40c 895de8 8b45ec 8b08 8d55f0 52 53 }
            // n = 7, score = 100
            //   83c40c               | add                 esp, 0xc
            //   895de8               | mov                 dword ptr [ebp - 0x18], ebx
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   8d55f0               | lea                 edx, [ebp - 0x10]
            //   52                   | push                edx
            //   53                   | push                ebx

        $sequence_2 = { 56 68???????? ff75f8 ff15???????? ff75dc ff7508 }
            // n = 6, score = 100
            //   56                   | push                esi
            //   68????????           |                     
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   ff15????????         |                     
            //   ff75dc               | push                dword ptr [ebp - 0x24]
            //   ff7508               | push                dword ptr [ebp + 8]

        $sequence_3 = { 68???????? e8???????? 56 68???????? e8???????? 83c410 8bc3 }
            // n = 7, score = 100
            //   68????????           |                     
            //   e8????????           |                     
            //   56                   | push                esi
            //   68????????           |                     
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   8bc3                 | mov                 eax, ebx

        $sequence_4 = { 6a00 6a00 68???????? ff55fc eb07 50 }
            // n = 6, score = 100
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   68????????           |                     
            //   ff55fc               | call                dword ptr [ebp - 4]
            //   eb07                 | jmp                 9
            //   50                   | push                eax

        $sequence_5 = { b8???????? 85c0 7420 ff750c 53 ff7644 e8???????? }
            // n = 7, score = 100
            //   b8????????           |                     
            //   85c0                 | test                eax, eax
            //   7420                 | je                  0x22
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   53                   | push                ebx
            //   ff7644               | push                dword ptr [esi + 0x44]
            //   e8????????           |                     

        $sequence_6 = { 57 8bf8 33f6 8bd9 3bfe 7502 8bfb }
            // n = 7, score = 100
            //   57                   | push                edi
            //   8bf8                 | mov                 edi, eax
            //   33f6                 | xor                 esi, esi
            //   8bd9                 | mov                 ebx, ecx
            //   3bfe                 | cmp                 edi, esi
            //   7502                 | jne                 4
            //   8bfb                 | mov                 edi, ebx

        $sequence_7 = { 53 6a01 68???????? 68???????? 56 ff15???????? 57 }
            // n = 7, score = 100
            //   53                   | push                ebx
            //   6a01                 | push                1
            //   68????????           |                     
            //   68????????           |                     
            //   56                   | push                esi
            //   ff15????????         |                     
            //   57                   | push                edi

        $sequence_8 = { 8d85d0feffff 50 6888000000 ff15???????? 894624 3bc3 }
            // n = 6, score = 100
            //   8d85d0feffff         | lea                 eax, [ebp - 0x130]
            //   50                   | push                eax
            //   6888000000           | push                0x88
            //   ff15????????         |                     
            //   894624               | mov                 dword ptr [esi + 0x24], eax
            //   3bc3                 | cmp                 eax, ebx

        $sequence_9 = { 55 8bec 81ecb4000000 53 56 57 33f6 }
            // n = 7, score = 100
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   81ecb4000000         | sub                 esp, 0xb4
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   33f6                 | xor                 esi, esi

    condition:
        7 of them and filesize < 57344
}