rule win_unidentified_098_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.unidentified_098."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_098"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e9???????? 488b01 88542428 ff5048 0fb6542428 89c1 e9???????? }
            // n = 7, score = 400
            //   e9????????           |                     
            //   488b01               | mov                 ebp, eax
            //   88542428             | je                  0x1cb5
            //   ff5048               | dec                 eax
            //   0fb6542428           | mov                 ecx, eax
            //   89c1                 | dec                 eax
            //   e9????????           |                     

        $sequence_1 = { 83eb10 6644894104 83fb0f 7fcd bbf0ffffff 29d3 89d8 }
            // n = 7, score = 400
            //   83eb10               | dec                 ecx
            //   6644894104           | mov                 ebp, eax
            //   83fb0f               | je                  0xa
            //   7fcd                 | dec                 eax
            //   bbf0ffffff           | mov                 ecx, eax
            //   29d3                 | dec                 eax
            //   89d8                 | lea                 ecx, [esp + 0x4e80]

        $sequence_2 = { 837c2448ff 0f94c0 4885c9 410f95c5 4120c5 0f8511010000 38c3 }
            // n = 7, score = 400
            //   837c2448ff           | dec                 eax
            //   0f94c0               | lea                 edx, [0x13e666]
            //   4885c9               | je                  0xf03
            //   410f95c5             | dec                 eax
            //   4120c5               | lea                 ecx, [0x13f17a]
            //   0f8511010000         | dec                 eax
            //   38c3                 | lea                 ecx, [esp + 0xd300]

        $sequence_3 = { ff5048 8b542440 89c5 e9???????? 4488bc248c000000 488bbc2498000000 4531ff }
            // n = 7, score = 400
            //   ff5048               | cmp                 esi, 0x80000000
            //   8b542440             | test                eax, eax
            //   89c5                 | jne                 0x205
            //   e9????????           |                     
            //   4488bc248c000000     | dec                 esp
            //   488bbc2498000000     | mov                 eax, edi
            //   4531ff               | dec                 eax

        $sequence_4 = { 85c0 0f8549ffffff 488d4360 4883c420 5b 5e 5f }
            // n = 7, score = 400
            //   85c0                 | test                al, al
            //   0f8549ffffff         | je                  0x8bc
            //   488d4360             | dec                 eax
            //   4883c420             | lea                 eax, [0x1755c3]
            //   5b                   | dec                 eax
            //   5e                   | add                 esp, 0x38
            //   5f                   | ret                 

        $sequence_5 = { f30f6f9c2430010000 0f11a3d9010000 0f11abe9010000 0f1183f9010000 0f118b09020000 0f119319020000 0f119b29020000 }
            // n = 7, score = 400
            //   f30f6f9c2430010000     | lea    esi, [esp + 0x20]
            //   0f11a3d9010000       | mov                 ecx, 0x13
            //   0f11abe9010000       | test                eax, eax
            //   0f1183f9010000       | je                  0x579
            //   0f118b09020000       | dec                 eax
            //   0f119319020000       | lea                 eax, [0x15f2f0]
            //   0f119b29020000       | dec                 eax

        $sequence_6 = { ff5060 4c8b55b8 4839c3 7570 498b4500 4d89f0 4c89d2 }
            // n = 7, score = 400
            //   ff5060               | test                eax, eax
            //   4c8b55b8             | je                  0xffffffe0
            //   4839c3               | mov                 eax, 0xffffffff
            //   7570                 | lock xadd           dword ptr [ecx - 8], eax
            //   498b4500             | mov                 eax, dword ptr [ebx]
            //   4d89f0               | dec                 eax
            //   4c89d2               | mov                 ecx, dword ptr [esp + 0x40]

        $sequence_7 = { 4c894930 4c39c2 7c22 4c8d8c10ffffff7f 0f1f840000000000 4c89c8 4829d0 }
            // n = 7, score = 400
            //   4c894930             | dec                 ecx
            //   4c39c2               | mov                 dword ptr [esp + 0x10], eax
            //   7c22                 | dec                 eax
            //   4c8d8c10ffffff7f     | lea                 eax, [0x5dd66]
            //   0f1f840000000000     | dec                 ecx
            //   4c89c8               | mov                 dword ptr [esp], eax
            //   4829d0               | dec                 ecx

        $sequence_8 = { e8???????? 4d8b37 e9???????? 410fb74654 4183c001 4883ea02 668902 }
            // n = 7, score = 400
            //   e8????????           |                     
            //   4d8b37               | dec                 eax
            //   e9????????           |                     
            //   410fb74654           | lea                 ecx, [0x138c34]
            //   4183c001             | test                eax, eax
            //   4883ea02             | dec                 eax
            //   668902               | lea                 ecx, [0xfffb463d]

        $sequence_9 = { bd01000000 e9???????? 4889c1 e8???????? 498b06 4c89f1 ff5008 }
            // n = 7, score = 400
            //   bd01000000           | mov                 ebx, dword ptr [esp + 0x118]
            //   e9????????           |                     
            //   4889c1               | dec                 ecx
            //   e8????????           |                     
            //   498b06               | mov                 esp, ecx
            //   4c89f1               | dec                 esp
            //   ff5008               | lea                 edi, [esp + 0x87]

    condition:
        7 of them and filesize < 3345408
}