rule win_virtualgate_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.virtualgate."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.virtualgate"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 2bd1 83fa0f 777a 8b8c96b0270100 }
            // n = 4, score = 100
            //   2bd1                 | inc                 ecx
            //   83fa0f               | mul                 ebp
            //   777a                 | mov                 eax, edx
            //   8b8c96b0270100       | dec                 eax

        $sequence_1 = { 482bd6 4a0fbebc3820190200 8d4f01 4863c1 483bc2 0f8f15020000 83f904 }
            // n = 7, score = 100
            //   482bd6               | lea                 ecx, [0x19011]
            //   4a0fbebc3820190200     | dec    eax
            //   8d4f01               | mov                 eax, dword ptr [ebp - 0x28]
            //   4863c1               | mov                 dword ptr [eax + 0x3a8], edx
            //   483bc2               | dec                 eax
            //   0f8f15020000         | lea                 ecx, [0x1ff40]
            //   83f904               | dec                 eax

        $sequence_2 = { 488b03 833800 7513 488d151df90000 488d0df6f80000 e8???????? }
            // n = 6, score = 100
            //   488b03               | dec                 esp
            //   833800               | lea                 eax, [0xd2a3]
            //   7513                 | dec                 eax
            //   488d151df90000       | lea                 edx, [0xd2a4]
            //   488d0df6f80000       | mov                 ecx, 1
            //   e8????????           |                     

        $sequence_3 = { 5d c3 488d05559a0100 488905???????? }
            // n = 4, score = 100
            //   5d                   | lea                 eax, [0x14256]
            //   c3                   | dec                 eax
            //   488d05559a0100       | lea                 ecx, [0x1447f]
            //   488905????????       |                     

        $sequence_4 = { 0100 682601006f 260100 7626 0100 7d26 }
            // n = 6, score = 100
            //   0100                 | lock xadd           dword ptr [ecx + 0x15c], eax
            //   682601006f           | dec                 eax
            //   260100               | lea                 eax, [0x1909a]
            //   7626                 | dec                 eax
            //   0100                 | cmp                 ecx, eax
            //   7d26                 | je                  0xa4

        $sequence_5 = { eb03 48ffc1 8a01 413ac3 }
            // n = 4, score = 100
            //   eb03                 | dec                 eax
            //   48ffc1               | mov                 dword ptr [esp + 0x68], edi
            //   8a01                 | xor                 edx, edx
            //   413ac3               | dec                 eax

        $sequence_6 = { c3 4885d2 74e1 33ff 66897c2450 b020 eb03 }
            // n = 7, score = 100
            //   c3                   | test                eax, eax
            //   4885d2               | test                eax, eax
            //   74e1                 | jne                 0x1c
            //   33ff                 | inc                 esp
            //   66897c2450           | cmp                 byte ptr [esp + 0x68], ch
            //   b020                 | je                  0xe
            //   eb03                 | dec                 eax

        $sequence_7 = { 488bce e8???????? 85c0 0f854d010000 33d2 }
            // n = 5, score = 100
            //   488bce               | dec                 eax
            //   e8????????           |                     
            //   85c0                 | lea                 eax, [0xffffd7f9]
            //   0f854d010000         | and                 dword ptr [edi + 0x58], 0
            //   33d2                 | dec                 eax

        $sequence_8 = { 49ffc0 48ffc2 493bd1 7427 418a00 8ac8 }
            // n = 6, score = 100
            //   49ffc0               | je                  0x13fd
            //   48ffc2               | inc                 esp
            //   493bd1               | mov                 dword ptr [eax], edi
            //   7427                 | mov                 dword ptr [eax], edi
            //   418a00               | dec                 eax
            //   8ac8                 | lea                 ebx, [0x1d77f]

        $sequence_9 = { e8???????? 44386dcf 7409 488b4db7 e8???????? 44386dff 7409 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   44386dcf             | je                  0x26b
            //   7409                 | mov                 esi, dword ptr [ebp]
            //   488b4db7             | dec                 ecx
            //   e8????????           |                     
            //   44386dff             | mov                 ebx, dword ptr [esi + esi*8 + 0x22a30]
            //   7409                 | dec                 eax

    condition:
        7 of them and filesize < 323584
}