rule win_vobfus_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.vobfus."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.vobfus"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b5508 8b92e8000000 8b8230200000 50 }
            // n = 4, score = 200
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   8b92e8000000         | mov                 edx, dword ptr [edx + 0xe8]
            //   8b8230200000         | mov                 eax, dword ptr [edx + 0x2030]
            //   50                   | push                eax

        $sequence_1 = { 8b5508 8b92e8000000 8b82140c0000 50 }
            // n = 4, score = 200
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   8b92e8000000         | mov                 edx, dword ptr [edx + 0xe8]
            //   8b82140c0000         | mov                 eax, dword ptr [edx + 0xc14]
            //   50                   | push                eax

        $sequence_2 = { 8b5508 8b92e8000000 8b8228070000 50 }
            // n = 4, score = 200
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   8b92e8000000         | mov                 edx, dword ptr [edx + 0xe8]
            //   8b8228070000         | mov                 eax, dword ptr [edx + 0x728]
            //   50                   | push                eax

        $sequence_3 = { 8b5508 8b92e8000000 8b82080f0000 50 }
            // n = 4, score = 200
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   8b92e8000000         | mov                 edx, dword ptr [edx + 0xe8]
            //   8b82080f0000         | mov                 eax, dword ptr [edx + 0xf08]
            //   50                   | push                eax

        $sequence_4 = { 8bec 8b5508 8b92e8000000 8b82c0170000 50 50 }
            // n = 6, score = 200
            //   8bec                 | mov                 ebp, esp
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   8b92e8000000         | mov                 edx, dword ptr [edx + 0xe8]
            //   8b82c0170000         | mov                 eax, dword ptr [edx + 0x17c0]
            //   50                   | push                eax
            //   50                   | push                eax

        $sequence_5 = { 55 8bec 8b5508 8b92e8000000 8b82f81b0000 50 }
            // n = 6, score = 200
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   8b92e8000000         | mov                 edx, dword ptr [edx + 0xe8]
            //   8b82f81b0000         | mov                 eax, dword ptr [edx + 0x1bf8]
            //   50                   | push                eax

        $sequence_6 = { 8b82381e0000 50 50 8b10 ff5204 58 }
            // n = 6, score = 200
            //   8b82381e0000         | mov                 eax, dword ptr [edx + 0x1e38]
            //   50                   | push                eax
            //   50                   | push                eax
            //   8b10                 | mov                 edx, dword ptr [eax]
            //   ff5204               | call                dword ptr [edx + 4]
            //   58                   | pop                 eax

        $sequence_7 = { 8b5508 8b92e8000000 8b825c030000 50 }
            // n = 4, score = 200
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   8b92e8000000         | mov                 edx, dword ptr [edx + 0xe8]
            //   8b825c030000         | mov                 eax, dword ptr [edx + 0x35c]
            //   50                   | push                eax

        $sequence_8 = { 00e0 c9 8f00 e3ce 97 00e6 d39500e4d19b }
            // n = 7, score = 100
            //   00e0                 | add                 al, ah
            //   c9                   | leave               
            //   8f00                 | pop                 dword ptr [eax]
            //   e3ce                 | jecxz               0xffffffd0
            //   97                   | xchg                eax, edi
            //   00e6                 | add                 dh, ah
            //   d39500e4d19b         | rcl                 dword ptr [ebp - 0x642e1c00], cl

        $sequence_9 = { f2ed ec f2ed ec f3ed }
            // n = 5, score = 100
            //   f2ed                 | in                  eax, dx
            //   ec                   | in                  al, dx
            //   f2ed                 | in                  eax, dx
            //   ec                   | in                  al, dx
            //   f3ed                 | in                  eax, dx

        $sequence_10 = { c19400d6c49500d7 c59900dac999 00e0 c9 }
            // n = 4, score = 100
            //   c19400d6c49500d7     | rcl                 dword ptr [eax + eax + 0x95c4d6], 0xd7
            //   c59900dac999         | lds                 ebx, ptr [ecx - 0x66362600]
            //   00e0                 | add                 al, ah
            //   c9                   | leave               

        $sequence_11 = { 801800 0808 0006 3401 }
            // n = 4, score = 100
            //   801800               | sbb                 byte ptr [eax], 0
            //   0808                 | or                  byte ptr [eax], cl
            //   0006                 | add                 byte ptr [esi], al
            //   3401                 | xor                 al, 1

        $sequence_12 = { 73f3 aa 5c f6ac4ff8b54ffb }
            // n = 4, score = 100
            //   73f3                 | jae                 0xfffffff5
            //   aa                   | stosb               byte ptr es:[edi], al
            //   5c                   | pop                 esp
            //   f6ac4ff8b54ffb       | imul                byte ptr [edi + ecx*2 - 0x4b04a08]

        $sequence_13 = { 0006 3401 41 06 1005???????? 0100 }
            // n = 6, score = 100
            //   0006                 | add                 byte ptr [esi], al
            //   3401                 | xor                 al, 1
            //   41                   | inc                 ecx
            //   06                   | push                es
            //   1005????????         |                     
            //   0100                 | add                 dword ptr [eax], eax

        $sequence_14 = { 5c f6ac4ff8b54ffb c058fcca 61 }
            // n = 4, score = 100
            //   5c                   | pop                 esp
            //   f6ac4ff8b54ffb       | imul                byte ptr [edi + ecx*2 - 0x4b04a08]
            //   c058fcca             | rcr                 byte ptr [eax - 4], 0xca
            //   61                   | popal               

        $sequence_15 = { 1400 48 0008 78ff 0d50004900 3e3cff }
            // n = 6, score = 100
            //   1400                 | adc                 al, 0
            //   48                   | dec                 eax
            //   0008                 | add                 byte ptr [eax], cl
            //   78ff                 | js                  1
            //   0d50004900           | or                  eax, 0x490050
            //   3e3cff               | cmp                 al, 0xff

        $sequence_16 = { a1???????? 00ec dea600e0d4b3 00e0 d4b4 }
            // n = 5, score = 100
            //   a1????????           |                     
            //   00ec                 | add                 ah, ch
            //   dea600e0d4b3         | fisub               word ptr [esi - 0x4c2b2000]
            //   00e0                 | add                 al, ah
            //   d4b4                 | aam                 0xb4

        $sequence_17 = { 41 06 1001 ff06 }
            // n = 4, score = 100
            //   41                   | inc                 ecx
            //   06                   | push                es
            //   1001                 | adc                 byte ptr [ecx], al
            //   ff06                 | inc                 dword ptr [esi]

        $sequence_18 = { f2e8fae6d5f6 d2b5f2bb8ff3 ae 73f3 aa }
            // n = 5, score = 100
            //   f2e8fae6d5f6         | bnd call            0xf6d5e700
            //   d2b5f2bb8ff3         | sal                 byte ptr [ebp - 0xc70440e], cl
            //   ae                   | scasb               al, byte ptr es:[edi]
            //   73f3                 | jae                 0xfffffff5
            //   aa                   | stosb               byte ptr es:[edi], al

        $sequence_19 = { 7cc8 dc7acd e291 d2e8 }
            // n = 4, score = 100
            //   7cc8                 | jl                  0xffffffca
            //   dc7acd               | fdivr               qword ptr [edx - 0x33]
            //   e291                 | loop                0xffffff93
            //   d2e8                 | shr                 al, cl

        $sequence_20 = { 78ff 0d50004900 3e3cff 46 14ff 0470 fe0a }
            // n = 7, score = 100
            //   78ff                 | js                  1
            //   0d50004900           | or                  eax, 0x490050
            //   3e3cff               | cmp                 al, 0xff
            //   46                   | inc                 esi
            //   14ff                 | adc                 al, 0xff
            //   0470                 | add                 al, 0x70
            //   fe0a                 | dec                 byte ptr [edx]

        $sequence_21 = { ff06 0200 0100 8a00 }
            // n = 4, score = 100
            //   ff06                 | inc                 dword ptr [esi]
            //   0200                 | add                 al, byte ptr [eax]
            //   0100                 | add                 dword ptr [eax], eax
            //   8a00                 | mov                 al, byte ptr [eax]

        $sequence_22 = { ec f3ed ebf2 ed ec }
            // n = 5, score = 100
            //   ec                   | in                  al, dx
            //   f3ed                 | in                  eax, dx
            //   ebf2                 | jmp                 0xfffffff4
            //   ed                   | in                  eax, dx
            //   ec                   | in                  al, dx

        $sequence_23 = { 00cf c0b200d1c3b600 e6d3 a1???????? 00ec }
            // n = 5, score = 100
            //   00cf                 | add                 bh, cl
            //   c0b200d1c3b600       | sal                 byte ptr [edx - 0x493c2f00], 0
            //   e6d3                 | out                 0xd3, al
            //   a1????????           |                     
            //   00ec                 | add                 ah, ch

    condition:
        7 of them and filesize < 409600
}