rule win_vreikstadi_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.vreikstadi"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c3 8bc6 33d2 8ad3 8b149538514900 e8???????? }
            // n = 6, score = 100
            //   c3                   | ret                 
            //   8bc6                 | mov                 eax, esi
            //   33d2                 | xor                 edx, edx
            //   8ad3                 | mov                 dl, bl
            //   8b149538514900       | mov                 edx, dword ptr [edx*4 + 0x495138]
            //   e8????????           |                     

        $sequence_1 = { 8b149d549b4900 03d0 eb02 8bd0 8bda 8b44240c 8b4c240c }
            // n = 7, score = 100
            //   8b149d549b4900       | mov                 edx, dword ptr [ebx*4 + 0x499b54]
            //   03d0                 | add                 edx, eax
            //   eb02                 | jmp                 4
            //   8bd0                 | mov                 edx, eax
            //   8bda                 | mov                 ebx, edx
            //   8b44240c             | mov                 eax, dword ptr [esp + 0xc]
            //   8b4c240c             | mov                 ecx, dword ptr [esp + 0xc]

        $sequence_2 = { 0b04956c5a4900 33d2 8a9313020000 0b0495745a4900 33d2 }
            // n = 5, score = 100
            //   0b04956c5a4900       | or                  eax, dword ptr [edx*4 + 0x495a6c]
            //   33d2                 | xor                 edx, edx
            //   8a9313020000         | mov                 dl, byte ptr [ebx + 0x213]
            //   0b0495745a4900       | or                  eax, dword ptr [edx*4 + 0x495a74]
            //   33d2                 | xor                 edx, edx

        $sequence_3 = { e8???????? 8d459c 50 b906000000 ba11000000 8b45f4 e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8d459c               | lea                 eax, [ebp - 0x64]
            //   50                   | push                eax
            //   b906000000           | mov                 ecx, 6
            //   ba11000000           | mov                 edx, 0x11
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   e8????????           |                     

        $sequence_4 = { 25ff000000 8b04c540524900 5b c3 55 }
            // n = 5, score = 100
            //   25ff000000           | and                 eax, 0xff
            //   8b04c540524900       | mov                 eax, dword ptr [eax*8 + 0x495240]
            //   5b                   | pop                 ebx
            //   c3                   | ret                 
            //   55                   | push                ebp

        $sequence_5 = { 80fb58 0f84c8f2ffff b90a000000 80fb55 0f84baf2ffff e9???????? }
            // n = 6, score = 100
            //   80fb58               | cmp                 bl, 0x58
            //   0f84c8f2ffff         | je                  0xfffff2ce
            //   b90a000000           | mov                 ecx, 0xa
            //   80fb55               | cmp                 bl, 0x55
            //   0f84baf2ffff         | je                  0xfffff2c0
            //   e9????????           |                     

        $sequence_6 = { 00b4fe000068b6 49 00b5fe000068 b649 00b6fe000068 b649 00b7fe000068 }
            // n = 7, score = 100
            //   00b4fe000068b6       | add                 byte ptr [esi + edi*8 - 0x49980000], dh
            //   49                   | dec                 ecx
            //   00b5fe000068         | add                 byte ptr [ebp + 0x680000fe], dh
            //   b649                 | mov                 dh, 0x49
            //   00b6fe000068         | add                 byte ptr [esi + 0x680000fe], dh
            //   b649                 | mov                 dh, 0x49
            //   00b7fe000068         | add                 byte ptr [edi + 0x680000fe], dh

        $sequence_7 = { 33d2 e8???????? 8b55f4 b8???????? e8???????? 85c0 }
            // n = 6, score = 100
            //   33d2                 | xor                 edx, edx
            //   e8????????           |                     
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]
            //   b8????????           |                     
            //   e8????????           |                     
            //   85c0                 | test                eax, eax

        $sequence_8 = { e8???????? 8d45cc 50 b904000000 ba0a000000 8b45e0 e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8d45cc               | lea                 eax, [ebp - 0x34]
            //   50                   | push                eax
            //   b904000000           | mov                 ecx, 4
            //   ba0a000000           | mov                 edx, 0xa
            //   8b45e0               | mov                 eax, dword ptr [ebp - 0x20]
            //   e8????????           |                     

        $sequence_9 = { 8bec 51 8945fc 8b45fc 83b8f802000000 7507 }
            // n = 6, score = 100
            //   8bec                 | mov                 ebp, esp
            //   51                   | push                ecx
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   83b8f802000000       | cmp                 dword ptr [eax + 0x2f8], 0
            //   7507                 | jne                 9

    condition:
        7 of them and filesize < 4014080
}