rule win_vshell_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.vshell."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.vshell"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 885017 0fb6542465 440fb6442456 4401c2 885018 488d4b19 4889c3 }
            // n = 7, score = 100
            //   885017               | dec                 eax
            //   0fb6542465           | cmp                 edx, 3
            //   440fb6442456         | ja                  0x8cd
            //   4401c2               | dec                 eax
            //   885018               | mov                 ebx, eax
            //   488d4b19             | dec                 eax
            //   4889c3               | lea                 eax, [0x415cc7]

        $sequence_1 = { f20f59c8 66480f7ec8 e8???????? 488d0d89325500 48894c2478 4889842480000000 488b442468 }
            // n = 7, score = 100
            //   f20f59c8             | sub                 eax, edx
            //   66480f7ec8           | dec                 eax
            //   e8????????           |                     
            //   488d0d89325500       | mov                 ecx, esi
            //   48894c2478           | btr                 esi, 0x1f
            //   4889842480000000     | mov                 edi, esi
            //   488b442468           | dec                 eax

        $sequence_2 = { 48c1ff3f 4921f8 4a8d1c06 b908000000 4c89df 4889c6 4c89d0 }
            // n = 7, score = 100
            //   48c1ff3f             | dec                 eax
            //   4921f8               | mov                 edx, dword ptr [esp + 0x1838]
            //   4a8d1c06             | dec                 eax
            //   b908000000           | lea                 ebx, [edx + 0xc0]
            //   4c89df               | dec                 eax
            //   4889c6               | lea                 eax, [0x563185]
            //   4c89d0               | inc                 ecx

        $sequence_3 = { 746f 4883f813 7454 e8???????? 4889842498000000 48895c2460 90 }
            // n = 7, score = 100
            //   746f                 | cmp                 ebx, ecx
            //   4883f813             | jg                  0x1ad5
            //   7454                 | mov                 ecx, 6
            //   e8????????           |                     
            //   4889842498000000     | dec                 ecx
            //   48895c2460           | mov                 eax, ebx
            //   90                   | inc                 esi

        $sequence_4 = { 7509 488d05ad5cb600 eb65 4883fe02 7509 488d058e5cb600 eb56 }
            // n = 7, score = 100
            //   7509                 | cmove               ebx, ecx
            //   488d05ad5cb600       | dec                 eax
            //   eb65                 | mov                 ecx, dword ptr [esp + 0x18]
            //   4883fe02             | dec                 eax
            //   7509                 | cmove               eax, ecx
            //   488d058e5cb600       | dec                 eax
            //   eb56                 | mov                 ebp, dword ptr [esp + 0x20]

        $sequence_5 = { 7462 6690 4180fbff 0f84f6000000 49bc9899999999999919 4c39e7 772f }
            // n = 7, score = 100
            //   7462                 | inc                 esi
            //   6690                 | mov                 byte ptr [esp + ebx + 0x35], ch
            //   4180fbff             | dec                 eax
            //   0f84f6000000         | add                 edx, 2
            //   49bc9899999999999919     | dec    eax
            //   4c39e7               | cmp                 edx, 2
            //   772f                 | inc                 esi

        $sequence_6 = { e9???????? 488d842450010000 488d5c2454 b902000000 e8???????? 488b4c2478 4839cb }
            // n = 7, score = 100
            //   e9????????           |                     
            //   488d842450010000     | dec                 eax
            //   488d5c2454           | mov                 ebx, dword ptr [esp + 0x88]
            //   b902000000           | dec                 eax
            //   e8????????           |                     
            //   488b4c2478           | lea                 eax, [0xb99593]
            //   4839cb               | mov                 ebx, 0x31

        $sequence_7 = { c3 488b9c24a0000000 488b842488010000 0f1f440000 e9???????? 440fb64c3c52 4131f1 }
            // n = 7, score = 100
            //   c3                   | mov                 dword ptr [esp + 0x60], ecx
            //   488b9c24a0000000     | ret                 
            //   488b842488010000     | dec                 eax
            //   0f1f440000           | mov                 eax, dword ptr [esp + 0xe0]
            //   e9????????           |                     
            //   440fb64c3c52         | dec                 eax
            //   4131f1               | mov                 ecx, dword ptr [esp + 0x58]

        $sequence_8 = { 88542475 440fb6842499000000 4488442474 440fb68c249a000000 44884c2473 440fb6942496000000 4488542472 }
            // n = 7, score = 100
            //   88542475             | nop                 
            //   440fb6842499000000     | dec    eax
            //   4488442474           | mov                 ecx, dword ptr [esp + 0x170]
            //   440fb68c249a000000     | dec    eax
            //   44884c2473           | mov                 esi, dword ptr [esp + 0x168]
            //   440fb6942496000000     | dec    eax
            //   4488542472           | mov                 eax, dword ptr [esp + 0x50]

        $sequence_9 = { 7667 4881fa00100000 be00100000 4189d0 4c0f4fc6 90 4981f800100000 }
            // n = 7, score = 100
            //   7667                 | cmp                 edx, esi
            //   4881fa00100000       | je                  0x1b70
            //   be00100000           | dec                 eax
            //   4189d0               | mov                 ebx, dword ptr [esi + 8]
            //   4c0f4fc6             | dec                 esp
            //   90                   | mov                 eax, dword ptr [edx + 8]
            //   4981f800100000       | dec                 esp

    condition:
        7 of them and filesize < 39452672
}