rule win_waterspout_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.waterspout."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.waterspout"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? 3bf3 0f8481000000 8d4c2418 8d54240c 51 53 }
            // n = 7, score = 200
            //   ff15????????         |                     
            //   3bf3                 | cmp                 esi, ebx
            //   0f8481000000         | je                  0x87
            //   8d4c2418             | lea                 ecx, [esp + 0x18]
            //   8d54240c             | lea                 edx, [esp + 0xc]
            //   51                   | push                ecx
            //   53                   | push                ebx

        $sequence_1 = { 61 8b4508 48 894508 7596 5f 5e }
            // n = 7, score = 200
            //   61                   | popal               
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   48                   | dec                 eax
            //   894508               | mov                 dword ptr [ebp + 8], eax
            //   7596                 | jne                 0xffffff98
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_2 = { 68???????? 6a64 e8???????? 83c408 8b0d???????? 8d44242c }
            // n = 6, score = 200
            //   68????????           |                     
            //   6a64                 | push                0x64
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   8b0d????????         |                     
            //   8d44242c             | lea                 eax, [esp + 0x2c]

        $sequence_3 = { 53 8b5c240c 56 8b74240c 3bf3 7414 }
            // n = 6, score = 200
            //   53                   | push                ebx
            //   8b5c240c             | mov                 ebx, dword ptr [esp + 0xc]
            //   56                   | push                esi
            //   8b74240c             | mov                 esi, dword ptr [esp + 0xc]
            //   3bf3                 | cmp                 esi, ebx
            //   7414                 | je                  0x16

        $sequence_4 = { f2ae f7d1 49 83f931 7607 }
            // n = 5, score = 200
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   f7d1                 | not                 ecx
            //   49                   | dec                 ecx
            //   83f931               | cmp                 ecx, 0x31
            //   7607                 | jbe                 9

        $sequence_5 = { 5b c3 8b54241c 8b35???????? 3bdf }
            // n = 5, score = 200
            //   5b                   | pop                 ebx
            //   c3                   | ret                 
            //   8b54241c             | mov                 edx, dword ptr [esp + 0x1c]
            //   8b35????????         |                     
            //   3bdf                 | cmp                 ebx, edi

        $sequence_6 = { 89442428 c1f808 88442413 8b02 2b44241c 83f801 7706 }
            // n = 7, score = 200
            //   89442428             | mov                 dword ptr [esp + 0x28], eax
            //   c1f808               | sar                 eax, 8
            //   88442413             | mov                 byte ptr [esp + 0x13], al
            //   8b02                 | mov                 eax, dword ptr [edx]
            //   2b44241c             | sub                 eax, dword ptr [esp + 0x1c]
            //   83f801               | cmp                 eax, 1
            //   7706                 | ja                  8

        $sequence_7 = { b8f41f0000 e8???????? 53 55 }
            // n = 4, score = 200
            //   b8f41f0000           | mov                 eax, 0x1ff4
            //   e8????????           |                     
            //   53                   | push                ebx
            //   55                   | push                ebp

        $sequence_8 = { 8844240e 8844240f 8d442400 50 8b442418 }
            // n = 5, score = 200
            //   8844240e             | mov                 byte ptr [esp + 0xe], al
            //   8844240f             | mov                 byte ptr [esp + 0xf], al
            //   8d442400             | lea                 eax, [esp]
            //   50                   | push                eax
            //   8b442418             | mov                 eax, dword ptr [esp + 0x18]

        $sequence_9 = { 8d7c241c 6804010000 f3ab b9fc070000 8dbc24a0230000 f3ab }
            // n = 6, score = 200
            //   8d7c241c             | lea                 edi, [esp + 0x1c]
            //   6804010000           | push                0x104
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   b9fc070000           | mov                 ecx, 0x7fc
            //   8dbc24a0230000       | lea                 edi, [esp + 0x23a0]
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax

    condition:
        7 of them and filesize < 98304
}