rule win_webc2_greencat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.webc2_greencat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.webc2_greencat"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 5b b8???????? 53 50 50 33ff }
            // n = 6, score = 100
            //   5b                   | pop                 ebx
            //   b8????????           |                     
            //   53                   | push                ebx
            //   50                   | push                eax
            //   50                   | push                eax
            //   33ff                 | xor                 edi, edi

        $sequence_1 = { e8???????? 83c414 33c9 3bfb 7632 }
            // n = 5, score = 100
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14
            //   33c9                 | xor                 ecx, ecx
            //   3bfb                 | cmp                 edi, ebx
            //   7632                 | jbe                 0x34

        $sequence_2 = { 59 59 8b45d4 3818 0f857dfeffff }
            // n = 5, score = 100
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   8b45d4               | mov                 eax, dword ptr [ebp - 0x2c]
            //   3818                 | cmp                 byte ptr [eax], bl
            //   0f857dfeffff         | jne                 0xfffffe83

        $sequence_3 = { 75c9 be00000200 397d08 7e08 }
            // n = 4, score = 100
            //   75c9                 | jne                 0xffffffcb
            //   be00000200           | mov                 esi, 0x20000
            //   397d08               | cmp                 dword ptr [ebp + 8], edi
            //   7e08                 | jle                 0xa

        $sequence_4 = { 33ff e8???????? 83c40c be???????? ff35???????? 56 }
            // n = 6, score = 100
            //   33ff                 | xor                 edi, edi
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   be????????           |                     
            //   ff35????????         |                     
            //   56                   | push                esi

        $sequence_5 = { eb27 68???????? eb20 68???????? eb19 ff15???????? 3d26040000 }
            // n = 7, score = 100
            //   eb27                 | jmp                 0x29
            //   68????????           |                     
            //   eb20                 | jmp                 0x22
            //   68????????           |                     
            //   eb19                 | jmp                 0x1b
            //   ff15????????         |                     
            //   3d26040000           | cmp                 eax, 0x426

        $sequence_6 = { c20800 ff74240c ff74240c ff74240c ff710c ff15???????? c20c00 }
            // n = 7, score = 100
            //   c20800               | ret                 8
            //   ff74240c             | push                dword ptr [esp + 0xc]
            //   ff74240c             | push                dword ptr [esp + 0xc]
            //   ff74240c             | push                dword ptr [esp + 0xc]
            //   ff710c               | push                dword ptr [ecx + 0xc]
            //   ff15????????         |                     
            //   c20c00               | ret                 0xc

        $sequence_7 = { c645e840 c645e94a c645eae6 c645eb1a c645ec14 885ded }
            // n = 6, score = 100
            //   c645e840             | mov                 byte ptr [ebp - 0x18], 0x40
            //   c645e94a             | mov                 byte ptr [ebp - 0x17], 0x4a
            //   c645eae6             | mov                 byte ptr [ebp - 0x16], 0xe6
            //   c645eb1a             | mov                 byte ptr [ebp - 0x15], 0x1a
            //   c645ec14             | mov                 byte ptr [ebp - 0x14], 0x14
            //   885ded               | mov                 byte ptr [ebp - 0x13], bl

        $sequence_8 = { 50 ff750c e8???????? 68???????? ff750c e8???????? 83c410 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   e8????????           |                     
            //   68????????           |                     
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10

        $sequence_9 = { 50 ff15???????? 3bc7 59 7405 a3???????? 8a45ff }
            // n = 7, score = 100
            //   50                   | push                eax
            //   ff15????????         |                     
            //   3bc7                 | cmp                 eax, edi
            //   59                   | pop                 ecx
            //   7405                 | je                  7
            //   a3????????           |                     
            //   8a45ff               | mov                 al, byte ptr [ebp - 1]

    condition:
        7 of them and filesize < 57344
}