rule win_wmighost_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.wmighost."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.wmighost"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 83c408 68???????? 8d8df0fcffff 51 }
            // n = 5, score = 100
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   68????????           |                     
            //   8d8df0fcffff         | lea                 ecx, [ebp - 0x310]
            //   51                   | push                ecx

        $sequence_1 = { 8a15???????? 33ca 8b45f8 8888c8304000 ebb0 c745fc???????? }
            // n = 6, score = 100
            //   8a15????????         |                     
            //   33ca                 | xor                 ecx, edx
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   8888c8304000         | mov                 byte ptr [eax + 0x4030c8], cl
            //   ebb0                 | jmp                 0xffffffb2
            //   c745fc????????       |                     

        $sequence_2 = { f3ab 66ab aa c6858caeffff00 b9ff090000 }
            // n = 5, score = 100
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   aa                   | stosb               byte ptr es:[edi], al
            //   c6858caeffff00       | mov                 byte ptr [ebp - 0x5174], 0
            //   b9ff090000           | mov                 ecx, 0x9ff

        $sequence_3 = { c3 55 8bec 83ec08 894df8 8b4508 50 }
            // n = 7, score = 100
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   83ec08               | sub                 esp, 8
            //   894df8               | mov                 dword ptr [ebp - 8], ecx
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   50                   | push                eax

        $sequence_4 = { 8945f0 837df000 7d12 68???????? 8b45ec }
            // n = 5, score = 100
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   837df000             | cmp                 dword ptr [ebp - 0x10], 0
            //   7d12                 | jge                 0x14
            //   68????????           |                     
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]

        $sequence_5 = { 52 8d85f0fcffff 50 e8???????? 83c408 68???????? }
            // n = 6, score = 100
            //   52                   | push                edx
            //   8d85f0fcffff         | lea                 eax, [ebp - 0x310]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   68????????           |                     

        $sequence_6 = { 8a0d???????? 33c1 8b55f8 8882c8304000 8b45f8 0fbe88c8304000 33d2 }
            // n = 7, score = 100
            //   8a0d????????         |                     
            //   33c1                 | xor                 eax, ecx
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   8882c8304000         | mov                 byte ptr [edx + 0x4030c8], al
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   0fbe88c8304000       | movsx               ecx, byte ptr [eax + 0x4030c8]
            //   33d2                 | xor                 edx, edx

        $sequence_7 = { 50 ff5238 8945fc 837dfc00 7d12 68???????? }
            // n = 6, score = 100
            //   50                   | push                eax
            //   ff5238               | call                dword ptr [edx + 0x38]
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   837dfc00             | cmp                 dword ptr [ebp - 4], 0
            //   7d12                 | jge                 0x14
            //   68????????           |                     

        $sequence_8 = { 8bec 83ec08 894df8 668b4508 50 }
            // n = 5, score = 100
            //   8bec                 | mov                 ebp, esp
            //   83ec08               | sub                 esp, 8
            //   894df8               | mov                 dword ptr [ebp - 8], ecx
            //   668b4508             | mov                 ax, word ptr [ebp + 8]
            //   50                   | push                eax

        $sequence_9 = { 8b45b4 8945b0 c645fc04 8d4de8 }
            // n = 4, score = 100
            //   8b45b4               | mov                 eax, dword ptr [ebp - 0x4c]
            //   8945b0               | mov                 dword ptr [ebp - 0x50], eax
            //   c645fc04             | mov                 byte ptr [ebp - 4], 4
            //   8d4de8               | lea                 ecx, [ebp - 0x18]

    condition:
        7 of them and filesize < 49152
}