rule win_wscspl_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.wscspl."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.wscspl"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 8d442428 50 885c342c }
            // n = 4, score = 400
            //   e8????????           |                     
            //   8d442428             | lea                 eax, [esp + 0x28]
            //   50                   | push                eax
            //   885c342c             | mov                 byte ptr [esp + esi + 0x2c], bl

        $sequence_1 = { 8d541804 0fb60a 0fb62e 2bcd 7527 83ff01 7634 }
            // n = 7, score = 400
            //   8d541804             | lea                 edx, [eax + ebx + 4]
            //   0fb60a               | movzx               ecx, byte ptr [edx]
            //   0fb62e               | movzx               ebp, byte ptr [esi]
            //   2bcd                 | sub                 ecx, ebp
            //   7527                 | jne                 0x29
            //   83ff01               | cmp                 edi, 1
            //   7634                 | jbe                 0x36

        $sequence_2 = { 687c230000 8bd3 68c60b0000 bb???????? e8???????? 83c408 }
            // n = 6, score = 400
            //   687c230000           | push                0x237c
            //   8bd3                 | mov                 edx, ebx
            //   68c60b0000           | push                0xbc6
            //   bb????????           |                     
            //   e8????????           |                     
            //   83c408               | add                 esp, 8

        $sequence_3 = { e8???????? 83c41c 5f 5e c705????????83230000 5d 8b8c2488230000 }
            // n = 7, score = 400
            //   e8????????           |                     
            //   83c41c               | add                 esp, 0x1c
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   c705????????83230000     |     
            //   5d                   | pop                 ebp
            //   8b8c2488230000       | mov                 ecx, dword ptr [esp + 0x2388]

        $sequence_4 = { 2bc6 a3???????? ff15???????? a1???????? 83f8ff 7419 6a00 }
            // n = 7, score = 400
            //   2bc6                 | sub                 eax, esi
            //   a3????????           |                     
            //   ff15????????         |                     
            //   a1????????           |                     
            //   83f8ff               | cmp                 eax, -1
            //   7419                 | je                  0x1b
            //   6a00                 | push                0

        $sequence_5 = { 8d842484020000 50 8d8c3480010000 51 }
            // n = 4, score = 400
            //   8d842484020000       | lea                 eax, [esp + 0x284]
            //   50                   | push                eax
            //   8d8c3480010000       | lea                 ecx, [esp + esi + 0x180]
            //   51                   | push                ecx

        $sequence_6 = { 06 1007 1010 0809 100a 1010 100b }
            // n = 7, score = 400
            //   06                   | push                es
            //   1007                 | adc                 byte ptr [edi], al
            //   1010                 | adc                 byte ptr [eax], dl
            //   0809                 | or                  byte ptr [ecx], cl
            //   100a                 | adc                 byte ptr [edx], cl
            //   1010                 | adc                 byte ptr [eax], dl
            //   100b                 | adc                 byte ptr [ebx], cl

        $sequence_7 = { 52 ff15???????? 83f8ff 7536 ff15???????? 8bf0 a1???????? }
            // n = 7, score = 400
            //   52                   | push                edx
            //   ff15????????         |                     
            //   83f8ff               | cmp                 eax, -1
            //   7536                 | jne                 0x38
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   a1????????           |                     

        $sequence_8 = { a3???????? e8???????? 8b0d???????? 8b3d???????? 51 8bf0 57 }
            // n = 7, score = 400
            //   a3????????           |                     
            //   e8????????           |                     
            //   8b0d????????         |                     
            //   8b3d????????         |                     
            //   51                   | push                ecx
            //   8bf0                 | mov                 esi, eax
            //   57                   | push                edi

        $sequence_9 = { 687c230000 8d44240c 6a01 50 ff15???????? 687c230000 68c10b0000 }
            // n = 7, score = 400
            //   687c230000           | push                0x237c
            //   8d44240c             | lea                 eax, [esp + 0xc]
            //   6a01                 | push                1
            //   50                   | push                eax
            //   ff15????????         |                     
            //   687c230000           | push                0x237c
            //   68c10b0000           | push                0xbc1

    condition:
        7 of them and filesize < 901120
}