rule win_yarat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.yarat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.yarat"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 8d4dc4 c645fc00 e8???????? 8b8f94000000 85c9 7444 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8d4dc4               | lea                 ecx, [ebp - 0x3c]
            //   c645fc00             | mov                 byte ptr [ebp - 4], 0
            //   e8????????           |                     
            //   8b8f94000000         | mov                 ecx, dword ptr [edi + 0x94]
            //   85c9                 | test                ecx, ecx
            //   7444                 | je                  0x46

        $sequence_1 = { 898d60feffff 51 52 3bc8 7734 8bb574feffff 837dec10 }
            // n = 7, score = 100
            //   898d60feffff         | mov                 dword ptr [ebp - 0x1a0], ecx
            //   51                   | push                ecx
            //   52                   | push                edx
            //   3bc8                 | cmp                 ecx, eax
            //   7734                 | ja                  0x36
            //   8bb574feffff         | mov                 esi, dword ptr [ebp - 0x18c]
            //   837dec10             | cmp                 dword ptr [ebp - 0x14], 0x10

        $sequence_2 = { 8bc1 8b96d40f0000 0bc2 7448 33c0 8bdf 3bc2 }
            // n = 7, score = 100
            //   8bc1                 | mov                 eax, ecx
            //   8b96d40f0000         | mov                 edx, dword ptr [esi + 0xfd4]
            //   0bc2                 | or                  eax, edx
            //   7448                 | je                  0x4a
            //   33c0                 | xor                 eax, eax
            //   8bdf                 | mov                 ebx, edi
            //   3bc2                 | cmp                 eax, edx

        $sequence_3 = { 8b4d10 8b4514 03f2 03da 2bfa 0f85d4feffff 5f }
            // n = 7, score = 100
            //   8b4d10               | mov                 ecx, dword ptr [ebp + 0x10]
            //   8b4514               | mov                 eax, dword ptr [ebp + 0x14]
            //   03f2                 | add                 esi, edx
            //   03da                 | add                 ebx, edx
            //   2bfa                 | sub                 edi, edx
            //   0f85d4feffff         | jne                 0xfffffeda
            //   5f                   | pop                 edi

        $sequence_4 = { b787 71a6 bef82d06be 6a55 9aeede8c28ce52 91 b7d3 }
            // n = 7, score = 100
            //   b787                 | mov                 bh, 0x87
            //   71a6                 | jno                 0xffffffa8
            //   bef82d06be           | mov                 esi, 0xbe062df8
            //   6a55                 | push                0x55
            //   9aeede8c28ce52       | lcall               0x52ce:0x288cdeee
            //   91                   | xchg                eax, ecx
            //   b7d3                 | mov                 bh, 0xd3

        $sequence_5 = { b9???????? 894d08 c7471020000000 84d2 750c 38931e0b0000 0f8401030000 }
            // n = 7, score = 100
            //   b9????????           |                     
            //   894d08               | mov                 dword ptr [ebp + 8], ecx
            //   c7471020000000       | mov                 dword ptr [edi + 0x10], 0x20
            //   84d2                 | test                dl, dl
            //   750c                 | jne                 0xe
            //   38931e0b0000         | cmp                 byte ptr [ebx + 0xb1e], dl
            //   0f8401030000         | je                  0x307

        $sequence_6 = { e8???????? 8be5 5d c3 8db760010000 6a05 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   8db760010000         | lea                 esi, [edi + 0x160]
            //   6a05                 | push                5

        $sequence_7 = { 8b4514 83c408 83c9ff 5f 5e 8908 b001 }
            // n = 7, score = 100
            //   8b4514               | mov                 eax, dword ptr [ebp + 0x14]
            //   83c408               | add                 esp, 8
            //   83c9ff               | or                  ecx, 0xffffffff
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   8908                 | mov                 dword ptr [eax], ecx
            //   b001                 | mov                 al, 1

        $sequence_8 = { 8975fc eb28 33f6 b9???????? b041 0f1f00 3ac2 }
            // n = 7, score = 100
            //   8975fc               | mov                 dword ptr [ebp - 4], esi
            //   eb28                 | jmp                 0x2a
            //   33f6                 | xor                 esi, esi
            //   b9????????           |                     
            //   b041                 | mov                 al, 0x41
            //   0f1f00               | nop                 dword ptr [eax]
            //   3ac2                 | cmp                 al, dl

        $sequence_9 = { 8d4510 c7451000000000 50 56 e8???????? 83c40c 397d10 }
            // n = 7, score = 100
            //   8d4510               | lea                 eax, [ebp + 0x10]
            //   c7451000000000       | mov                 dword ptr [ebp + 0x10], 0
            //   50                   | push                eax
            //   56                   | push                esi
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   397d10               | cmp                 dword ptr [ebp + 0x10], edi

    condition:
        7 of them and filesize < 8692736
}