rule win_yorekey_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.yorekey."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.yorekey"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 750a 85c0 7506 ff15???????? }
            // n = 4, score = 200
            //   750a                 | jne                 0xc
            //   85c0                 | test                eax, eax
            //   7506                 | jne                 8
            //   ff15????????         |                     

        $sequence_1 = { 498bd7 488bcd e8???????? 85c0 0f85d9000000 488d1558fd0000 }
            // n = 6, score = 100
            //   498bd7               | mov                 dword ptr [esp + 8], ebx
            //   488bcd               | push                edi
            //   e8????????           |                     
            //   85c0                 | dec                 eax
            //   0f85d9000000         | sub                 esp, 0x20
            //   488d1558fd0000       | dec                 eax

        $sequence_2 = { 75f5 2bc2 8b15???????? d1f8 6a00 8d3400 }
            // n = 6, score = 100
            //   75f5                 | jne                 0xfffffff7
            //   2bc2                 | sub                 eax, edx
            //   8b15????????         |                     
            //   d1f8                 | sar                 eax, 1
            //   6a00                 | push                0
            //   8d3400               | lea                 esi, [eax + eax]

        $sequence_3 = { e8???????? 68???????? 8d45f4 50 c745f4e4d14000 e8???????? }
            // n = 6, score = 100
            //   e8????????           |                     
            //   68????????           |                     
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   50                   | push                eax
            //   c745f4e4d14000       | mov                 dword ptr [ebp - 0xc], 0x40d1e4
            //   e8????????           |                     

        $sequence_4 = { eb1a 488d0d7d1e0100 e8???????? cc 488d0d701e0100 }
            // n = 5, score = 100
            //   eb1a                 | mov                 edx, edi
            //   488d0d7d1e0100       | dec                 eax
            //   e8????????           |                     
            //   cc                   | mov                 ecx, ebp
            //   488d0d701e0100       | test                eax, eax

        $sequence_5 = { 7626 83f910 7305 b8???????? 53 bb???????? 2bd8 }
            // n = 7, score = 100
            //   7626                 | jbe                 0x28
            //   83f910               | cmp                 ecx, 0x10
            //   7305                 | jae                 7
            //   b8????????           |                     
            //   53                   | push                ebx
            //   bb????????           |                     
            //   2bd8                 | sub                 ebx, eax

        $sequence_6 = { 42888401a0a40100 ffc7 ebde 488b0d???????? 83c8ff f00fc101 }
            // n = 6, score = 100
            //   42888401a0a40100     | dec                 eax
            //   ffc7                 | lea                 ebx, [0x11973]
            //   ebde                 | inc                 edx
            //   488b0d????????       |                     
            //   83c8ff               | mov                 byte ptr [ecx + eax + 0x1a4a0], al
            //   f00fc101             | inc                 edi

        $sequence_7 = { 7420 48837daf10 727b 488b4d97 e8???????? b9c0270900 ff15???????? }
            // n = 7, score = 100
            //   7420                 | lea                 ebx, [0x1120f]
            //   48837daf10           | dec                 eax
            //   727b                 | lea                 edi, [0x11208]
            //   488b4d97             | jmp                 0x10
            //   e8????????           |                     
            //   b9c0270900           | dec                 ecx
            //   ff15????????         |                     

        $sequence_8 = { 0f1f00 0fb74c05c8 488d4002 6642898c003ec10100 6685c9 75e9 b801000000 }
            // n = 7, score = 100
            //   0f1f00               | jmp                 0xffffffe2
            //   0fb74c05c8           | or                  eax, 0xffffffff
            //   488d4002             | lock xadd           dword ptr [ecx], eax
            //   6642898c003ec10100     | nop    dword ptr [eax]
            //   6685c9               | movzx               ecx, word ptr [ebp + eax - 0x38]
            //   75e9                 | dec                 eax
            //   b801000000           | lea                 eax, [eax + 2]

        $sequence_9 = { c3 48895c2408 57 4883ec20 488d1d0f120100 488d3d08120100 eb0e }
            // n = 7, score = 100
            //   c3                   | inc                 dx
            //   48895c2408           | mov                 dword ptr [eax + eax + 0x1c13e], ecx
            //   57                   | test                cx, cx
            //   4883ec20             | jne                 0xffffffee
            //   488d1d0f120100       | mov                 eax, 1
            //   488d3d08120100       | ret                 
            //   eb0e                 | dec                 eax

        $sequence_10 = { 3b04cd60184100 7413 41 83f92d 72f1 }
            // n = 5, score = 100
            //   3b04cd60184100       | cmp                 eax, dword ptr [ecx*8 + 0x411860]
            //   7413                 | je                  0x15
            //   41                   | inc                 ecx
            //   83f92d               | cmp                 ecx, 0x2d
            //   72f1                 | jb                  0xfffffff3

        $sequence_11 = { 56 2bc1 50 8b8568ffffff 53 50 }
            // n = 6, score = 100
            //   56                   | push                esi
            //   2bc1                 | sub                 eax, ecx
            //   50                   | push                eax
            //   8b8568ffffff         | mov                 eax, dword ptr [ebp - 0x98]
            //   53                   | push                ebx
            //   50                   | push                eax

        $sequence_12 = { 83f83c 762a 56 e8???????? 8d0445cc1e4100 8bc8 }
            // n = 6, score = 100
            //   83f83c               | cmp                 eax, 0x3c
            //   762a                 | jbe                 0x2c
            //   56                   | push                esi
            //   e8????????           |                     
            //   8d0445cc1e4100       | lea                 eax, [eax*2 + 0x411ecc]
            //   8bc8                 | mov                 ecx, eax

        $sequence_13 = { 6bc930 8975e0 8db130154100 8975e4 eb2b 8a4601 84c0 }
            // n = 7, score = 100
            //   6bc930               | imul                ecx, ecx, 0x30
            //   8975e0               | mov                 dword ptr [ebp - 0x20], esi
            //   8db130154100         | lea                 esi, [ecx + 0x411530]
            //   8975e4               | mov                 dword ptr [ebp - 0x1c], esi
            //   eb2b                 | jmp                 0x2d
            //   8a4601               | mov                 al, byte ptr [esi + 1]
            //   84c0                 | test                al, al

        $sequence_14 = { eb04 4883c014 8938 e8???????? 488d1d73190100 }
            // n = 5, score = 100
            //   eb04                 | jmp                 6
            //   4883c014             | dec                 eax
            //   8938                 | add                 eax, 0x14
            //   e8????????           |                     
            //   488d1d73190100       | mov                 dword ptr [eax], edi

    condition:
        7 of them and filesize < 274432
}