rule win_zeus_openssl_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.zeus_openssl."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.zeus_openssl"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8981bc160000 8b4108 881c02 ff4114 }
            // n = 4, score = 1300
            //   8981bc160000         | mov                 dword ptr [ecx + 0x16bc], eax
            //   8b4108               | mov                 eax, dword ptr [ecx + 8]
            //   881c02               | mov                 byte ptr [edx + eax], bl
            //   ff4114               | inc                 dword ptr [ecx + 0x14]

        $sequence_1 = { 8945dc 0f855fffffff 85db 0f84d5000000 8d5eff 81c69e050000 8d3c71 }
            // n = 7, score = 1300
            //   8945dc               | mov                 dword ptr [ebp - 0x24], eax
            //   0f855fffffff         | jne                 0xffffff65
            //   85db                 | test                ebx, ebx
            //   0f84d5000000         | je                  0xdb
            //   8d5eff               | lea                 ebx, [esi - 1]
            //   81c69e050000         | add                 esi, 0x59e
            //   8d3c71               | lea                 edi, [ecx + esi*2]

        $sequence_2 = { 0fb600 8bcf d3e0 8d4f08 03d0 8b45f8 40 }
            // n = 7, score = 1300
            //   0fb600               | movzx               eax, byte ptr [eax]
            //   8bcf                 | mov                 ecx, edi
            //   d3e0                 | shl                 eax, cl
            //   8d4f08               | lea                 ecx, [edi + 8]
            //   03d0                 | add                 edx, eax
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   40                   | inc                 eax

        $sequence_3 = { b801000000 d3e0 8b4df4 48 23c2 014140 }
            // n = 6, score = 1300
            //   b801000000           | mov                 eax, 1
            //   d3e0                 | shl                 eax, cl
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   48                   | dec                 eax
            //   23c2                 | and                 eax, edx
            //   014140               | add                 dword ptr [ecx + 0x40], eax

        $sequence_4 = { 8bc8 d3ea 8b4df4 2bf0 0181c41b0000 8955f8 8b4140 }
            // n = 7, score = 1300
            //   8bc8                 | mov                 ecx, eax
            //   d3ea                 | shr                 edx, cl
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   2bf0                 | sub                 esi, eax
            //   0181c41b0000         | add                 dword ptr [ecx + 0x1bc4], eax
            //   8955f8               | mov                 dword ptr [ebp - 8], edx
            //   8b4140               | mov                 eax, dword ptr [ecx + 0x40]

        $sequence_5 = { 894df8 8b88bc160000 8bd6 2b55f8 }
            // n = 4, score = 1300
            //   894df8               | mov                 dword ptr [ebp - 8], ecx
            //   8b88bc160000         | mov                 ecx, dword ptr [eax + 0x16bc]
            //   8bd6                 | mov                 edx, esi
            //   2b55f8               | sub                 edx, dword ptr [ebp - 8]

        $sequence_6 = { 8b8570ffffff 2bda 8d0c81 894dac 8955b4 b801000000 }
            // n = 6, score = 1300
            //   8b8570ffffff         | mov                 eax, dword ptr [ebp - 0x90]
            //   2bda                 | sub                 ebx, edx
            //   8d0c81               | lea                 ecx, [ecx + eax*4]
            //   894dac               | mov                 dword ptr [ebp - 0x54], ecx
            //   8955b4               | mov                 dword ptr [ebp - 0x4c], edx
            //   b801000000           | mov                 eax, 1

        $sequence_7 = { c20400 56 8bf1 8a06 84c0 740c }
            // n = 6, score = 1300
            //   c20400               | ret                 4
            //   56                   | push                esi
            //   8bf1                 | mov                 esi, ecx
            //   8a06                 | mov                 al, byte ptr [esi]
            //   84c0                 | test                al, al
            //   740c                 | je                  0xe

        $sequence_8 = { 884dff 8a0c07 884dfe 8b4df0 8db002010000 3bb98c000000 7209 }
            // n = 7, score = 1300
            //   884dff               | mov                 byte ptr [ebp - 1], cl
            //   8a0c07               | mov                 cl, byte ptr [edi + eax]
            //   884dfe               | mov                 byte ptr [ebp - 2], cl
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   8db002010000         | lea                 esi, [eax + 0x102]
            //   3bb98c000000         | cmp                 edi, dword ptr [ecx + 0x8c]
            //   7209                 | jb                  0xb

        $sequence_9 = { 8b4708 894710 8b06 83781000 0f849c010000 8b5dfc 8b7e5c }
            // n = 7, score = 1300
            //   8b4708               | mov                 eax, dword ptr [edi + 8]
            //   894710               | mov                 dword ptr [edi + 0x10], eax
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   83781000             | cmp                 dword ptr [eax + 0x10], 0
            //   0f849c010000         | je                  0x1a2
            //   8b5dfc               | mov                 ebx, dword ptr [ebp - 4]
            //   8b7e5c               | mov                 edi, dword ptr [esi + 0x5c]

    condition:
        7 of them and filesize < 4546560
}