rule elf_blackcat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects elf.blackcat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/elf.blackcat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7227 b803000000 81fa???????? 721a }
            // n = 4, score = 200
            //   7227                 | mov                 edi, dword ptr [esp + 0x80]
            //   b803000000           | dec                 eax
            //   81fa????????         |                     
            //   721a                 | cmp                 dword ptr [ebp + edx], edi

        $sequence_1 = { b903000000 81fa???????? 721a b904000000 81fa???????? 720d }
            // n = 6, score = 200
            //   b903000000           | mov                 ecx, 2
            //   81fa????????         |                     
            //   721a                 | dec                 eax
            //   b904000000           | mov                 edi, eax
            //   81fa????????         |                     
            //   720d                 | dec                 esp

        $sequence_2 = { 08d9 80f901 750e 84c0 }
            // n = 4, score = 200
            //   08d9                 | jne                 0x449
            //   80f901               | dec                 eax
            //   750e                 | lea                 edi, [esp + 0x120]
            //   84c0                 | mov                 esi, ebp

        $sequence_3 = { 83f801 0f95c0 20c8 0fb6e8 }
            // n = 4, score = 200
            //   83f801               | je                  0x5c2
            //   0f95c0               | and                 ecx, 2
            //   20c8                 | xor                 ecx, 3
            //   0fb6e8               | cmp                 ecx, 1

        $sequence_4 = { 721a b904000000 81fa???????? 720d }
            // n = 4, score = 200
            //   721a                 | dec                 ecx
            //   b904000000           | lea                 edx, [esi + eax*8]
            //   81fa????????         |                     
            //   720d                 | jb                  0x803

        $sequence_5 = { e8???????? 0f0b 90 90 90 55 53 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   0f0b                 | lea                 ecx, [ebx - 0x24ac]
            //   90                   | ud2                 
            //   90                   | lea                 eax, [ebx - 0x24ac]
            //   90                   | mov                 ecx, esi
            //   55                   | ud2                 
            //   53                   | lea                 ecx, [ebx - 0x64a8]

        $sequence_6 = { e8???????? 0f0b 90 90 90 90 53 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   0f0b                 | lea                 eax, [ebx - 0x14c4]
            //   90                   | mov                 dword ptr [esp], eax
            //   90                   | ud2                 
            //   90                   | mov                 ebx, dword ptr [esp + 0x18]
            //   90                   | mov                 ecx, edi
            //   53                   | lea                 eax, [ebx - 0x15b4]

        $sequence_7 = { 5d c3 e8???????? 0f0b 90 90 90 }
            // n = 7, score = 200
            //   5d                   | lea                 eax, [ebx - 0x2570]
            //   c3                   | pop                 ebp
            //   e8????????           |                     
            //   0f0b                 | ret                 
            //   90                   | mov                 ebx, dword ptr [esp + 0x10]
            //   90                   | lea                 eax, [ebx - 0x3a28]
            //   90                   | jmp                 0x444

        $sequence_8 = { 762a 0fb6c8 8d1489 8d0cd1 c1e90c 6bd164 }
            // n = 6, score = 200
            //   762a                 | mov                 eax, dword ptr [edi + 0x70]
            //   0fb6c8               | dec                 eax
            //   8d1489               | test                ecx, ecx
            //   8d0cd1               | jbe                 0x501
            //   c1e90c               | dec                 eax
            //   6bd164               | shr                 ebp, 1

        $sequence_9 = { 7227 b803000000 81fa???????? 721a b804000000 81fa???????? }
            // n = 6, score = 200
            //   7227                 | mov                 esi, edi
            //   b803000000           | dec                 esp
            //   81fa????????         |                     
            //   721a                 | mov                 edx, esi
            //   b804000000           | jb                  0xb0
            //   81fa????????         |                     

    condition:
        7 of them and filesize < 8011776
}