rule elf_mirai_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects elf.mirai."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/elf.mirai"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 66894104 7406 66c741064000 c6410911 }
            // n = 4, score = 300
            //   66894104             | push                6
            //   7406                 | pop                 eax
            //   66c741064000         | push                0
            //   c6410911             | push                7

        $sequence_1 = { c1ea03 89d0 c1e005 01d0 89ca 29c2 }
            // n = 6, score = 300
            //   c1ea03               | sub                 esi, ebx
            //   89d0                 | dec                 eax
            //   c1e005               | mov                 edi, ebp
            //   01d0                 | cmp                 eax, -1
            //   89ca                 | dec                 eax
            //   29c2                 | mov                 edi, ebp

        $sequence_2 = { 66c1e808 d0e8 8d04c0 28c2 }
            // n = 4, score = 300
            //   66c1e808             | shl                 ecx, 5
            //   d0e8                 | mov                 word ptr [esi + 0x14], ax
            //   8d04c0               | jne                 0x44e
            //   28c2                 | mov                 word ptr [edi + 2], ax

        $sequence_3 = { e9???????? e8???????? 66894304 e9???????? }
            // n = 4, score = 300
            //   e9????????           |                     
            //   e8????????           |                     
            //   66894304             | lea                 edx, [esp + 0x2888]
            //   e9????????           |                     

        $sequence_4 = { 6689432a e8???????? c7433400000000 894330 c6433801 c6433903 c6433a03 }
            // n = 7, score = 300
            //   6689432a             | inc                 eax
            //   e8????????           |                     
            //   c7433400000000       | je                  0x116a
            //   894330               | mov                 edx, dword ptr [esp + 0x5c]
            //   c6433801             | push                ebp
            //   c6433903             | push                ebp
            //   c6433a03             | push                1

        $sequence_5 = { 8b1408 895310 8b54080c 66895314 }
            // n = 4, score = 300
            //   8b1408               | mov                 ebx, eax
            //   895310               | mov                 eax, dword ptr [esp + 0x24]
            //   8b54080c             | push                eax
            //   66895314             | mov                 ebx, eax

        $sequence_6 = { 89d0 c1e005 01d0 89ca }
            // n = 4, score = 300
            //   89d0                 | je                  0x819
            //   c1e005               | mov                 dword ptr [esp + 0x40], eax
            //   01d0                 | add                 esp, 0x10
            //   89ca                 | mov                 esi, eax

        $sequence_7 = { 3c19 7705 8d42e0 8801 }
            // n = 4, score = 300
            //   3c19                 | inc                 ebp
            //   7705                 | xor                 ecx, ecx
            //   8d42e0               | inc                 ebp
            //   8801                 | xor                 eax, eax

        $sequence_8 = { c1e005 01d0 89ca 29c2 }
            // n = 4, score = 300
            //   c1e005               | test                eax, eax
            //   01d0                 | jle                 0x6fb
            //   89ca                 | mov                 ebx, dword ptr [esp + 0x48]
            //   29c2                 | mov                 byte ptr [edi], al

        $sequence_9 = { e9???????? e8???????? 66894314 e9???????? }
            // n = 4, score = 300
            //   e9????????           |                     
            //   e8????????           |                     
            //   66894314             | add                 edx, ebx
            //   e9????????           |                     

    condition:
        7 of them and filesize < 2228224
}