rule elf_nosedive_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects elf.nosedive."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/elf.nosedive"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e9???????? 8b06 488b7c2408 4589ed 8907 428b442efc 4289442ffc }
            // n = 7, score = 100
            //   e9????????           |                     
            //   8b06                 | lea                 eax, [0xf5aaf]
            //   488b7c2408           | mov                 ecx, 0xf91
            //   4589ed               | mov                 ecx, 0x1132
            //   8907                 | dec                 esp
            //   428b442efc           | mov                 edx, esp
            //   4289442ffc           | dec                 esp

        $sequence_1 = { c644240800 8b7b10 31c9 488db42404010000 4989e4 ba02000000 e8???????? }
            // n = 7, score = 100
            //   c644240800           | mov                 dword ptr [ebx + 0x18], ebp
            //   8b7b10               | movd                xmm4, eax
            //   31c9                 | movzx               eax, word ptr [esp + 0x1e]
            //   488db42404010000     | mov                 byte ptr [ebx + 9], 0x2f
            //   4989e4               | movd                xmm5, eax
            //   ba02000000           | movzx               eax, word ptr [esp + 0x24]
            //   e8????????           |                     

        $sequence_2 = { ebe9 4531f6 4531ff 488b6c2410 4c397320 7630 488b4318 }
            // n = 7, score = 100
            //   ebe9                 | inc                 ecx
            //   4531f6               | mov                 eax, dword ptr [edx]
            //   4531ff               | and                 eax, 7
            //   488b6c2410           | dec                 ecx
            //   4c397320             | cmp                 ebp, eax
            //   7630                 | jae                 0x722
            //   488b4318             | inc                 ebx

        $sequence_3 = { e8???????? 5f b8008fffff 4158 e9???????? 4c8d05117f0f00 b974090000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   5f                   | mov                 eax, eax
            //   b8008fffff           | mov                 eax, 0x4000
            //   4158                 | dec                 ecx
            //   e9????????           |                     
            //   4c8d05117f0f00       | cmp                 eax, eax
            //   b974090000           | dec                 ecx

        $sequence_4 = { eb17 4889de 4889ef e8???????? 48895d10 48895d18 4c897520 }
            // n = 7, score = 100
            //   eb17                 | mov                 dword ptr [ebp], eax
            //   4889de               | dec                 ecx
            //   4889ef               | mov                 dword ptr [esp], 2
            //   e8????????           |                     
            //   48895d10             | dec                 eax
            //   48895d18             | add                 esp, 0x38
            //   4c897520             | pop                 ebx

        $sequence_5 = { b93f000000 4429f9 4585c9 7527 4139ca 7d27 418d4f01 }
            // n = 7, score = 100
            //   b93f000000           | test                eax, eax
            //   4429f9               | mov                 ecx, 0x30
            //   4585c9               | dec                 eax
            //   7527                 | mov                 edi, ebp
            //   4139ca               | dec                 ecx
            //   7d27                 | mov                 ebp, esi
            //   418d4f01             | dec                 eax

        $sequence_6 = { f348ab 49837e6000 4d896e70 49895e78 751e b810000000 4983ff14 }
            // n = 7, score = 100
            //   f348ab               | movq                mm2, qword ptr [esp + 0x80]
            //   49837e6000           | pxor                xmm0, xmm2
            //   4d896e70             | movups              xmmword ptr [ebp + 0x80], xmm0
            //   49895e78             | movdqu              xmm0, xmmword ptr [edx + 0x80]
            //   751e                 | inc                 ecx
            //   b810000000           | movq                mm3, qword ptr [esp + 0x80]
            //   4983ff14             | pxor                xmm0, xmm3

        $sequence_7 = { c3 83c8ff 48397e08 7543 8b07 4c634610 2500010000 }
            // n = 7, score = 100
            //   c3                   | dec                 eax
            //   83c8ff               | mov                 edx, edi
            //   48397e08             | inc                 ecx
            //   7543                 | push                esi
            //   8b07                 | inc                 ecx
            //   4c634610             | push                ebp
            //   2500010000           | inc                 ecx

        $sequence_8 = { e8???????? 8b4c243c ffc0 7516 48c7c098ffffff 6483385a 0f85e8010000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b4c243c             | mov                 dword ptr [esp + 0x24], eax
            //   ffc0                 | mov                 dword ptr [esp + 0x24], eax
            //   7516                 | dec                 ebp
            //   48c7c098ffffff       | test                esp, esp
            //   6483385a             | je                  0x3e7
            //   0f85e8010000         | dec                 esp

        $sequence_9 = { e9???????? 48ffc0 80fa3a 7408 8a10 84d2 75f2 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   48ffc0               | dec                 eax
            //   80fa3a               | mov                 eax, dword ptr [edi + 0xa0]
            //   7408                 | bt                  edx, 0xb
            //   8a10                 | inc                 ecx
            //   84d2                 | mov                 esp, esi
            //   75f2                 | dec                 eax

    condition:
        7 of them and filesize < 3268608
}