rule elf_persirai_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects elf.persirai."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/elf.persirai"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d680c 8b400c 83e0fe 85c0 75e6 }
            // n = 5, score = 100
            //   8d680c               | lea                 ebp, [eax + 0xc]
            //   8b400c               | mov                 eax, dword ptr [eax + 0xc]
            //   83e0fe               | and                 eax, 0xfffffffe
            //   85c0                 | test                eax, eax
            //   75e6                 | jne                 0xffffffe8

        $sequence_1 = { 51 e8???????? 8d5c2424 89f1 89df 89e8 fc }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   e8????????           |                     
            //   8d5c2424             | lea                 ebx, [esp + 0x24]
            //   89f1                 | mov                 ecx, esi
            //   89df                 | mov                 edi, ebx
            //   89e8                 | mov                 eax, ebp
            //   fc                   | cld                 

        $sequence_2 = { 7423 0fbed0 a1???????? 8854243b 85c0 0f84f9000000 8810 }
            // n = 7, score = 100
            //   7423                 | je                  0x25
            //   0fbed0               | movsx               edx, al
            //   a1????????           |                     
            //   8854243b             | mov                 byte ptr [esp + 0x3b], dl
            //   85c0                 | test                eax, eax
            //   0f84f9000000         | je                  0xff
            //   8810                 | mov                 byte ptr [eax], dl

        $sequence_3 = { 52 8b5020 53 50 ff5208 83c410 }
            // n = 6, score = 100
            //   52                   | push                edx
            //   8b5020               | mov                 edx, dword ptr [eax + 0x20]
            //   53                   | push                ebx
            //   50                   | push                eax
            //   ff5208               | call                dword ptr [edx + 8]
            //   83c410               | add                 esp, 0x10

        $sequence_4 = { 6648 759f 53 53 57 8d44244c 50 }
            // n = 7, score = 100
            //   6648                 | dec                 ax
            //   759f                 | jne                 0xffffffa1
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   57                   | push                edi
            //   8d44244c             | lea                 eax, [esp + 0x4c]
            //   50                   | push                eax

        $sequence_5 = { 56 53 83ec0c 89c7 be???????? }
            // n = 5, score = 100
            //   56                   | push                esi
            //   53                   | push                ebx
            //   83ec0c               | sub                 esp, 0xc
            //   89c7                 | mov                 edi, eax
            //   be????????           |                     

        $sequence_6 = { 89d0 5a 59 5b c3 8b442404 8b542408 }
            // n = 7, score = 100
            //   89d0                 | mov                 eax, edx
            //   5a                   | pop                 edx
            //   59                   | pop                 ecx
            //   5b                   | pop                 ebx
            //   c3                   | ret                 
            //   8b442404             | mov                 eax, dword ptr [esp + 4]
            //   8b542408             | mov                 edx, dword ptr [esp + 8]

        $sequence_7 = { eb0c 89c2 8b02 39c1 75f8 8b01 8902 }
            // n = 7, score = 100
            //   eb0c                 | jmp                 0xe
            //   89c2                 | mov                 edx, eax
            //   8b02                 | mov                 eax, dword ptr [edx]
            //   39c1                 | cmp                 ecx, eax
            //   75f8                 | jne                 0xfffffffa
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   8902                 | mov                 dword ptr [edx], eax

        $sequence_8 = { e8???????? 89c3 8bb098000000 85f6 751c 50 50 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   89c3                 | mov                 ebx, eax
            //   8bb098000000         | mov                 esi, dword ptr [eax + 0x98]
            //   85f6                 | test                esi, esi
            //   751c                 | jne                 0x1e
            //   50                   | push                eax
            //   50                   | push                eax

        $sequence_9 = { 84c0 742a 8d7600 46 3c25 742b 0fbed0 }
            // n = 7, score = 100
            //   84c0                 | test                al, al
            //   742a                 | je                  0x2c
            //   8d7600               | lea                 esi, [esi]
            //   46                   | inc                 esi
            //   3c25                 | cmp                 al, 0x25
            //   742b                 | je                  0x2d
            //   0fbed0               | movsx               edx, al

    condition:
        7 of them and filesize < 229376
}