rule elf_satori_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects elf.satori."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/elf.satori"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 75f0 83ec0c ebcd 8d65f8 5b 5e }
            // n = 6, score = 100
            //   75f0                 | jne                 0xfffffff2
            //   83ec0c               | sub                 esp, 0xc
            //   ebcd                 | jmp                 0xffffffcf
            //   8d65f8               | lea                 esp, [ebp - 8]
            //   5b                   | pop                 ebx
            //   5e                   | pop                 esi

        $sequence_1 = { c7411849260508 eb28 83f83e 7509 c7411851260508 eb1a 83f82a }
            // n = 7, score = 100
            //   c7411849260508       | mov                 dword ptr [ecx + 0x18], 0x8052649
            //   eb28                 | jmp                 0x2a
            //   83f83e               | cmp                 eax, 0x3e
            //   7509                 | jne                 0xb
            //   c7411851260508       | mov                 dword ptr [ecx + 0x18], 0x8052651
            //   eb1a                 | jmp                 0x1c
            //   83f82a               | cmp                 eax, 0x2a

        $sequence_2 = { 50 e8???????? 83c410 eb22 50 55 }
            // n = 6, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   eb22                 | jmp                 0x24
            //   50                   | push                eax
            //   55                   | push                ebp

        $sequence_3 = { 894304 e8???????? a1???????? 66897308 c7430c00000000 c6430aff 89580c }
            // n = 7, score = 100
            //   894304               | mov                 dword ptr [ebx + 4], eax
            //   e8????????           |                     
            //   a1????????           |                     
            //   66897308             | mov                 word ptr [ebx + 8], si
            //   c7430c00000000       | mov                 dword ptr [ebx + 0xc], 0
            //   c6430aff             | mov                 byte ptr [ebx + 0xa], 0xff
            //   89580c               | mov                 dword ptr [eax + 0xc], ebx

        $sequence_4 = { 0fb7c0 894704 8b441108 66c1c808 }
            // n = 4, score = 100
            //   0fb7c0               | movzx               eax, ax
            //   894704               | mov                 dword ptr [edi + 4], eax
            //   8b441108             | mov                 eax, dword ptr [ecx + edx + 8]
            //   66c1c808             | ror                 ax, 8

        $sequence_5 = { e9???????? 0fbe19 b800000080 41 c744240801000000 eb12 }
            // n = 6, score = 100
            //   e9????????           |                     
            //   0fbe19               | movsx               ebx, byte ptr [ecx]
            //   b800000080           | mov                 eax, 0x80000000
            //   41                   | inc                 ecx
            //   c744240801000000     | mov                 dword ptr [esp + 8], 1
            //   eb12                 | jmp                 0x14

        $sequence_6 = { e8???????? 89e8 c7851c040000ffffffff e8???????? 83c410 e9???????? }
            // n = 6, score = 100
            //   e8????????           |                     
            //   89e8                 | mov                 eax, ebp
            //   c7851c040000ffffffff     | mov    dword ptr [ebp + 0x41c], 0xffffffff
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   e9????????           |                     

        $sequence_7 = { 80cc08 50 6a04 ff35???????? e8???????? 8d842468090000 }
            // n = 6, score = 100
            //   80cc08               | or                  ah, 8
            //   50                   | push                eax
            //   6a04                 | push                4
            //   ff35????????         |                     
            //   e8????????           |                     
            //   8d842468090000       | lea                 eax, [esp + 0x968]

        $sequence_8 = { 41 eb9b 85ed 790f }
            // n = 4, score = 100
            //   41                   | inc                 ecx
            //   eb9b                 | jmp                 0xffffff9d
            //   85ed                 | test                ebp, ebp
            //   790f                 | jns                 0x11

        $sequence_9 = { 83c410 807b021f 742c 8d143b 8a02 3cfd 7404 }
            // n = 7, score = 100
            //   83c410               | add                 esp, 0x10
            //   807b021f             | cmp                 byte ptr [ebx + 2], 0x1f
            //   742c                 | je                  0x2e
            //   8d143b               | lea                 edx, [ebx + edi]
            //   8a02                 | mov                 al, byte ptr [edx]
            //   3cfd                 | cmp                 al, 0xfd
            //   7404                 | je                  6

    condition:
        7 of them and filesize < 122880
}