rule osx_dacls_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/osx.dacls"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { b8fdffffff 40 80ff80 75d2 48 83e31f 48 }
            // n = 7, score = 100
            //   b8fdffffff           | mov                 eax, 0xfffffffd
            //   40                   | inc                 eax
            //   80ff80               | cmp                 bh, 0x80
            //   75d2                 | jne                 0xffffffd4
            //   48                   | dec                 eax
            //   83e31f               | and                 ebx, 0x1f
            //   48                   | dec                 eax

        $sequence_1 = { 09ca 81e2???????? 0fb6b3ac020000 89f1 83e10f c1e108 01d1 }
            // n = 7, score = 100
            //   09ca                 | or                  edx, ecx
            //   81e2????????         |                     
            //   0fb6b3ac020000       | movzx               esi, byte ptr [ebx + 0x2ac]
            //   89f1                 | mov                 ecx, esi
            //   83e10f               | and                 ecx, 0xf
            //   c1e108               | shl                 ecx, 8
            //   01d1                 | add                 ecx, edx

        $sequence_2 = { 48 8b5150 48 8b7158 48 89b380010000 48 }
            // n = 7, score = 100
            //   48                   | dec                 eax
            //   8b5150               | mov                 edx, dword ptr [ecx + 0x50]
            //   48                   | dec                 eax
            //   8b7158               | mov                 esi, dword ptr [ecx + 0x58]
            //   48                   | dec                 eax
            //   89b380010000         | mov                 dword ptr [ebx + 0x180], esi
            //   48                   | dec                 eax

        $sequence_3 = { eb1c 48 8bbc2490000000 e8???????? 48 8b7c2458 e8???????? }
            // n = 7, score = 100
            //   eb1c                 | jmp                 0x1e
            //   48                   | dec                 eax
            //   8bbc2490000000       | mov                 edi, dword ptr [esp + 0x90]
            //   e8????????           |                     
            //   48                   | dec                 eax
            //   8b7c2458             | mov                 edi, dword ptr [esp + 0x58]
            //   e8????????           |                     

        $sequence_4 = { c744247800000000 48 c784248000000000000000 48 c784248800000000000000 c684249000000000 c684249100000000 }
            // n = 7, score = 100
            //   c744247800000000     | mov                 dword ptr [esp + 0x78], 0
            //   48                   | dec                 eax
            //   c784248000000000000000     | mov    dword ptr [esp + 0x80], 0
            //   48                   | dec                 eax
            //   c784248800000000000000     | mov    dword ptr [esp + 0x88], 0
            //   c684249000000000     | mov                 byte ptr [esp + 0x90], 0
            //   c684249100000000     | mov                 byte ptr [esp + 0x91], 0

        $sequence_5 = { e8???????? 48 89d9 4d 8bb548010000 41 8b9d50010000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   48                   | dec                 eax
            //   89d9                 | mov                 ecx, ebx
            //   4d                   | dec                 ebp
            //   8bb548010000         | mov                 esi, dword ptr [ebp + 0x148]
            //   41                   | inc                 ecx
            //   8b9d50010000         | mov                 ebx, dword ptr [ebp + 0x150]

        $sequence_6 = { 4c 89ff 48 89c6 48 89d9 e8???????? }
            // n = 7, score = 100
            //   4c                   | dec                 esp
            //   89ff                 | mov                 edi, edi
            //   48                   | dec                 eax
            //   89c6                 | mov                 esi, eax
            //   48                   | dec                 eax
            //   89d9                 | mov                 ecx, ebx
            //   e8????????           |                     

        $sequence_7 = { eb2d 48 8b7c2410 8b4c241c 48 8d742428 48 }
            // n = 7, score = 100
            //   eb2d                 | jmp                 0x2f
            //   48                   | dec                 eax
            //   8b7c2410             | mov                 edi, dword ptr [esp + 0x10]
            //   8b4c241c             | mov                 ecx, dword ptr [esp + 0x1c]
            //   48                   | dec                 eax
            //   8d742428             | lea                 esi, [esp + 0x28]
            //   48                   | dec                 eax

        $sequence_8 = { e8???????? 49 89c4 48 89442408 48 8d542410 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   49                   | dec                 ecx
            //   89c4                 | mov                 esp, eax
            //   48                   | dec                 eax
            //   89442408             | mov                 dword ptr [esp + 8], eax
            //   48                   | dec                 eax
            //   8d542410             | lea                 edx, [esp + 0x10]

        $sequence_9 = { 0f88dc000000 48 63ee 31f6 662e0f1f840000000000 0f1f4000 49 }
            // n = 7, score = 100
            //   0f88dc000000         | js                  0xe2
            //   48                   | dec                 eax
            //   63ee                 | arpl                si, bp
            //   31f6                 | xor                 esi, esi
            //   662e0f1f840000000000     | nop    word ptr cs:[eax + eax]
            //   0f1f4000             | nop                 dword ptr [eax]
            //   49                   | dec                 ecx

    condition:
        7 of them and filesize < 1346184
}