rule osx_uroburos_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/osx.uroburos"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e9???????? 4c 8975c0 49 83bf3002000000 0f84dd010000 41 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   4c                   | dec                 esp
            //   8975c0               | mov                 dword ptr [ebp - 0x40], esi
            //   49                   | dec                 ecx
            //   83bf3002000000       | cmp                 dword ptr [edi + 0x230], 0
            //   0f84dd010000         | je                  0x1e3
            //   41                   | inc                 ecx

        $sequence_1 = { 8d0df13d0500 48 8b4920 49 894e30 48 83c418 }
            // n = 7, score = 100
            //   8d0df13d0500         | lea                 ecx, [0x53df1]
            //   48                   | dec                 eax
            //   8b4920               | mov                 ecx, dword ptr [ecx + 0x20]
            //   49                   | dec                 ecx
            //   894e30               | mov                 dword ptr [esi + 0x30], ecx
            //   48                   | dec                 eax
            //   83c418               | add                 esp, 0x18

        $sequence_2 = { e8???????? 85c0 7e3b 4c 8d7dd0 90 48 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7e3b                 | jle                 0x3d
            //   4c                   | dec                 esp
            //   8d7dd0               | lea                 edi, [ebp - 0x30]
            //   90                   | nop                 
            //   48                   | dec                 eax

        $sequence_3 = { eb48 b801000000 eb41 b801000000 eb3a 48 8b7b08 }
            // n = 7, score = 100
            //   eb48                 | jmp                 0x4a
            //   b801000000           | mov                 eax, 1
            //   eb41                 | jmp                 0x43
            //   b801000000           | mov                 eax, 1
            //   eb3a                 | jmp                 0x3c
            //   48                   | dec                 eax
            //   8b7b08               | mov                 edi, dword ptr [ebx + 8]

        $sequence_4 = { c707???????? bf???????? e8???????? 49 890424 48 85c0 }
            // n = 7, score = 100
            //   c707????????         |                     
            //   bf????????           |                     
            //   e8????????           |                     
            //   49                   | dec                 ecx
            //   890424               | mov                 dword ptr [esp], eax
            //   48                   | dec                 eax
            //   85c0                 | test                eax, eax

        $sequence_5 = { c7450000000000 41 bc0a005921 eb1b 48 8b7dd0 e8???????? }
            // n = 7, score = 100
            //   c7450000000000       | mov                 dword ptr [ebp], 0
            //   41                   | inc                 ecx
            //   bc0a005921           | mov                 esp, 0x2159000a
            //   eb1b                 | jmp                 0x1d
            //   48                   | dec                 eax
            //   8b7dd0               | mov                 edi, dword ptr [ebp - 0x30]
            //   e8????????           |                     

        $sequence_6 = { eb39 48 8d3538a50500 ba???????? 48 89df e8???????? }
            // n = 7, score = 100
            //   eb39                 | jmp                 0x3b
            //   48                   | dec                 eax
            //   8d3538a50500         | lea                 esi, [0x5a538]
            //   ba????????           |                     
            //   48                   | dec                 eax
            //   89df                 | mov                 edi, ebx
            //   e8????????           |                     

        $sequence_7 = { 8945d0 48 39c8 49 89cd 772d 4c }
            // n = 7, score = 100
            //   8945d0               | mov                 dword ptr [ebp - 0x30], eax
            //   48                   | dec                 eax
            //   39c8                 | cmp                 eax, ecx
            //   49                   | dec                 ecx
            //   89cd                 | mov                 ebp, ecx
            //   772d                 | ja                  0x2f
            //   4c                   | dec                 esp

        $sequence_8 = { e8???????? 49 89c6 4d 85f6 0f84ff030000 48 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   49                   | dec                 ecx
            //   89c6                 | mov                 esi, eax
            //   4d                   | dec                 ebp
            //   85f6                 | test                esi, esi
            //   0f84ff030000         | je                  0x405
            //   48                   | dec                 eax

        $sequence_9 = { eb03 4d 89e7 48 63c3 c68405d0fdffff00 80bdd0fdffff00 }
            // n = 7, score = 100
            //   eb03                 | jmp                 5
            //   4d                   | dec                 ebp
            //   89e7                 | mov                 edi, esp
            //   48                   | dec                 eax
            //   63c3                 | arpl                bx, ax
            //   c68405d0fdffff00     | mov                 byte ptr [ebp + eax - 0x230], 0
            //   80bdd0fdffff00       | cmp                 byte ptr [ebp - 0x230], 0

    condition:
        7 of them and filesize < 4020856
}