rule osx_xslcmd_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-04-21"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.3.1"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/osx.xslcmd"
        malpedia_version = "20200421"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using yara-signator.
     * The code and documentation / approach will be published in the near future here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 5c 41 5d c9 c3 ff25???????? ff25???????? }
            // n = 7, score = 100
            //   5c                   | pop                 esp
            //   41                   | inc                 ecx
            //   5d                   | pop                 ebp
            //   c9                   | leave               
            //   c3                   | ret                 
            //   ff25????????         |                     
            //   ff25????????         |                     

        $sequence_1 = { 48 89c6 4c 89e7 e8???????? 8b05???????? }
            // n = 6, score = 100
            //   48                   | dec                 eax
            //   89c6                 | mov                 esi, eax
            //   4c                   | dec                 esp
            //   89e7                 | mov                 edi, esp
            //   e8????????           |                     
            //   8b05????????         |                     

        $sequence_2 = { 29d0 44 8d68f9 48 8d5a07 45 31e4 }
            // n = 7, score = 100
            //   29d0                 | sub                 eax, edx
            //   44                   | inc                 esp
            //   8d68f9               | lea                 ebp, [eax - 7]
            //   48                   | dec                 eax
            //   8d5a07               | lea                 ebx, [edx + 7]
            //   45                   | inc                 ebp
            //   31e4                 | xor                 esp, esp

        $sequence_3 = { 4c 897df8 48 83ec30 48 89fb 41 }
            // n = 7, score = 100
            //   4c                   | dec                 esp
            //   897df8               | mov                 dword ptr [ebp - 8], edi
            //   48                   | dec                 eax
            //   83ec30               | sub                 esp, 0x30
            //   48                   | dec                 eax
            //   89fb                 | mov                 ebx, edi
            //   41                   | inc                 ecx

        $sequence_4 = { 0fb646ff 0fb64fff 29c8 85c0 750f 8b4508 }
            // n = 6, score = 100
            //   0fb646ff             | movzx               eax, byte ptr [esi - 1]
            //   0fb64fff             | movzx               ecx, byte ptr [edi - 1]
            //   29c8                 | sub                 eax, ecx
            //   85c0                 | test                eax, eax
            //   750f                 | jne                 0x11
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]

        $sequence_5 = { 8d5f0c 890424 e8???????? 8945d4 8d4611 890424 e8???????? }
            // n = 7, score = 100
            //   8d5f0c               | lea                 ebx, [edi + 0xc]
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     
            //   8945d4               | mov                 dword ptr [ebp - 0x2c], eax
            //   8d4611               | lea                 eax, [esi + 0x11]
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     

        $sequence_6 = { 8b55e4 891424 e8???????? 85db 0f8484040000 85c0 }
            // n = 6, score = 100
            //   8b55e4               | mov                 edx, dword ptr [ebp - 0x1c]
            //   891424               | mov                 dword ptr [esp], edx
            //   e8????????           |                     
            //   85db                 | test                ebx, ebx
            //   0f8484040000         | je                  0x48a
            //   85c0                 | test                eax, eax

        $sequence_7 = { 48 89df e8???????? 4c 8dbd30feffff ba90010000 31f6 }
            // n = 7, score = 100
            //   48                   | dec                 eax
            //   89df                 | mov                 edi, ebx
            //   e8????????           |                     
            //   4c                   | dec                 esp
            //   8dbd30feffff         | lea                 edi, [ebp - 0x1d0]
            //   ba90010000           | mov                 edx, 0x190
            //   31f6                 | xor                 esi, esi

        $sequence_8 = { a1???????? 89442410 0fb705???????? 8944240c c7442408e0660100 8d55c4 89542404 }
            // n = 7, score = 100
            //   a1????????           |                     
            //   89442410             | mov                 dword ptr [esp + 0x10], eax
            //   0fb705????????       |                     
            //   8944240c             | mov                 dword ptr [esp + 0xc], eax
            //   c7442408e0660100     | mov                 dword ptr [esp + 8], 0x166e0
            //   8d55c4               | lea                 edx, [ebp - 0x3c]
            //   89542404             | mov                 dword ptr [esp + 4], edx

        $sequence_9 = { 48 89df ff15???????? 48 89c6 44 89e2 }
            // n = 7, score = 100
            //   48                   | dec                 eax
            //   89df                 | mov                 edi, ebx
            //   ff15????????         |                     
            //   48                   | dec                 eax
            //   89c6                 | mov                 esi, eax
            //   44                   | inc                 esp
            //   89e2                 | mov                 edx, esp

    condition:
        7 of them and filesize < 690720
}
