rule osx_yort_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/osx.yort"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 31f6 ba02000000 4c 89ef e8???????? 4c 89ef }
            // n = 7, score = 100
            //   31f6                 | xor                 esi, esi
            //   ba02000000           | mov                 edx, 2
            //   4c                   | dec                 esp
            //   89ef                 | mov                 edi, ebp
            //   e8????????           |                     
            //   4c                   | dec                 esp
            //   89ef                 | mov                 edi, ebp

        $sequence_1 = { 6381a00a0000 48 69c0???????? 48 8d740154 4c }
            // n = 6, score = 100
            //   6381a00a0000         | arpl                word ptr [ecx + 0xaa0], ax
            //   48                   | dec                 eax
            //   69c0????????         |                     
            //   48                   | dec                 eax
            //   8d740154             | lea                 esi, [ecx + eax + 0x54]
            //   4c                   | dec                 esp

        $sequence_2 = { 8d740654 48 8dbd78faffff 48 8b9560baffff }
            // n = 5, score = 100
            //   8d740654             | lea                 esi, [esi + eax + 0x54]
            //   48                   | dec                 eax
            //   8dbd78faffff         | lea                 edi, [ebp - 0x588]
            //   48                   | dec                 eax
            //   8b9560baffff         | mov                 edx, dword ptr [ebp - 0x45a0]

        $sequence_3 = { 81fc???????? b8???????? 41 0f42c4 49 }
            // n = 5, score = 100
            //   81fc????????         |                     
            //   b8????????           |                     
            //   41                   | inc                 ecx
            //   0f42c4               | cmovb               eax, esp
            //   49                   | dec                 ecx

        $sequence_4 = { 8bbd50baffff 4c 89e1 e8???????? 85c0 4c }
            // n = 6, score = 100
            //   8bbd50baffff         | mov                 edi, dword ptr [ebp - 0x45b0]
            //   4c                   | dec                 esp
            //   89e1                 | mov                 ecx, esp
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   4c                   | dec                 esp

        $sequence_5 = { 31ff ba06000000 45 31c0 4c 89f1 e8???????? }
            // n = 7, score = 100
            //   31ff                 | xor                 edi, edi
            //   ba06000000           | mov                 edx, 6
            //   45                   | inc                 ebp
            //   31c0                 | xor                 eax, eax
            //   4c                   | dec                 esp
            //   89f1                 | mov                 ecx, esi
            //   e8????????           |                     

        $sequence_6 = { 0f8cd0040000 31c0 e8???????? 0385607affff 39c3 }
            // n = 5, score = 100
            //   0f8cd0040000         | jl                  0x4d6
            //   31c0                 | xor                 eax, eax
            //   e8????????           |                     
            //   0385607affff         | add                 eax, dword ptr [ebp - 0x85a0]
            //   39c3                 | cmp                 ebx, eax

        $sequence_7 = { 49 638424a00a0000 48 69c0???????? 49 8d740454 49 }
            // n = 7, score = 100
            //   49                   | dec                 ecx
            //   638424a00a0000       | arpl                word ptr [esp + 0xaa0], ax
            //   48                   | dec                 eax
            //   69c0????????         |                     
            //   49                   | dec                 ecx
            //   8d740454             | lea                 esi, [esp + eax + 0x54]
            //   49                   | dec                 ecx

        $sequence_8 = { 8b00 48 3b45e0 0f85a3000000 }
            // n = 4, score = 100
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   48                   | dec                 eax
            //   3b45e0               | cmp                 eax, dword ptr [ebp - 0x20]
            //   0f85a3000000         | jne                 0xa9

        $sequence_9 = { 48 8db5587affff e8???????? 89c3 31c0 }
            // n = 5, score = 100
            //   48                   | dec                 eax
            //   8db5587affff         | lea                 esi, [ebp - 0x85a8]
            //   e8????????           |                     
            //   89c3                 | mov                 ebx, eax
            //   31c0                 | xor                 eax, eax

    condition:
        7 of them and filesize < 57768
}