rule win_8base_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.8base."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.8base"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a00 ff15???????? 8d8e04a2feff 81f98c230000 770b }
            // n = 5, score = 100
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   8d8e04a2feff         | lea                 ecx, [esi - 0x15dfc]
            //   81f98c230000         | cmp                 ecx, 0x238c
            //   770b                 | ja                  0xd

        $sequence_1 = { 8b5104 8b4c2408 c74432f45c394000 5e }
            // n = 4, score = 100
            //   8b5104               | mov                 edx, dword ptr [ecx + 4]
            //   8b4c2408             | mov                 ecx, dword ptr [esp + 8]
            //   c74432f45c394000     | mov                 dword ptr [edx + esi - 0xc], 0x40395c
            //   5e                   | pop                 esi

        $sequence_2 = { 8815???????? c605????????6f 880d???????? c605????????65 c605????????63 }
            // n = 5, score = 100
            //   8815????????         |                     
            //   c605????????6f       |                     
            //   880d????????         |                     
            //   c605????????65       |                     
            //   c605????????63       |                     

        $sequence_3 = { 8d3485c0289100 8b06 83e71f c1e706 03c7 8a5824 }
            // n = 6, score = 100
            //   8d3485c0289100       | lea                 esi, [eax*4 + 0x9128c0]
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   83e71f               | and                 edi, 0x1f
            //   c1e706               | shl                 edi, 6
            //   03c7                 | add                 eax, edi
            //   8a5824               | mov                 bl, byte ptr [eax + 0x24]

        $sequence_4 = { c684249c00000002 50 c7442410043a4000 e8???????? }
            // n = 4, score = 100
            //   c684249c00000002     | mov                 byte ptr [esp + 0x9c], 2
            //   50                   | push                eax
            //   c7442410043a4000     | mov                 dword ptr [esp + 0x10], 0x403a04
            //   e8????????           |                     

        $sequence_5 = { d3ea 89542414 8b442434 01442414 8b442424 31442410 }
            // n = 6, score = 100
            //   d3ea                 | shr                 edx, cl
            //   89542414             | mov                 dword ptr [esp + 0x14], edx
            //   8b442434             | mov                 eax, dword ptr [esp + 0x34]
            //   01442414             | add                 dword ptr [esp + 0x14], eax
            //   8b442424             | mov                 eax, dword ptr [esp + 0x24]
            //   31442410             | xor                 dword ptr [esp + 0x10], eax

        $sequence_6 = { ff15???????? 8b442414 40 3d???????? 89442414 0f8c0effffff 8b35???????? }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   8b442414             | mov                 eax, dword ptr [esp + 0x14]
            //   40                   | inc                 eax
            //   3d????????           |                     
            //   89442414             | mov                 dword ptr [esp + 0x14], eax
            //   0f8c0effffff         | jl                  0xffffff14
            //   8b35????????         |                     

        $sequence_7 = { 8bf7 83e61f c1e606 033485c0289100 c745e401000000 }
            // n = 5, score = 100
            //   8bf7                 | mov                 esi, edi
            //   83e61f               | and                 esi, 0x1f
            //   c1e606               | shl                 esi, 6
            //   033485c0289100       | add                 esi, dword ptr [eax*4 + 0x9128c0]
            //   c745e401000000       | mov                 dword ptr [ebp - 0x1c], 1

        $sequence_8 = { 6689442416 33c9 668954241a 8d442434 50 66894c241c 8b4c241c }
            // n = 7, score = 100
            //   6689442416           | mov                 word ptr [esp + 0x16], ax
            //   33c9                 | xor                 ecx, ecx
            //   668954241a           | mov                 word ptr [esp + 0x1a], dx
            //   8d442434             | lea                 eax, [esp + 0x34]
            //   50                   | push                eax
            //   66894c241c           | mov                 word ptr [esp + 0x1c], cx
            //   8b4c241c             | mov                 ecx, dword ptr [esp + 0x1c]

        $sequence_9 = { 899c24ac000000 3bfb 7449 8b8424b8000000 56 8d742418 }
            // n = 6, score = 100
            //   899c24ac000000       | mov                 dword ptr [esp + 0xac], ebx
            //   3bfb                 | cmp                 edi, ebx
            //   7449                 | je                  0x4b
            //   8b8424b8000000       | mov                 eax, dword ptr [esp + 0xb8]
            //   56                   | push                esi
            //   8d742418             | lea                 esi, [esp + 0x18]

    condition:
        7 of them and filesize < 10838016
}