rule win_9002_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.9002."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.9002"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 2d00040000 f7d8 1bc0 23c2 }
            // n = 4, score = 300
            //   2d00040000           | sub                 eax, 0x400
            //   f7d8                 | neg                 eax
            //   1bc0                 | sbb                 eax, eax
            //   23c2                 | and                 eax, edx

        $sequence_1 = { 68???????? ff15???????? 6a0a ff15???????? e9???????? }
            // n = 5, score = 200
            //   68????????           |                     
            //   ff15????????         |                     
            //   6a0a                 | push                0xa
            //   ff15????????         |                     
            //   e9????????           |                     

        $sequence_2 = { 89bef8030000 ff15???????? 8986fc030000 ff15???????? 898600040000 }
            // n = 5, score = 200
            //   89bef8030000         | mov                 dword ptr [esi + 0x3f8], edi
            //   ff15????????         |                     
            //   8986fc030000         | mov                 dword ptr [esi + 0x3fc], eax
            //   ff15????????         |                     
            //   898600040000         | mov                 dword ptr [esi + 0x400], eax

        $sequence_3 = { 83c0fc 50 53 e8???????? }
            // n = 4, score = 200
            //   83c0fc               | add                 eax, -4
            //   50                   | push                eax
            //   53                   | push                ebx
            //   e8????????           |                     

        $sequence_4 = { 03c3 8b00 5b ffd0 }
            // n = 4, score = 200
            //   03c3                 | add                 eax, ebx
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   5b                   | pop                 ebx
            //   ffd0                 | call                eax

        $sequence_5 = { 6a02 83c144 6800000040 51 }
            // n = 4, score = 200
            //   6a02                 | push                2
            //   83c144               | add                 ecx, 0x44
            //   6800000040           | push                0x40000000
            //   51                   | push                ecx

        $sequence_6 = { 8bc1 33c9 894808 894810 8910 c7400c01000000 }
            // n = 6, score = 200
            //   8bc1                 | mov                 eax, ecx
            //   33c9                 | xor                 ecx, ecx
            //   894808               | mov                 dword ptr [eax + 8], ecx
            //   894810               | mov                 dword ptr [eax + 0x10], ecx
            //   8910                 | mov                 dword ptr [eax], edx
            //   c7400c01000000       | mov                 dword ptr [eax + 0xc], 1

        $sequence_7 = { 57 8bf1 50 6801020000 c706???????? e8???????? 8d4604 }
            // n = 7, score = 200
            //   57                   | push                edi
            //   8bf1                 | mov                 esi, ecx
            //   50                   | push                eax
            //   6801020000           | push                0x201
            //   c706????????         |                     
            //   e8????????           |                     
            //   8d4604               | lea                 eax, [esi + 4]

        $sequence_8 = { 2bd0 3bfa 760d 85c0 7504 }
            // n = 5, score = 200
            //   2bd0                 | sub                 edx, eax
            //   3bfa                 | cmp                 edi, edx
            //   760d                 | jbe                 0xf
            //   85c0                 | test                eax, eax
            //   7504                 | jne                 6

        $sequence_9 = { 6a02 ff15???????? 68???????? ff15???????? 6a00 6a00 6a00 }
            // n = 7, score = 200
            //   6a02                 | push                2
            //   ff15????????         |                     
            //   68????????           |                     
            //   ff15????????         |                     
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_10 = { 0ac8 80c910 880e 8ac2 }
            // n = 4, score = 200
            //   0ac8                 | or                  cl, al
            //   80c910               | or                  cl, 0x10
            //   880e                 | mov                 byte ptr [esi], cl
            //   8ac2                 | mov                 al, dl

        $sequence_11 = { 6a02 6a03 6a00 e8???????? }
            // n = 4, score = 200
            //   6a02                 | push                2
            //   6a03                 | push                3
            //   6a00                 | push                0
            //   e8????????           |                     

        $sequence_12 = { 8b5c2408 6bdb08 03c3 8b00 }
            // n = 4, score = 200
            //   8b5c2408             | mov                 ebx, dword ptr [esp + 8]
            //   6bdb08               | imul                ebx, ebx, 8
            //   03c3                 | add                 eax, ebx
            //   8b00                 | mov                 eax, dword ptr [eax]

        $sequence_13 = { 33c9 3bc8 1bd2 f7da 8915???????? }
            // n = 5, score = 200
            //   33c9                 | xor                 ecx, ecx
            //   3bc8                 | cmp                 ecx, eax
            //   1bd2                 | sbb                 edx, edx
            //   f7da                 | neg                 edx
            //   8915????????         |                     

        $sequence_14 = { 682c010000 50 ffd3 3d02010000 }
            // n = 4, score = 200
            //   682c010000           | push                0x12c
            //   50                   | push                eax
            //   ffd3                 | call                ebx
            //   3d02010000           | cmp                 eax, 0x102

        $sequence_15 = { 51 e8???????? 6a06 6a01 6a02 e8???????? }
            // n = 6, score = 200
            //   51                   | push                ecx
            //   e8????????           |                     
            //   6a06                 | push                6
            //   6a01                 | push                1
            //   6a02                 | push                2
            //   e8????????           |                     

        $sequence_16 = { 8b08 51 e8???????? 8b5714 }
            // n = 4, score = 200
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   51                   | push                ecx
            //   e8????????           |                     
            //   8b5714               | mov                 edx, dword ptr [edi + 0x14]

        $sequence_17 = { 8b460c 40 33d2 f77614 ff4610 }
            // n = 5, score = 200
            //   8b460c               | mov                 eax, dword ptr [esi + 0xc]
            //   40                   | inc                 eax
            //   33d2                 | xor                 edx, edx
            //   f77614               | div                 dword ptr [esi + 0x14]
            //   ff4610               | inc                 dword ptr [esi + 0x10]

        $sequence_18 = { e8???????? 50 e8???????? 6a08 e8???????? }
            // n = 5, score = 200
            //   e8????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   6a08                 | push                8
            //   e8????????           |                     

        $sequence_19 = { 46 c1ea06 8816 46 }
            // n = 4, score = 200
            //   46                   | inc                 esi
            //   c1ea06               | shr                 edx, 6
            //   8816                 | mov                 byte ptr [esi], dl
            //   46                   | inc                 esi

        $sequence_20 = { 56 89442418 ff15???????? a820 }
            // n = 4, score = 200
            //   56                   | push                esi
            //   89442418             | mov                 dword ptr [esp + 0x18], eax
            //   ff15????????         |                     
            //   a820                 | test                al, 0x20

        $sequence_21 = { 8b01 ff5010 8b7614 ff4e0c }
            // n = 4, score = 200
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   ff5010               | call                dword ptr [eax + 0x10]
            //   8b7614               | mov                 esi, dword ptr [esi + 0x14]
            //   ff4e0c               | dec                 dword ptr [esi + 0xc]

        $sequence_22 = { c7422c00000200 8b4648 c7402801000000 8b4648 }
            // n = 4, score = 100
            //   c7422c00000200       | mov                 dword ptr [edx + 0x2c], 0x20000
            //   8b4648               | mov                 eax, dword ptr [esi + 0x48]
            //   c7402801000000       | mov                 dword ptr [eax + 0x28], 1
            //   8b4648               | mov                 eax, dword ptr [esi + 0x48]

        $sequence_23 = { 742e 85f6 7419 0fb6da f683c1d4001004 7406 8816 }
            // n = 7, score = 100
            //   742e                 | je                  0x30
            //   85f6                 | test                esi, esi
            //   7419                 | je                  0x1b
            //   0fb6da               | movzx               ebx, dl
            //   f683c1d4001004       | test                byte ptr [ebx + 0x1000d4c1], 4
            //   7406                 | je                  8
            //   8816                 | mov                 byte ptr [esi], dl

        $sequence_24 = { 7622 8b4558 83f805 7316 8a0b }
            // n = 5, score = 100
            //   7622                 | jbe                 0x24
            //   8b4558               | mov                 eax, dword ptr [ebp + 0x58]
            //   83f805               | cmp                 eax, 5
            //   7316                 | jae                 0x18
            //   8a0b                 | mov                 cl, byte ptr [ebx]

        $sequence_25 = { 8b7c240c 57 8bf1 e8???????? 33d2 }
            // n = 5, score = 100
            //   8b7c240c             | mov                 edi, dword ptr [esp + 0xc]
            //   57                   | push                edi
            //   8bf1                 | mov                 esi, ecx
            //   e8????????           |                     
            //   33d2                 | xor                 edx, edx

        $sequence_26 = { 894608 ff15???????? 8d4c2414 885c243c ff15???????? 8bc6 8b4c2434 }
            // n = 7, score = 100
            //   894608               | mov                 dword ptr [esi + 8], eax
            //   ff15????????         |                     
            //   8d4c2414             | lea                 ecx, [esp + 0x14]
            //   885c243c             | mov                 byte ptr [esp + 0x3c], bl
            //   ff15????????         |                     
            //   8bc6                 | mov                 eax, esi
            //   8b4c2434             | mov                 ecx, dword ptr [esp + 0x34]

        $sequence_27 = { 8b4648 689a000000 6a00 50 }
            // n = 4, score = 100
            //   8b4648               | mov                 eax, dword ptr [esi + 0x48]
            //   689a000000           | push                0x9a
            //   6a00                 | push                0
            //   50                   | push                eax

        $sequence_28 = { 8d4c240c 8d542418 6a05 8944241c 51 }
            // n = 5, score = 100
            //   8d4c240c             | lea                 ecx, [esp + 0xc]
            //   8d542418             | lea                 edx, [esp + 0x18]
            //   6a05                 | push                5
            //   8944241c             | mov                 dword ptr [esp + 0x1c], eax
            //   51                   | push                ecx

        $sequence_29 = { 8bf1 8b4610 57 33ff 897e08 }
            // n = 5, score = 100
            //   8bf1                 | mov                 esi, ecx
            //   8b4610               | mov                 eax, dword ptr [esi + 0x10]
            //   57                   | push                edi
            //   33ff                 | xor                 edi, edi
            //   897e08               | mov                 dword ptr [esi + 8], edi

        $sequence_30 = { 8bf8 6a40 6800100000 57 6a00 ff15???????? 8d4df8 }
            // n = 7, score = 100
            //   8bf8                 | mov                 edi, eax
            //   6a40                 | push                0x40
            //   6800100000           | push                0x1000
            //   57                   | push                edi
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   8d4df8               | lea                 ecx, [ebp - 8]

        $sequence_31 = { c3 b8???????? c705????????772b0010 a3???????? }
            // n = 4, score = 100
            //   c3                   | ret                 
            //   b8????????           |                     
            //   c705????????772b0010     |     
            //   a3????????           |                     

        $sequence_32 = { ff15???????? 8bf8 85ff 7529 ff15???????? 8b560c 52 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   8bf8                 | mov                 edi, eax
            //   85ff                 | test                edi, edi
            //   7529                 | jne                 0x2b
            //   ff15????????         |                     
            //   8b560c               | mov                 edx, dword ptr [esi + 0xc]
            //   52                   | push                edx

        $sequence_33 = { 8b5c247c 55 56 8bb4248c000000 57 8b3b 8b2e }
            // n = 7, score = 100
            //   8b5c247c             | mov                 ebx, dword ptr [esp + 0x7c]
            //   55                   | push                ebp
            //   56                   | push                esi
            //   8bb4248c000000       | mov                 esi, dword ptr [esp + 0x8c]
            //   57                   | push                edi
            //   8b3b                 | mov                 edi, dword ptr [ebx]
            //   8b2e                 | mov                 ebp, dword ptr [esi]

        $sequence_34 = { 52 ffd5 c7460c00000000 8b460c }
            // n = 4, score = 100
            //   52                   | push                edx
            //   ffd5                 | call                ebp
            //   c7460c00000000       | mov                 dword ptr [esi + 0xc], 0
            //   8b460c               | mov                 eax, dword ptr [esi + 0xc]

        $sequence_35 = { 6689bc5a80010000 83c30c 895c2424 e9???????? }
            // n = 4, score = 100
            //   6689bc5a80010000     | mov                 word ptr [edx + ebx*2 + 0x180], di
            //   83c30c               | add                 ebx, 0xc
            //   895c2424             | mov                 dword ptr [esp + 0x24], ebx
            //   e9????????           |                     

        $sequence_36 = { 8b4e04 83c108 33f6 668931 66897102 89510c }
            // n = 6, score = 100
            //   8b4e04               | mov                 ecx, dword ptr [esi + 4]
            //   83c108               | add                 ecx, 8
            //   33f6                 | xor                 esi, esi
            //   668931               | mov                 word ptr [ecx], si
            //   66897102             | mov                 word ptr [ecx + 2], si
            //   89510c               | mov                 dword ptr [ecx + 0xc], edx

        $sequence_37 = { ff15???????? 8bf8 6a40 6800100000 }
            // n = 4, score = 100
            //   ff15????????         |                     
            //   8bf8                 | mov                 edi, eax
            //   6a40                 | push                0x40
            //   6800100000           | push                0x1000

    condition:
        7 of them and filesize < 204800
}