rule win_abaddon_pos_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.abaddon_pos."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.abaddon_pos"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 750a 83fb3c 7605 e9???????? }
            // n = 4, score = 200
            //   750a                 | jne                 0xc
            //   83fb3c               | cmp                 ebx, 0x3c
            //   7605                 | jbe                 7
            //   e9????????           |                     

        $sequence_1 = { 7605 e9???????? 48 034510 48 0500040000 803800 }
            // n = 7, score = 100
            //   7605                 | jbe                 7
            //   e9????????           |                     
            //   48                   | dec                 eax
            //   034510               | add                 eax, dword ptr [ebp + 0x10]
            //   48                   | dec                 eax
            //   0500040000           | add                 eax, 0x400
            //   803800               | cmp                 byte ptr [eax], 0

        $sequence_2 = { 43 8b86ac010000 b400 b20a f6f2 80fc00 7406 }
            // n = 7, score = 100
            //   43                   | inc                 ebx
            //   8b86ac010000         | mov                 eax, dword ptr [esi + 0x1ac]
            //   b400                 | mov                 ah, 0
            //   b20a                 | mov                 dl, 0xa
            //   f6f2                 | div                 dl
            //   80fc00               | cmp                 ah, 0
            //   7406                 | je                  8

        $sequence_3 = { 8945fc 83f800 7502 eb86 6800d00700 ff75ec }
            // n = 6, score = 100
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   83f800               | cmp                 eax, 0
            //   7502                 | jne                 4
            //   eb86                 | jmp                 0xffffff88
            //   6800d00700           | push                0x7d000
            //   ff75ec               | push                dword ptr [ebp - 0x14]

        $sequence_4 = { eb91 81be0c01000080cf0700 7607 bb80cf0700 eb06 8b9e0c010000 }
            // n = 6, score = 100
            //   eb91                 | jmp                 0xffffff93
            //   81be0c01000080cf0700     | cmp    dword ptr [esi + 0x10c], 0x7cf80
            //   7607                 | jbe                 9
            //   bb80cf0700           | mov                 ebx, 0x7cf80
            //   eb06                 | jmp                 8
            //   8b9e0c010000         | mov                 ebx, dword ptr [esi + 0x10c]

        $sequence_5 = { 48 89c7 48 8d86b8010000 48 }
            // n = 5, score = 100
            //   48                   | dec                 eax
            //   89c7                 | mov                 edi, eax
            //   48                   | dec                 eax
            //   8d86b8010000         | lea                 eax, [esi + 0x1b8]
            //   48                   | dec                 eax

        $sequence_6 = { 6a00 6a02 ff15???????? 8945e8 8d95c0feffff 52 }
            // n = 6, score = 100
            //   6a00                 | push                0
            //   6a02                 | push                2
            //   ff15????????         |                     
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax
            //   8d95c0feffff         | lea                 edx, [ebp - 0x140]
            //   52                   | push                edx

        $sequence_7 = { 81c3f8030000 8903 48 31db 48 8b96d0050000 }
            // n = 6, score = 100
            //   81c3f8030000         | add                 ebx, 0x3f8
            //   8903                 | mov                 dword ptr [ebx], eax
            //   48                   | dec                 eax
            //   31db                 | xor                 ebx, ebx
            //   48                   | dec                 eax
            //   8b96d0050000         | mov                 edx, dword ptr [esi + 0x5d0]

        $sequence_8 = { 31c0 48 31d2 8a841eb8010000 }
            // n = 4, score = 100
            //   31c0                 | xor                 eax, eax
            //   48                   | dec                 eax
            //   31d2                 | xor                 edx, edx
            //   8a841eb8010000       | mov                 al, byte ptr [esi + ebx + 0x1b8]

        $sequence_9 = { ff15???????? 8b86a0010000 3b86a4010000 0f83e6030000 8b9e94010000 039ea0010000 803b33 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   8b86a0010000         | mov                 eax, dword ptr [esi + 0x1a0]
            //   3b86a4010000         | cmp                 eax, dword ptr [esi + 0x1a4]
            //   0f83e6030000         | jae                 0x3ec
            //   8b9e94010000         | mov                 ebx, dword ptr [esi + 0x194]
            //   039ea0010000         | add                 ebx, dword ptr [esi + 0x1a0]
            //   803b33               | cmp                 byte ptr [ebx], 0x33

        $sequence_10 = { 83f809 7603 83e809 ba00000000 eb05 ba01000000 0186ac010000 }
            // n = 7, score = 100
            //   83f809               | cmp                 eax, 9
            //   7603                 | jbe                 5
            //   83e809               | sub                 eax, 9
            //   ba00000000           | mov                 edx, 0
            //   eb05                 | jmp                 7
            //   ba01000000           | mov                 edx, 1
            //   0186ac010000         | add                 dword ptr [esi + 0x1ac], eax

        $sequence_11 = { 80fd3e 7406 41 80fd3f 756e 49 }
            // n = 6, score = 100
            //   80fd3e               | cmp                 ch, 0x3e
            //   7406                 | je                  8
            //   41                   | inc                 ecx
            //   80fd3f               | cmp                 ch, 0x3f
            //   756e                 | jne                 0x70
            //   49                   | dec                 ecx

        $sequence_12 = { 89e5 48 83ec20 48 c7c100000000 }
            // n = 5, score = 100
            //   89e5                 | mov                 ebp, esp
            //   48                   | dec                 eax
            //   83ec20               | sub                 esp, 0x20
            //   48                   | dec                 eax
            //   c7c100000000         | mov                 ecx, 0

        $sequence_13 = { 2c30 80ea30 666bc00a 48 01d0 48 89da }
            // n = 7, score = 100
            //   2c30                 | sub                 al, 0x30
            //   80ea30               | sub                 dl, 0x30
            //   666bc00a             | imul                ax, ax, 0xa
            //   48                   | dec                 eax
            //   01d0                 | add                 eax, edx
            //   48                   | dec                 eax
            //   89da                 | mov                 edx, ebx

        $sequence_14 = { 52 ffb558feffff ff15???????? 8d9530fdffff 52 }
            // n = 5, score = 100
            //   52                   | push                edx
            //   ffb558feffff         | push                dword ptr [ebp - 0x1a8]
            //   ff15????????         |                     
            //   8d9530fdffff         | lea                 edx, [ebp - 0x2d0]
            //   52                   | push                edx

    condition:
        7 of them and filesize < 40960
}