rule win_acbackdoor_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.acbackdoor."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.acbackdoor"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 85c0 0f8524020000 83fd04 0f8326020000 85ed 0f853c020000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   0f8524020000         | jne                 0x22a
            //   83fd04               | cmp                 ebp, 4
            //   0f8326020000         | jae                 0x22c
            //   85ed                 | test                ebp, ebp
            //   0f853c020000         | jne                 0x242

        $sequence_1 = { e8???????? c70424???????? ff15???????? 894500 85c0 7488 803e2f }
            // n = 7, score = 100
            //   e8????????           |                     
            //   c70424????????       |                     
            //   ff15????????         |                     
            //   894500               | mov                 dword ptr [ebp], eax
            //   85c0                 | test                eax, eax
            //   7488                 | je                  0xffffff8a
            //   803e2f               | cmp                 byte ptr [esi], 0x2f

        $sequence_2 = { e8???????? 8b83f0010000 05b8030000 890424 e8???????? 8b83f0010000 89442420 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b83f0010000         | mov                 eax, dword ptr [ebx + 0x1f0]
            //   05b8030000           | add                 eax, 0x3b8
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     
            //   8b83f0010000         | mov                 eax, dword ptr [ebx + 0x1f0]
            //   89442420             | mov                 dword ptr [esp + 0x20], eax

        $sequence_3 = { e8???????? 803f04 89c5 7567 8d440001 39c6 7555 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   803f04               | cmp                 byte ptr [edi], 4
            //   89c5                 | mov                 ebp, eax
            //   7567                 | jne                 0x69
            //   8d440001             | lea                 eax, [eax + eax + 1]
            //   39c6                 | cmp                 esi, eax
            //   7555                 | jne                 0x57

        $sequence_4 = { e9???????? 8b6c2448 8b9c24c0000000 8b83f4000000 85c0 0f85d8020000 8b03 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   8b6c2448             | mov                 ebp, dword ptr [esp + 0x48]
            //   8b9c24c0000000       | mov                 ebx, dword ptr [esp + 0xc0]
            //   8b83f4000000         | mov                 eax, dword ptr [ebx + 0xf4]
            //   85c0                 | test                eax, eax
            //   0f85d8020000         | jne                 0x2de
            //   8b03                 | mov                 eax, dword ptr [ebx]

        $sequence_5 = { c783b008000000000000 c7838c05000001000000 c7839005000001000000 c7839405000005000000 895c2404 890424 e8???????? }
            // n = 7, score = 100
            //   c783b008000000000000     | mov    dword ptr [ebx + 0x8b0], 0
            //   c7838c05000001000000     | mov    dword ptr [ebx + 0x58c], 1
            //   c7839005000001000000     | mov    dword ptr [ebx + 0x590], 1
            //   c7839405000005000000     | mov    dword ptr [ebx + 0x594], 5
            //   895c2404             | mov                 dword ptr [esp + 4], ebx
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     

        $sequence_6 = { 8d57fe 0fb7c0 39d0 0f85bc050000 8d4306 8d342b 89442458 }
            // n = 7, score = 100
            //   8d57fe               | lea                 edx, [edi - 2]
            //   0fb7c0               | movzx               eax, ax
            //   39d0                 | cmp                 eax, edx
            //   0f85bc050000         | jne                 0x5c2
            //   8d4306               | lea                 eax, [ebx + 6]
            //   8d342b               | lea                 esi, [ebx + ebp]
            //   89442458             | mov                 dword ptr [esp + 0x58], eax

        $sequence_7 = { c7442408???????? c7442404???????? 890424 e8???????? 84c0 0f8519050000 8b83e4000000 }
            // n = 7, score = 100
            //   c7442408????????     |                     
            //   c7442404????????     |                     
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   0f8519050000         | jne                 0x51f
            //   8b83e4000000         | mov                 eax, dword ptr [ebx + 0xe4]

        $sequence_8 = { ffd0 85c0 0f8863010000 39c5 0f865b010000 29c5 01c7 }
            // n = 7, score = 100
            //   ffd0                 | call                eax
            //   85c0                 | test                eax, eax
            //   0f8863010000         | js                  0x169
            //   39c5                 | cmp                 ebp, eax
            //   0f865b010000         | jbe                 0x161
            //   29c5                 | sub                 ebp, eax
            //   01c7                 | add                 edi, eax

        $sequence_9 = { c744242005000000 e9???????? 83c803 8906 8b4304 89442410 85c0 }
            // n = 7, score = 100
            //   c744242005000000     | mov                 dword ptr [esp + 0x20], 5
            //   e9????????           |                     
            //   83c803               | or                  eax, 3
            //   8906                 | mov                 dword ptr [esi], eax
            //   8b4304               | mov                 eax, dword ptr [ebx + 4]
            //   89442410             | mov                 dword ptr [esp + 0x10], eax
            //   85c0                 | test                eax, eax

    condition:
        7 of them and filesize < 1704960
}