rule win_acr_stealer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.acr_stealer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.acr_stealer"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b7008 8bce 6a00 ff15???????? 8bcf ffd6 5f }
            // n = 7, score = 200
            //   8b7008               | mov                 esi, dword ptr [eax + 8]
            //   8bce                 | mov                 ecx, esi
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   8bcf                 | mov                 ecx, edi
            //   ffd6                 | call                esi
            //   5f                   | pop                 edi

        $sequence_1 = { 6a0b 68???????? eb07 6a04 68???????? 8b3f 8b07 }
            // n = 7, score = 200
            //   6a0b                 | push                0xb
            //   68????????           |                     
            //   eb07                 | jmp                 9
            //   6a04                 | push                4
            //   68????????           |                     
            //   8b3f                 | mov                 edi, dword ptr [edi]
            //   8b07                 | mov                 eax, dword ptr [edi]

        $sequence_2 = { 72fa 53 ff30 8b45f8 ff37 8b7030 }
            // n = 6, score = 200
            //   72fa                 | jb                  0xfffffffc
            //   53                   | push                ebx
            //   ff30                 | push                dword ptr [eax]
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   ff37                 | push                dword ptr [edi]
            //   8b7030               | mov                 esi, dword ptr [eax + 0x30]

        $sequence_3 = { e8???????? 8bf2 33c9 c1ee0f 33f0 33ca }
            // n = 6, score = 200
            //   e8????????           |                     
            //   8bf2                 | mov                 esi, edx
            //   33c9                 | xor                 ecx, ecx
            //   c1ee0f               | shr                 esi, 0xf
            //   33f0                 | xor                 esi, eax
            //   33ca                 | xor                 ecx, edx

        $sequence_4 = { 8955f4 ff7407f8 e8???????? 8bfe 8955f0 83c410 }
            // n = 6, score = 200
            //   8955f4               | mov                 dword ptr [ebp - 0xc], edx
            //   ff7407f8             | push                dword ptr [edi + eax - 8]
            //   e8????????           |                     
            //   8bfe                 | mov                 edi, esi
            //   8955f0               | mov                 dword ptr [ebp - 0x10], edx
            //   83c410               | add                 esp, 0x10

        $sequence_5 = { ff7034 ff15???????? ffd6 83c410 85c0 0f8490000000 8b4ddc }
            // n = 7, score = 200
            //   ff7034               | push                dword ptr [eax + 0x34]
            //   ff15????????         |                     
            //   ffd6                 | call                esi
            //   83c410               | add                 esp, 0x10
            //   85c0                 | test                eax, eax
            //   0f8490000000         | je                  0x96
            //   8b4ddc               | mov                 ecx, dword ptr [ebp - 0x24]

        $sequence_6 = { 894e44 83f908 73da 8b95b4feffff 3bd7 0f821affffff 8b4dfc }
            // n = 7, score = 200
            //   894e44               | mov                 dword ptr [esi + 0x44], ecx
            //   83f908               | cmp                 ecx, 8
            //   73da                 | jae                 0xffffffdc
            //   8b95b4feffff         | mov                 edx, dword ptr [ebp - 0x14c]
            //   3bd7                 | cmp                 edx, edi
            //   0f821affffff         | jb                  0xffffff20
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]

        $sequence_7 = { 397df4 7508 3bc1 0f8411ffffff 85c9 7403 49 }
            // n = 7, score = 200
            //   397df4               | cmp                 dword ptr [ebp - 0xc], edi
            //   7508                 | jne                 0xa
            //   3bc1                 | cmp                 eax, ecx
            //   0f8411ffffff         | je                  0xffffff17
            //   85c9                 | test                ecx, ecx
            //   7403                 | je                  5
            //   49                   | dec                 ecx

        $sequence_8 = { 8955f4 85c0 7406 c70000000000 85db 0f8420010000 33c0 }
            // n = 7, score = 200
            //   8955f4               | mov                 dword ptr [ebp - 0xc], edx
            //   85c0                 | test                eax, eax
            //   7406                 | je                  8
            //   c70000000000         | mov                 dword ptr [eax], 0
            //   85db                 | test                ebx, ebx
            //   0f8420010000         | je                  0x126
            //   33c0                 | xor                 eax, eax

        $sequence_9 = { 85db 7469 83fb03 7329 66019e12860000 0f1f440000 8bc7 }
            // n = 7, score = 200
            //   85db                 | test                ebx, ebx
            //   7469                 | je                  0x6b
            //   83fb03               | cmp                 ebx, 3
            //   7329                 | jae                 0x2b
            //   66019e12860000       | add                 word ptr [esi + 0x8612], bx
            //   0f1f440000           | nop                 dword ptr [eax + eax]
            //   8bc7                 | mov                 eax, edi

    condition:
        7 of them and filesize < 1246208
}