rule win_acridrain_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.acridrain."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.acridrain"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff8ea0000000 8bf8 897df0 83ff64 741e 83bb8400000000 7c15 }
            // n = 7, score = 200
            //   ff8ea0000000         | dec                 dword ptr [esi + 0xa0]
            //   8bf8                 | mov                 edi, eax
            //   897df0               | mov                 dword ptr [ebp - 0x10], edi
            //   83ff64               | cmp                 edi, 0x64
            //   741e                 | je                  0x20
            //   83bb8400000000       | cmp                 dword ptr [ebx + 0x84], 0
            //   7c15                 | jl                  0x17

        $sequence_1 = { ff7048 e8???????? 83c404 85f6 0f85c4000000 8b4dec 8bc7 }
            // n = 7, score = 200
            //   ff7048               | push                dword ptr [eax + 0x48]
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   85f6                 | test                esi, esi
            //   0f85c4000000         | jne                 0xca
            //   8b4dec               | mov                 ecx, dword ptr [ebp - 0x14]
            //   8bc7                 | mov                 eax, edi

        $sequence_2 = { f6401604 57 8b7a38 7414 8b45f0 51 03c7 }
            // n = 7, score = 200
            //   f6401604             | test                byte ptr [eax + 0x16], 4
            //   57                   | push                edi
            //   8b7a38               | mov                 edi, dword ptr [edx + 0x38]
            //   7414                 | je                  0x16
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   51                   | push                ecx
            //   03c7                 | add                 eax, edi

        $sequence_3 = { f20f5945d4 f20f5905???????? e9???????? 81fe56010000 7c2a 8bcf e8???????? }
            // n = 7, score = 200
            //   f20f5945d4           | mulsd               xmm0, qword ptr [ebp - 0x2c]
            //   f20f5905????????     |                     
            //   e9????????           |                     
            //   81fe56010000         | cmp                 esi, 0x156
            //   7c2a                 | jl                  0x2c
            //   8bcf                 | mov                 ecx, edi
            //   e8????????           |                     

        $sequence_4 = { e8???????? 33c9 0fb6db 83c408 84c0 0f45d9 895c2414 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   33c9                 | xor                 ecx, ecx
            //   0fb6db               | movzx               ebx, bl
            //   83c408               | add                 esp, 8
            //   84c0                 | test                al, al
            //   0f45d9               | cmovne              ebx, ecx
            //   895c2414             | mov                 dword ptr [esp + 0x14], ebx

        $sequence_5 = { 8b4e08 3bcb 740d 40 83c654 3bc2 72f1 }
            // n = 7, score = 200
            //   8b4e08               | mov                 ecx, dword ptr [esi + 8]
            //   3bcb                 | cmp                 ecx, ebx
            //   740d                 | je                  0xf
            //   40                   | inc                 eax
            //   83c654               | add                 esi, 0x54
            //   3bc2                 | cmp                 eax, edx
            //   72f1                 | jb                  0xfffffff3

        $sequence_6 = { ff7548 68???????? 55 e8???????? 83c40c 85c0 0f85b8010000 }
            // n = 7, score = 200
            //   ff7548               | push                dword ptr [ebp + 0x48]
            //   68????????           |                     
            //   55                   | push                ebp
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   85c0                 | test                eax, eax
            //   0f85b8010000         | jne                 0x1be

        $sequence_7 = { 8b7d08 8b472c 85c0 0f84a6000000 53 8b5d0c 56 }
            // n = 7, score = 200
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   8b472c               | mov                 eax, dword ptr [edi + 0x2c]
            //   85c0                 | test                eax, eax
            //   0f84a6000000         | je                  0xac
            //   53                   | push                ebx
            //   8b5d0c               | mov                 ebx, dword ptr [ebp + 0xc]
            //   56                   | push                esi

        $sequence_8 = { ff75f4 ff750c 57 e8???????? 83c418 85c0 0f84b3feffff }
            // n = 7, score = 200
            //   ff75f4               | push                dword ptr [ebp - 0xc]
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   57                   | push                edi
            //   e8????????           |                     
            //   83c418               | add                 esp, 0x18
            //   85c0                 | test                eax, eax
            //   0f84b3feffff         | je                  0xfffffeb9

        $sequence_9 = { e8???????? ff75cc 57 53 e8???????? 8b55b8 52 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   ff75cc               | push                dword ptr [ebp - 0x34]
            //   57                   | push                edi
            //   53                   | push                ebx
            //   e8????????           |                     
            //   8b55b8               | mov                 edx, dword ptr [ebp - 0x48]
            //   52                   | push                edx

    condition:
        7 of them and filesize < 2244608
}