rule win_acronym_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.acronym."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.acronym"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 894c05d0 ba04000000 6bd200 8b45ec 894415b4 b904000000 c1e100 }
            // n = 7, score = 200
            //   894c05d0             | mov                 dword ptr [ebp + eax - 0x30], ecx
            //   ba04000000           | mov                 edx, 4
            //   6bd200               | imul                edx, edx, 0
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   894415b4             | mov                 dword ptr [ebp + edx - 0x4c], eax
            //   b904000000           | mov                 ecx, 4
            //   c1e100               | shl                 ecx, 0

        $sequence_1 = { 0fb6c8 85c9 0f84d4000000 8b550c 8955d8 8b4510 50 }
            // n = 7, score = 200
            //   0fb6c8               | movzx               ecx, al
            //   85c9                 | test                ecx, ecx
            //   0f84d4000000         | je                  0xda
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]
            //   8955d8               | mov                 dword ptr [ebp - 0x28], edx
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   50                   | push                eax

        $sequence_2 = { 50 8b85e8fdffff 8b08 8b95e8fdffff 52 8b413c }
            // n = 6, score = 200
            //   50                   | push                eax
            //   8b85e8fdffff         | mov                 eax, dword ptr [ebp - 0x218]
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   8b95e8fdffff         | mov                 edx, dword ptr [ebp - 0x218]
            //   52                   | push                edx
            //   8b413c               | mov                 eax, dword ptr [ecx + 0x3c]

        $sequence_3 = { 0fb6c8 85c9 753d 8d4dd8 e8???????? 50 }
            // n = 6, score = 200
            //   0fb6c8               | movzx               ecx, al
            //   85c9                 | test                ecx, ecx
            //   753d                 | jne                 0x3f
            //   8d4dd8               | lea                 ecx, [ebp - 0x28]
            //   e8????????           |                     
            //   50                   | push                eax

        $sequence_4 = { 83f832 0f8547170000 c745e400000000 8b4de4 894de8 8b55e8 8955e0 }
            // n = 7, score = 200
            //   83f832               | cmp                 eax, 0x32
            //   0f8547170000         | jne                 0x174d
            //   c745e400000000       | mov                 dword ptr [ebp - 0x1c], 0
            //   8b4de4               | mov                 ecx, dword ptr [ebp - 0x1c]
            //   894de8               | mov                 dword ptr [ebp - 0x18], ecx
            //   8b55e8               | mov                 edx, dword ptr [ebp - 0x18]
            //   8955e0               | mov                 dword ptr [ebp - 0x20], edx

        $sequence_5 = { 668b544144 668955fc 0fb745fc c1e004 8b4d08 8d940190c90000 b804000000 }
            // n = 7, score = 200
            //   668b544144           | mov                 dx, word ptr [ecx + eax*2 + 0x44]
            //   668955fc             | mov                 word ptr [ebp - 4], dx
            //   0fb745fc             | movzx               eax, word ptr [ebp - 4]
            //   c1e004               | shl                 eax, 4
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   8d940190c90000       | lea                 edx, [ecx + eax + 0xc990]
            //   b804000000           | mov                 eax, 4

        $sequence_6 = { e8???????? 83c404 89853cfeffff 8d4ddc 898d84feffff 8b9584feffff 899540fdffff }
            // n = 7, score = 200
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   89853cfeffff         | mov                 dword ptr [ebp - 0x1c4], eax
            //   8d4ddc               | lea                 ecx, [ebp - 0x24]
            //   898d84feffff         | mov                 dword ptr [ebp - 0x17c], ecx
            //   8b9584feffff         | mov                 edx, dword ptr [ebp - 0x17c]
            //   899540fdffff         | mov                 dword ptr [ebp - 0x2c0], edx

        $sequence_7 = { 8b4df0 668b544112 668955fc 0fb745fc c1e004 8b4d08 8d940190c90000 }
            // n = 7, score = 200
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   668b544112           | mov                 dx, word ptr [ecx + eax*2 + 0x12]
            //   668955fc             | mov                 word ptr [ebp - 4], dx
            //   0fb745fc             | movzx               eax, word ptr [ebp - 4]
            //   c1e004               | shl                 eax, 4
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   8d940190c90000       | lea                 edx, [ecx + eax + 0xc990]

        $sequence_8 = { 8d95f4fdffff 52 8d8d50fdffff e8???????? 8bc8 e8???????? 50 }
            // n = 7, score = 200
            //   8d95f4fdffff         | lea                 edx, [ebp - 0x20c]
            //   52                   | push                edx
            //   8d8d50fdffff         | lea                 ecx, [ebp - 0x2b0]
            //   e8????????           |                     
            //   8bc8                 | mov                 ecx, eax
            //   e8????????           |                     
            //   50                   | push                eax

        $sequence_9 = { 52 8b450c 50 8b8d0cffffff 51 e8???????? }
            // n = 6, score = 200
            //   52                   | push                edx
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   50                   | push                eax
            //   8b8d0cffffff         | mov                 ecx, dword ptr [ebp - 0xf4]
            //   51                   | push                ecx
            //   e8????????           |                     

    condition:
        7 of them and filesize < 466944
}