rule win_adhubllka_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.adhubllka."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.adhubllka"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b45c8 894590 8b45c4 894598 8b45c0 898560ffffff }
            // n = 6, score = 500
            //   8b45c8               | mov                 eax, dword ptr [ebp - 0x38]
            //   894590               | mov                 dword ptr [ebp - 0x70], eax
            //   8b45c4               | mov                 eax, dword ptr [ebp - 0x3c]
            //   894598               | mov                 dword ptr [ebp - 0x68], eax
            //   8b45c0               | mov                 eax, dword ptr [ebp - 0x40]
            //   898560ffffff         | mov                 dword ptr [ebp - 0xa0], eax

        $sequence_1 = { 03459c 8bc8 c1c307 334d94 c1c110 03f1 8bd6 }
            // n = 7, score = 500
            //   03459c               | add                 eax, dword ptr [ebp - 0x64]
            //   8bc8                 | mov                 ecx, eax
            //   c1c307               | rol                 ebx, 7
            //   334d94               | xor                 ecx, dword ptr [ebp - 0x6c]
            //   c1c110               | rol                 ecx, 0x10
            //   03f1                 | add                 esi, ecx
            //   8bd6                 | mov                 edx, esi

        $sequence_2 = { 33c9 25000f0000 c705????????01000000 3d000f0000 8b45d4 }
            // n = 5, score = 500
            //   33c9                 | xor                 ecx, ecx
            //   25000f0000           | and                 eax, 0xf00
            //   c705????????01000000     |     
            //   3d000f0000           | cmp                 eax, 0xf00
            //   8b45d4               | mov                 eax, dword ptr [ebp - 0x2c]

        $sequence_3 = { c78424a8000000787e4100 c78424ac000000807e4100 c78424b0000000887e4100 c78424b4000000907e4100 }
            // n = 4, score = 500
            //   c78424a8000000787e4100     | mov    dword ptr [esp + 0xa8], 0x417e78
            //   c78424ac000000807e4100     | mov    dword ptr [esp + 0xac], 0x417e80
            //   c78424b0000000887e4100     | mov    dword ptr [esp + 0xb0], 0x417e88
            //   c78424b4000000907e4100     | mov    dword ptr [esp + 0xb4], 0x417e90

        $sequence_4 = { 8b4b14 894734 83c240 8b45e8 83c640 83e840 }
            // n = 6, score = 500
            //   8b4b14               | mov                 ecx, dword ptr [ebx + 0x14]
            //   894734               | mov                 dword ptr [edi + 0x34], eax
            //   83c240               | add                 edx, 0x40
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]
            //   83c640               | add                 esi, 0x40
            //   83e840               | sub                 eax, 0x40

        $sequence_5 = { ffb52cfbffff 56 ffb518fbffff 51 8b8d30fbffff e8???????? }
            // n = 6, score = 500
            //   ffb52cfbffff         | push                dword ptr [ebp - 0x4d4]
            //   56                   | push                esi
            //   ffb518fbffff         | push                dword ptr [ebp - 0x4e8]
            //   51                   | push                ecx
            //   8b8d30fbffff         | mov                 ecx, dword ptr [ebp - 0x4d0]
            //   e8????????           |                     

        $sequence_6 = { 56 57 ff15???????? 68???????? 57 ff15???????? 8d85a4fdffff }
            // n = 7, score = 500
            //   56                   | push                esi
            //   57                   | push                edi
            //   ff15????????         |                     
            //   68????????           |                     
            //   57                   | push                edi
            //   ff15????????         |                     
            //   8d85a4fdffff         | lea                 eax, [ebp - 0x25c]

        $sequence_7 = { 8b3d???????? 8b442410 8b4c2414 8b542418 d1e8 41 83ea01 }
            // n = 7, score = 500
            //   8b3d????????         |                     
            //   8b442410             | mov                 eax, dword ptr [esp + 0x10]
            //   8b4c2414             | mov                 ecx, dword ptr [esp + 0x14]
            //   8b542418             | mov                 edx, dword ptr [esp + 0x18]
            //   d1e8                 | shr                 eax, 1
            //   41                   | inc                 ecx
            //   83ea01               | sub                 edx, 1

        $sequence_8 = { 83ff40 725c 8b45ac 8b4d9c 0f1006 8b559c 0f105610 }
            // n = 7, score = 500
            //   83ff40               | cmp                 edi, 0x40
            //   725c                 | jb                  0x5e
            //   8b45ac               | mov                 eax, dword ptr [ebp - 0x54]
            //   8b4d9c               | mov                 ecx, dword ptr [ebp - 0x64]
            //   0f1006               | movups              xmm0, xmmword ptr [esi]
            //   8b559c               | mov                 edx, dword ptr [ebp - 0x64]
            //   0f105610             | movups              xmm2, xmmword ptr [esi + 0x10]

        $sequence_9 = { 7707 8b4310 3bd0 730e 8d463f 3bc8 773b }
            // n = 7, score = 500
            //   7707                 | ja                  9
            //   8b4310               | mov                 eax, dword ptr [ebx + 0x10]
            //   3bd0                 | cmp                 edx, eax
            //   730e                 | jae                 0x10
            //   8d463f               | lea                 eax, [esi + 0x3f]
            //   3bc8                 | cmp                 ecx, eax
            //   773b                 | ja                  0x3d

    condition:
        7 of them and filesize < 253952
}