rule win_adkoob_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.adkoob."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.adkoob"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d4eb0 8b4004 c74430980c4b4c00 8b4698 8b5004 8d4298 89443294 }
            // n = 7, score = 400
            //   8d4eb0               | lea                 ecx, [esi - 0x50]
            //   8b4004               | mov                 eax, dword ptr [eax + 4]
            //   c74430980c4b4c00     | mov                 dword ptr [eax + esi - 0x68], 0x4c4b0c
            //   8b4698               | mov                 eax, dword ptr [esi - 0x68]
            //   8b5004               | mov                 edx, dword ptr [eax + 4]
            //   8d4298               | lea                 eax, [edx - 0x68]
            //   89443294             | mov                 dword ptr [edx + esi - 0x6c], eax

        $sequence_1 = { 8b45f8 53 ff75fc 50 6a7e 5a 8bcf }
            // n = 7, score = 400
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   53                   | push                ebx
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   50                   | push                eax
            //   6a7e                 | push                0x7e
            //   5a                   | pop                 edx
            //   8bcf                 | mov                 ecx, edi

        $sequence_2 = { 894638 85c0 740f 68???????? 50 ff15???????? 894640 }
            // n = 7, score = 400
            //   894638               | mov                 dword ptr [esi + 0x38], eax
            //   85c0                 | test                eax, eax
            //   740f                 | je                  0x11
            //   68????????           |                     
            //   50                   | push                eax
            //   ff15????????         |                     
            //   894640               | mov                 dword ptr [esi + 0x40], eax

        $sequence_3 = { 898424fc000000 33c0 898424f8000000 89842400010000 89842404010000 8a83a4010000 88443134 }
            // n = 7, score = 400
            //   898424fc000000       | mov                 dword ptr [esp + 0xfc], eax
            //   33c0                 | xor                 eax, eax
            //   898424f8000000       | mov                 dword ptr [esp + 0xf8], eax
            //   89842400010000       | mov                 dword ptr [esp + 0x100], eax
            //   89842404010000       | mov                 dword ptr [esp + 0x104], eax
            //   8a83a4010000         | mov                 al, byte ptr [ebx + 0x1a4]
            //   88443134             | mov                 byte ptr [ecx + esi + 0x34], al

        $sequence_4 = { 897dec 8945fc 85ff 741b 8b7508 8bcf 56 }
            // n = 7, score = 400
            //   897dec               | mov                 dword ptr [ebp - 0x14], edi
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   85ff                 | test                edi, edi
            //   741b                 | je                  0x1d
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   8bcf                 | mov                 ecx, edi
            //   56                   | push                esi

        $sequence_5 = { b8???????? e8???????? 8bf2 8bf9 89bd0cffffff 33c0 898508ffffff }
            // n = 7, score = 400
            //   b8????????           |                     
            //   e8????????           |                     
            //   8bf2                 | mov                 esi, edx
            //   8bf9                 | mov                 edi, ecx
            //   89bd0cffffff         | mov                 dword ptr [ebp - 0xf4], edi
            //   33c0                 | xor                 eax, eax
            //   898508ffffff         | mov                 dword ptr [ebp - 0xf8], eax

        $sequence_6 = { 8bf9 83fb1c 7517 837f2400 7511 ff750c 8b5508 }
            // n = 7, score = 400
            //   8bf9                 | mov                 edi, ecx
            //   83fb1c               | cmp                 ebx, 0x1c
            //   7517                 | jne                 0x19
            //   837f2400             | cmp                 dword ptr [edi + 0x24], 0
            //   7511                 | jne                 0x13
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]

        $sequence_7 = { 8d4e28 51 8d4e20 f7de 8b10 1bf6 23f1 }
            // n = 7, score = 400
            //   8d4e28               | lea                 ecx, [esi + 0x28]
            //   51                   | push                ecx
            //   8d4e20               | lea                 ecx, [esi + 0x20]
            //   f7de                 | neg                 esi
            //   8b10                 | mov                 edx, dword ptr [eax]
            //   1bf6                 | sbb                 esi, esi
            //   23f1                 | and                 esi, ecx

        $sequence_8 = { 8b4714 8945f8 81e1f7ff0000 8bd3 66894f18 8bce e8???????? }
            // n = 7, score = 400
            //   8b4714               | mov                 eax, dword ptr [edi + 0x14]
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   81e1f7ff0000         | and                 ecx, 0xfff7
            //   8bd3                 | mov                 edx, ebx
            //   66894f18             | mov                 word ptr [edi + 0x18], cx
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     

        $sequence_9 = { ff75c4 ffb540ffffff e8???????? 83c428 837da400 741a ffb56cffffff }
            // n = 7, score = 400
            //   ff75c4               | push                dword ptr [ebp - 0x3c]
            //   ffb540ffffff         | push                dword ptr [ebp - 0xc0]
            //   e8????????           |                     
            //   83c428               | add                 esp, 0x28
            //   837da400             | cmp                 dword ptr [ebp - 0x5c], 0
            //   741a                 | je                  0x1c
            //   ffb56cffffff         | push                dword ptr [ebp - 0x94]

    condition:
        7 of them and filesize < 1867776
}