rule win_afrodita_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.afrodita."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.afrodita"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 ff75dc e8???????? 83c40c 84c0 0f84aa030000 }
            // n = 6, score = 300
            //   50                   | push                eax
            //   ff75dc               | push                dword ptr [ebp - 0x24]
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   84c0                 | test                al, al
            //   0f84aa030000         | je                  0x3b0

        $sequence_1 = { 52 53 ff7508 8b4004 c645fc01 8b4c3038 8b01 }
            // n = 7, score = 300
            //   52                   | push                edx
            //   53                   | push                ebx
            //   ff7508               | push                dword ptr [ebp + 8]
            //   8b4004               | mov                 eax, dword ptr [eax + 4]
            //   c645fc01             | mov                 byte ptr [ebp - 4], 1
            //   8b4c3038             | mov                 ecx, dword ptr [eax + esi + 0x38]
            //   8b01                 | mov                 eax, dword ptr [ecx]

        $sequence_2 = { e8???????? 83c404 c645fc09 8d8d6cffffff ff75a0 e8???????? 83e3df }
            // n = 7, score = 300
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   c645fc09             | mov                 byte ptr [ebp - 4], 9
            //   8d8d6cffffff         | lea                 ecx, [ebp - 0x94]
            //   ff75a0               | push                dword ptr [ebp - 0x60]
            //   e8????????           |                     
            //   83e3df               | and                 ebx, 0xffffffdf

        $sequence_3 = { 6a7d 8d4d80 53 e8???????? e9???????? 83ff4d 0f8443010000 }
            // n = 7, score = 300
            //   6a7d                 | push                0x7d
            //   8d4d80               | lea                 ecx, [ebp - 0x80]
            //   53                   | push                ebx
            //   e8????????           |                     
            //   e9????????           |                     
            //   83ff4d               | cmp                 edi, 0x4d
            //   0f8443010000         | je                  0x149

        $sequence_4 = { 33c8 8b45f0 3345e4 23c7 8b7ddc 3345e4 03c8 }
            // n = 7, score = 300
            //   33c8                 | xor                 ecx, eax
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   3345e4               | xor                 eax, dword ptr [ebp - 0x1c]
            //   23c7                 | and                 eax, edi
            //   8b7ddc               | mov                 edi, dword ptr [ebp - 0x24]
            //   3345e4               | xor                 eax, dword ptr [ebp - 0x1c]
            //   03c8                 | add                 ecx, eax

        $sequence_5 = { 837d1000 8b10 0f444d10 51 56 }
            // n = 5, score = 300
            //   837d1000             | cmp                 dword ptr [ebp + 0x10], 0
            //   8b10                 | mov                 edx, dword ptr [eax]
            //   0f444d10             | cmove               ecx, dword ptr [ebp + 0x10]
            //   51                   | push                ecx
            //   56                   | push                esi

        $sequence_6 = { 2345e4 03ca 3345f4 03c1 8945e4 85db 7437 }
            // n = 7, score = 300
            //   2345e4               | and                 eax, dword ptr [ebp - 0x1c]
            //   03ca                 | add                 ecx, edx
            //   3345f4               | xor                 eax, dword ptr [ebp - 0xc]
            //   03c1                 | add                 eax, ecx
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   85db                 | test                ebx, ebx
            //   7437                 | je                  0x39

        $sequence_7 = { 51 8d4b04 ff5008 68???????? 50 8d45c0 c745fc00000000 }
            // n = 7, score = 300
            //   51                   | push                ecx
            //   8d4b04               | lea                 ecx, [ebx + 4]
            //   ff5008               | call                dword ptr [eax + 8]
            //   68????????           |                     
            //   50                   | push                eax
            //   8d45c0               | lea                 eax, [ebp - 0x40]
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0

        $sequence_8 = { 7445 833d????????00 743c 56 6a10 8d45ec 50 }
            // n = 7, score = 300
            //   7445                 | je                  0x47
            //   833d????????00       |                     
            //   743c                 | je                  0x3e
            //   56                   | push                esi
            //   6a10                 | push                0x10
            //   8d45ec               | lea                 eax, [ebp - 0x14]
            //   50                   | push                eax

        $sequence_9 = { e8???????? eb05 e8???????? 83c404 8b9564ffffff 399560ffffff 8bb568ffffff }
            // n = 7, score = 300
            //   e8????????           |                     
            //   eb05                 | jmp                 7
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8b9564ffffff         | mov                 edx, dword ptr [ebp - 0x9c]
            //   399560ffffff         | cmp                 dword ptr [ebp - 0xa0], edx
            //   8bb568ffffff         | mov                 esi, dword ptr [ebp - 0x98]

    condition:
        7 of them and filesize < 2334720
}