rule win_agendacrypt_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.agendacrypt."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.agendacrypt"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 85c0 0f8409010000 f30f7e05???????? 0f280d???????? 89442428 c744243404000000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   0f8409010000         | je                  0x10f
            //   f30f7e05????????     |                     
            //   0f280d????????       |                     
            //   89442428             | mov                 dword ptr [esp + 0x28], eax
            //   c744243404000000     | mov                 dword ptr [esp + 0x34], 4

        $sequence_1 = { 8b75d4 89500c 85f6 7516 eb38 8b45e8 8b5804 }
            // n = 7, score = 100
            //   8b75d4               | mov                 esi, dword ptr [ebp - 0x2c]
            //   89500c               | mov                 dword ptr [eax + 0xc], edx
            //   85f6                 | test                esi, esi
            //   7516                 | jne                 0x18
            //   eb38                 | jmp                 0x3a
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]
            //   8b5804               | mov                 ebx, dword ptr [eax + 4]

        $sequence_2 = { 89c3 81fba3030000 8955d8 0f84e9000000 660f1f840000000000 81fb00001100 0f8420ffffff }
            // n = 7, score = 100
            //   89c3                 | mov                 ebx, eax
            //   81fba3030000         | cmp                 ebx, 0x3a3
            //   8955d8               | mov                 dword ptr [ebp - 0x28], edx
            //   0f84e9000000         | je                  0xef
            //   660f1f840000000000     | nop    word ptr [eax + eax]
            //   81fb00001100         | cmp                 ebx, 0x110000
            //   0f8420ffffff         | je                  0xffffff26

        $sequence_3 = { 8d4c2424 8d542470 e8???????? e9???????? b9???????? eb63 c744247006000000 }
            // n = 7, score = 100
            //   8d4c2424             | lea                 ecx, [esp + 0x24]
            //   8d542470             | lea                 edx, [esp + 0x70]
            //   e8????????           |                     
            //   e9????????           |                     
            //   b9????????           |                     
            //   eb63                 | jmp                 0x65
            //   c744247006000000     | mov                 dword ptr [esp + 0x70], 6

        $sequence_4 = { 8d4dec e8???????? 8b55f4 8b45ec 66c7045000ff 42 8955f4 }
            // n = 7, score = 100
            //   8d4dec               | lea                 ecx, [ebp - 0x14]
            //   e8????????           |                     
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   66c7045000ff         | mov                 word ptr [eax + edx*2], 0xff00
            //   42                   | inc                 edx
            //   8955f4               | mov                 dword ptr [ebp - 0xc], edx

        $sequence_5 = { e8???????? 837dcc02 7211 a1???????? ff75d0 6a00 ff30 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   837dcc02             | cmp                 dword ptr [ebp - 0x34], 2
            //   7211                 | jb                  0x13
            //   a1????????           |                     
            //   ff75d0               | push                dword ptr [ebp - 0x30]
            //   6a00                 | push                0
            //   ff30                 | push                dword ptr [eax]

        $sequence_6 = { e8???????? 8b7de8 8b75f0 8b4510 66c704772200 46 8975f0 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b7de8               | mov                 edi, dword ptr [ebp - 0x18]
            //   8b75f0               | mov                 esi, dword ptr [ebp - 0x10]
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   66c704772200         | mov                 word ptr [edi + esi*2], 0x22
            //   46                   | inc                 esi
            //   8975f0               | mov                 dword ptr [ebp - 0x10], esi

        $sequence_7 = { c745d000000000 8945f0 8d45f0 c745f490b04100 8945d8 c745dc01000000 8d45c8 }
            // n = 7, score = 100
            //   c745d000000000       | mov                 dword ptr [ebp - 0x30], 0
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   8d45f0               | lea                 eax, [ebp - 0x10]
            //   c745f490b04100       | mov                 dword ptr [ebp - 0xc], 0x41b090
            //   8945d8               | mov                 dword ptr [ebp - 0x28], eax
            //   c745dc01000000       | mov                 dword ptr [ebp - 0x24], 1
            //   8d45c8               | lea                 eax, [ebp - 0x38]

        $sequence_8 = { c1c20e 894dc0 8b4db4 c1c619 31d0 89fa 31f0 }
            // n = 7, score = 100
            //   c1c20e               | rol                 edx, 0xe
            //   894dc0               | mov                 dword ptr [ebp - 0x40], ecx
            //   8b4db4               | mov                 ecx, dword ptr [ebp - 0x4c]
            //   c1c619               | rol                 esi, 0x19
            //   31d0                 | xor                 eax, edx
            //   89fa                 | mov                 edx, edi
            //   31f0                 | xor                 eax, esi

        $sequence_9 = { f20f1145b0 894db8 742c f20f1045bc f20f104dc4 f20f114de4 f20f1145dc }
            // n = 7, score = 100
            //   f20f1145b0           | movsd               qword ptr [ebp - 0x50], xmm0
            //   894db8               | mov                 dword ptr [ebp - 0x48], ecx
            //   742c                 | je                  0x2e
            //   f20f1045bc           | movsd               xmm0, qword ptr [ebp - 0x44]
            //   f20f104dc4           | movsd               xmm1, qword ptr [ebp - 0x3c]
            //   f20f114de4           | movsd               qword ptr [ebp - 0x1c], xmm1
            //   f20f1145dc           | movsd               qword ptr [ebp - 0x24], xmm0

    condition:
        7 of them and filesize < 3340288
}