rule win_agent_btz_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.agent_btz."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.agent_btz"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 51 ffd6 8d54240c 52 ffd7 }
            // n = 5, score = 2400
            //   51                   | push                ecx
            //   ffd6                 | call                esi
            //   8d54240c             | lea                 edx, [esp + 0xc]
            //   52                   | push                edx
            //   ffd7                 | call                edi

        $sequence_1 = { c74608ffffffff f644240801 7409 56 }
            // n = 4, score = 2400
            //   c74608ffffffff       | mov                 dword ptr [esi + 8], 0xffffffff
            //   f644240801           | test                byte ptr [esp + 8], 1
            //   7409                 | je                  0xb
            //   56                   | push                esi

        $sequence_2 = { 50 ffd3 85c0 75d8 5f 5e 5b }
            // n = 7, score = 2400
            //   50                   | push                eax
            //   ffd3                 | call                ebx
            //   85c0                 | test                eax, eax
            //   75d8                 | jne                 0xffffffda
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx

        $sequence_3 = { c706???????? c7460c00000000 895e08 895e04 c7461000000000 895e14 }
            // n = 6, score = 2300
            //   c706????????         |                     
            //   c7460c00000000       | mov                 dword ptr [esi + 0xc], 0
            //   895e08               | mov                 dword ptr [esi + 8], ebx
            //   895e04               | mov                 dword ptr [esi + 4], ebx
            //   c7461000000000       | mov                 dword ptr [esi + 0x10], 0
            //   895e14               | mov                 dword ptr [esi + 0x14], ebx

        $sequence_4 = { ff15???????? b804000f00 8b4df4 64890d00000000 5f 5e 5b }
            // n = 7, score = 2300
            //   ff15????????         |                     
            //   b804000f00           | mov                 eax, 0xf0004
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   64890d00000000       | mov                 dword ptr fs:[0], ecx
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx

        $sequence_5 = { 56 6a00 68???????? 8935???????? e8???????? }
            // n = 5, score = 2200
            //   56                   | push                esi
            //   6a00                 | push                0
            //   68????????           |                     
            //   8935????????         |                     
            //   e8????????           |                     

        $sequence_6 = { 6a00 50 ff15???????? 894614 33c0 }
            // n = 5, score = 2200
            //   6a00                 | push                0
            //   50                   | push                eax
            //   ff15????????         |                     
            //   894614               | mov                 dword ptr [esi + 0x14], eax
            //   33c0                 | xor                 eax, eax

        $sequence_7 = { 740e 50 ff15???????? c74608ffffffff f644240801 }
            // n = 5, score = 2100
            //   740e                 | je                  0x10
            //   50                   | push                eax
            //   ff15????????         |                     
            //   c74608ffffffff       | mov                 dword ptr [esi + 8], 0xffffffff
            //   f644240801           | test                byte ptr [esp + 8], 1

        $sequence_8 = { 8d542408 52 c744240c30000000 c744241003000000 }
            // n = 4, score = 2100
            //   8d542408             | lea                 edx, [esp + 8]
            //   52                   | push                edx
            //   c744240c30000000     | mov                 dword ptr [esp + 0xc], 0x30
            //   c744241003000000     | mov                 dword ptr [esp + 0x10], 3

        $sequence_9 = { 8bf1 8b4608 c706???????? 85c0 7413 83f8ff 740e }
            // n = 7, score = 2100
            //   8bf1                 | mov                 esi, ecx
            //   8b4608               | mov                 eax, dword ptr [esi + 8]
            //   c706????????         |                     
            //   85c0                 | test                eax, eax
            //   7413                 | je                  0x15
            //   83f8ff               | cmp                 eax, -1
            //   740e                 | je                  0x10

        $sequence_10 = { 6801010000 ff15???????? 85c0 7415 }
            // n = 4, score = 1800
            //   6801010000           | push                0x101
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7415                 | je                  0x17

        $sequence_11 = { 6a0a 68???????? 6a01 6a00 68???????? }
            // n = 5, score = 1400
            //   6a0a                 | push                0xa
            //   68????????           |                     
            //   6a01                 | push                1
            //   6a00                 | push                0
            //   68????????           |                     

        $sequence_12 = { 51 6a00 6819000200 6a00 68???????? }
            // n = 5, score = 1400
            //   51                   | push                ecx
            //   6a00                 | push                0
            //   6819000200           | push                0x20019
            //   6a00                 | push                0
            //   68????????           |                     

        $sequence_13 = { 50 68???????? 6a01 68???????? e8???????? 83c410 }
            // n = 6, score = 1100
            //   50                   | push                eax
            //   68????????           |                     
            //   6a01                 | push                1
            //   68????????           |                     
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10

        $sequence_14 = { 6a01 6a04 6a01 68???????? }
            // n = 4, score = 1100
            //   6a01                 | push                1
            //   6a04                 | push                4
            //   6a01                 | push                1
            //   68????????           |                     

        $sequence_15 = { 50 e8???????? 83c408 6800010000 e8???????? }
            // n = 5, score = 1000
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   6800010000           | push                0x100
            //   e8????????           |                     

        $sequence_16 = { 6a01 68???????? e8???????? 83c414 5f 5e 5b }
            // n = 7, score = 1000
            //   6a01                 | push                1
            //   68????????           |                     
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx

        $sequence_17 = { 89461c 3dea000000 740b 3de5030000 }
            // n = 4, score = 900
            //   89461c               | mov                 dword ptr [esi + 0x1c], eax
            //   3dea000000           | cmp                 eax, 0xea
            //   740b                 | je                  0xd
            //   3de5030000           | cmp                 eax, 0x3e5

        $sequence_18 = { 7511 e8???????? 83c020 50 }
            // n = 4, score = 900
            //   7511                 | jne                 0x13
            //   e8????????           |                     
            //   83c020               | add                 eax, 0x20
            //   50                   | push                eax

        $sequence_19 = { 0fb605???????? 66890d???????? 0fb60d???????? 660fafca }
            // n = 4, score = 900
            //   0fb605????????       |                     
            //   66890d????????       |                     
            //   0fb60d????????       |                     
            //   660fafca             | imul                cx, dx

        $sequence_20 = { 83c020 50 e8???????? 83c404 33c0 }
            // n = 5, score = 900
            //   83c020               | add                 eax, 0x20
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   33c0                 | xor                 eax, eax

        $sequence_21 = { 68???????? 6a01 e8???????? 50 e8???????? 83c41c }
            // n = 6, score = 900
            //   68????????           |                     
            //   6a01                 | push                1
            //   e8????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c41c               | add                 esp, 0x1c

        $sequence_22 = { 740d 3cff 7409 f6d0 }
            // n = 4, score = 800
            //   740d                 | je                  0xf
            //   3cff                 | cmp                 al, 0xff
            //   7409                 | je                  0xb
            //   f6d0                 | not                 al

        $sequence_23 = { c684249200000065 c684249300000073 c684249400000073 c684249500000057 }
            // n = 4, score = 800
            //   c684249200000065     | mov                 byte ptr [esp + 0x92], 0x65
            //   c684249300000073     | mov                 byte ptr [esp + 0x93], 0x73
            //   c684249400000073     | mov                 byte ptr [esp + 0x94], 0x73
            //   c684249500000057     | mov                 byte ptr [esp + 0x95], 0x57

        $sequence_24 = { 33c9 ff542458 85c0 7420 }
            // n = 4, score = 800
            //   33c9                 | xor                 ecx, ecx
            //   ff542458             | call                dword ptr [esp + 0x58]
            //   85c0                 | test                eax, eax
            //   7420                 | je                  0x22

        $sequence_25 = { c684248b00000061 c684248c00000074 c684248d00000065 c684248e00000050 c684248f00000072 c68424900000006f }
            // n = 6, score = 800
            //   c684248b00000061     | mov                 byte ptr [esp + 0x8b], 0x61
            //   c684248c00000074     | mov                 byte ptr [esp + 0x8c], 0x74
            //   c684248d00000065     | mov                 byte ptr [esp + 0x8d], 0x65
            //   c684248e00000050     | mov                 byte ptr [esp + 0x8e], 0x50
            //   c684248f00000072     | mov                 byte ptr [esp + 0x8f], 0x72
            //   c68424900000006f     | mov                 byte ptr [esp + 0x90], 0x6f

        $sequence_26 = { 57 ff7508 8bf1 33db 895e10 }
            // n = 5, score = 800
            //   57                   | push                edi
            //   ff7508               | push                dword ptr [ebp + 8]
            //   8bf1                 | mov                 esi, ecx
            //   33db                 | xor                 ebx, ebx
            //   895e10               | mov                 dword ptr [esi + 0x10], ebx

        $sequence_27 = { 6808020000 50 668945fa 8d85d8fdffff }
            // n = 4, score = 800
            //   6808020000           | push                0x208
            //   50                   | push                eax
            //   668945fa             | mov                 word ptr [ebp - 6], ax
            //   8d85d8fdffff         | lea                 eax, [ebp - 0x228]

        $sequence_28 = { 33ff 8d85f8f7ffff 57 50 }
            // n = 4, score = 800
            //   33ff                 | xor                 edi, edi
            //   8d85f8f7ffff         | lea                 eax, [ebp - 0x808]
            //   57                   | push                edi
            //   50                   | push                eax

        $sequence_29 = { 6a00 6a27 6a02 6a00 6a01 }
            // n = 5, score = 800
            //   6a00                 | push                0
            //   6a27                 | push                0x27
            //   6a02                 | push                2
            //   6a00                 | push                0
            //   6a01                 | push                1

        $sequence_30 = { 8b85f8feffff 53 8d8df4feffff 51 8d8df8feffff }
            // n = 5, score = 800
            //   8b85f8feffff         | mov                 eax, dword ptr [ebp - 0x108]
            //   53                   | push                ebx
            //   8d8df4feffff         | lea                 ecx, [ebp - 0x10c]
            //   51                   | push                ecx
            //   8d8df8feffff         | lea                 ecx, [ebp - 0x108]

        $sequence_31 = { ff9574ffffff 8b4de0 89410c 33c0 8be5 5d c20400 }
            // n = 7, score = 800
            //   ff9574ffffff         | call                dword ptr [ebp - 0x8c]
            //   8b4de0               | mov                 ecx, dword ptr [ebp - 0x20]
            //   89410c               | mov                 dword ptr [ecx + 0xc], eax
            //   33c0                 | xor                 eax, eax
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c20400               | ret                 4

        $sequence_32 = { c684249500000057 c684249600000000 c684241001000047 c684241101000065 c684241201000074 c68424130100004c }
            // n = 6, score = 800
            //   c684249500000057     | mov                 byte ptr [esp + 0x95], 0x57
            //   c684249600000000     | mov                 byte ptr [esp + 0x96], 0
            //   c684241001000047     | mov                 byte ptr [esp + 0x110], 0x47
            //   c684241101000065     | mov                 byte ptr [esp + 0x111], 0x65
            //   c684241201000074     | mov                 byte ptr [esp + 0x112], 0x74
            //   c68424130100004c     | mov                 byte ptr [esp + 0x113], 0x4c

        $sequence_33 = { 50 8d85e8fdffff 50 c745fc04010000 }
            // n = 4, score = 800
            //   50                   | push                eax
            //   8d85e8fdffff         | lea                 eax, [ebp - 0x218]
            //   50                   | push                eax
            //   c745fc04010000       | mov                 dword ptr [ebp - 4], 0x104

        $sequence_34 = { c684248f00000072 c68424900000006f c684249100000063 c684249200000065 }
            // n = 4, score = 800
            //   c684248f00000072     | mov                 byte ptr [esp + 0x8f], 0x72
            //   c68424900000006f     | mov                 byte ptr [esp + 0x90], 0x6f
            //   c684249100000063     | mov                 byte ptr [esp + 0x91], 0x63
            //   c684249200000065     | mov                 byte ptr [esp + 0x92], 0x65

        $sequence_35 = { 50 8945f8 33ff 8d85f8f7ffff }
            // n = 4, score = 800
            //   50                   | push                eax
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   33ff                 | xor                 edi, edi
            //   8d85f8f7ffff         | lea                 eax, [ebp - 0x808]

        $sequence_36 = { 8bc8 66894de0 66894de2 59 6a70 }
            // n = 5, score = 800
            //   8bc8                 | mov                 ecx, eax
            //   66894de0             | mov                 word ptr [ebp - 0x20], cx
            //   66894de2             | mov                 word ptr [ebp - 0x1e], cx
            //   59                   | pop                 ecx
            //   6a70                 | push                0x70

        $sequence_37 = { 8d8505feffff 50 e8???????? 83c40c }
            // n = 4, score = 700
            //   8d8505feffff         | lea                 eax, [ebp - 0x1fb]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc

        $sequence_38 = { c645d316 c645d43a c645d53b c645d63b c645d730 }
            // n = 5, score = 700
            //   c645d316             | mov                 byte ptr [ebp - 0x2d], 0x16
            //   c645d43a             | mov                 byte ptr [ebp - 0x2c], 0x3a
            //   c645d53b             | mov                 byte ptr [ebp - 0x2b], 0x3b
            //   c645d63b             | mov                 byte ptr [ebp - 0x2a], 0x3b
            //   c645d730             | mov                 byte ptr [ebp - 0x29], 0x30

        $sequence_39 = { 488b4338 33d2 488bce 448d4220 }
            // n = 4, score = 500
            //   488b4338             | dec                 eax
            //   33d2                 | mov                 eax, dword ptr [ebx + 0x38]
            //   488bce               | xor                 edx, edx
            //   448d4220             | dec                 eax

        $sequence_40 = { 488b4b38 ff5160 894330 3dea000000 }
            // n = 4, score = 400
            //   488b4b38             | dec                 eax
            //   ff5160               | mov                 dword ptr [esi + 0x28], eax
            //   894330               | dec                 eax
            //   3dea000000           | mov                 eax, dword ptr [esi + 0x38]

        $sequence_41 = { 488b0e 48894628 488b4638 4c8d4c2450 448bc3 }
            // n = 5, score = 400
            //   488b0e               | lea                 eax, [esp + 0x50]
            //   48894628             | inc                 ebp
            //   488b4638             | xor                 ecx, ecx
            //   4c8d4c2450           | or                  ecx, 4
            //   448bc3               | shr                 eax, 3

        $sequence_42 = { 488b07 896830 33c0 488b5c2458 488b6c2460 488b742468 4883c440 }
            // n = 7, score = 400
            //   488b07               | mov                 dword ptr [ecx + 8], eax
            //   896830               | dec                 eax
            //   33c0                 | mov                 ecx, dword ptr [edi]
            //   488b5c2458           | dec                 eax
            //   488b6c2460           | mov                 eax, dword ptr [ecx + 8]
            //   488b742468           | dec                 eax
            //   4883c440             | mov                 dword ptr [ecx + 0x28], eax

        $sequence_43 = { 488b0f 894130 eb06 488b07 896830 33c0 }
            // n = 6, score = 400
            //   488b0f               | mov                 dword ptr [ecx + 8], eax
            //   894130               | dec                 eax
            //   eb06                 | mov                 ecx, dword ptr [edi]
            //   488b07               | dec                 eax
            //   896830               | mov                 eax, dword ptr [ecx + 8]
            //   33c0                 | dec                 eax

        $sequence_44 = { 83c904 c1e803 448bc9 440fafc8 }
            // n = 4, score = 400
            //   83c904               | mov                 eax, dword ptr [esi + 0x38]
            //   c1e803               | dec                 eax
            //   448bc9               | mov                 ecx, dword ptr [esi]
            //   440fafc8             | dec                 esp

        $sequence_45 = { 488b4638 488b0e 4c8d442450 4533c9 }
            // n = 4, score = 400
            //   488b4638             | mov                 ecx, esi
            //   488b0e               | inc                 esp
            //   4c8d442450           | lea                 eax, [edx + 0x20]
            //   4533c9               | dec                 eax

        $sequence_46 = { 488b4638 ff5060 894630 3de5030000 }
            // n = 4, score = 400
            //   488b4638             | dec                 eax
            //   ff5060               | mov                 ecx, dword ptr [esi]
            //   894630               | dec                 eax
            //   3de5030000           | mov                 dword ptr [esi + 0x28], eax

        $sequence_47 = { 488bcf c744242088130000 e8???????? 488b5738 }
            // n = 4, score = 400
            //   488bcf               | mov                 eax, dword ptr [esi + 8]
            //   c744242088130000     | dec                 eax
            //   e8????????           |                     
            //   488b5738             | mov                 ecx, dword ptr [esi]

        $sequence_48 = { 488b0f 488901 488b07 488338ff }
            // n = 4, score = 400
            //   488b0f               | dec                 eax
            //   488901               | mov                 ecx, dword ptr [edi]
            //   488b07               | dec                 eax
            //   488338ff             | mov                 eax, dword ptr [ecx + 8]

        $sequence_49 = { 488b0f 48894108 488b0f 488b4108 48894128 488b0f }
            // n = 6, score = 400
            //   488b0f               | mov                 ecx, esi
            //   48894108             | inc                 esp
            //   488b0f               | lea                 eax, [edx + 0x20]
            //   488b4108             | dec                 eax
            //   48894128             | mov                 ecx, dword ptr [edi]
            //   488b0f               | dec                 eax

        $sequence_50 = { 85db 7415 4c8b4f38 488d4804 }
            // n = 4, score = 400
            //   85db                 | dec                 esp
            //   7415                 | lea                 ecx, [esp + 0x50]
            //   4c8b4f38             | inc                 esp
            //   488d4804             | mov                 eax, ebx

        $sequence_51 = { 8d8594faffff 50 68???????? ff15???????? }
            // n = 4, score = 300
            //   8d8594faffff         | lea                 eax, [ebp - 0x56c]
            //   50                   | push                eax
            //   68????????           |                     
            //   ff15????????         |                     

        $sequence_52 = { 742e f7460800000080 7405 83c60c }
            // n = 4, score = 200
            //   742e                 | je                  0x30
            //   f7460800000080       | test                dword ptr [esi + 8], 0x80000000
            //   7405                 | je                  7
            //   83c60c               | add                 esi, 0xc

        $sequence_53 = { 72e3 8b2d???????? 8d442420 50 ffd5 }
            // n = 5, score = 200
            //   72e3                 | jb                  0xffffffe5
            //   8b2d????????         |                     
            //   8d442420             | lea                 eax, [esp + 0x20]
            //   50                   | push                eax
            //   ffd5                 | call                ebp

        $sequence_54 = { 57 33db 8d84248c000000 6a3c 53 }
            // n = 5, score = 200
            //   57                   | push                edi
            //   33db                 | xor                 ebx, ebx
            //   8d84248c000000       | lea                 eax, [esp + 0x8c]
            //   6a3c                 | push                0x3c
            //   53                   | push                ebx

        $sequence_55 = { 85ed 7506 8b4204 8b680c b86e6b0000 66394504 0f856e010000 }
            // n = 7, score = 200
            //   85ed                 | test                ebp, ebp
            //   7506                 | jne                 8
            //   8b4204               | mov                 eax, dword ptr [edx + 4]
            //   8b680c               | mov                 ebp, dword ptr [eax + 0xc]
            //   b86e6b0000           | mov                 eax, 0x6b6e
            //   66394504             | cmp                 word ptr [ebp + 4], ax
            //   0f856e010000         | jne                 0x174

        $sequence_56 = { 8b4604 3938 747b 8b33 57 }
            // n = 5, score = 200
            //   8b4604               | mov                 eax, dword ptr [esi + 4]
            //   3938                 | cmp                 dword ptr [eax], edi
            //   747b                 | je                  0x7d
            //   8b33                 | mov                 esi, dword ptr [ebx]
            //   57                   | push                edi

        $sequence_57 = { 5e 59 c3 68???????? e8???????? 59 b815000040 }
            // n = 7, score = 200
            //   5e                   | pop                 esi
            //   59                   | pop                 ecx
            //   c3                   | ret                 
            //   68????????           |                     
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   b815000040           | mov                 eax, 0x40000015

        $sequence_58 = { ff74241c ffd3 837c241000 740a }
            // n = 4, score = 200
            //   ff74241c             | push                dword ptr [esp + 0x1c]
            //   ffd3                 | call                ebx
            //   837c241000           | cmp                 dword ptr [esp + 0x10], 0
            //   740a                 | je                  0xc

    condition:
        7 of them and filesize < 5577728
}