rule win_akdoortea_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.akdoortea."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.akdoortea"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 006118 40 007019 40 00411a }
            // n = 5, score = 100
            //   006118               | add                 byte ptr [ecx + 0x18], ah
            //   40                   | inc                 eax
            //   007019               | add                 byte ptr [eax + 0x19], dh
            //   40                   | inc                 eax
            //   00411a               | add                 byte ptr [ecx + 0x1a], al

        $sequence_1 = { 7641 8d85f0feffff 8d5001 0f1f8000000000 8a08 }
            // n = 5, score = 100
            //   7641                 | jbe                 0x43
            //   8d85f0feffff         | lea                 eax, [ebp - 0x110]
            //   8d5001               | lea                 edx, [eax + 1]
            //   0f1f8000000000       | nop                 dword ptr [eax]
            //   8a08                 | mov                 cl, byte ptr [eax]

        $sequence_2 = { 8d8df0f9ffff 8d5002 e8???????? 8bf0 83c420 85f6 }
            // n = 6, score = 100
            //   8d8df0f9ffff         | lea                 ecx, [ebp - 0x610]
            //   8d5002               | lea                 edx, [eax + 2]
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   83c420               | add                 esp, 0x20
            //   85f6                 | test                esi, esi

        $sequence_3 = { 8bec 83ec0c 53 8bda 56 8bf1 57 }
            // n = 7, score = 100
            //   8bec                 | mov                 ebp, esp
            //   83ec0c               | sub                 esp, 0xc
            //   53                   | push                ebx
            //   8bda                 | mov                 ebx, edx
            //   56                   | push                esi
            //   8bf1                 | mov                 esi, ecx
            //   57                   | push                edi

        $sequence_4 = { 50 8b04bdf8204200 ff741818 ff15???????? 85c0 0f95c0 eb02 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   8b04bdf8204200       | mov                 eax, dword ptr [edi*4 + 0x4220f8]
            //   ff741818             | push                dword ptr [eax + ebx + 0x18]
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f95c0               | setne               al
            //   eb02                 | jmp                 4

        $sequence_5 = { 7439 8d56ff 8a4201 8d5201 84c0 75f6 }
            // n = 6, score = 100
            //   7439                 | je                  0x3b
            //   8d56ff               | lea                 edx, [esi - 1]
            //   8a4201               | mov                 al, byte ptr [edx + 1]
            //   8d5201               | lea                 edx, [edx + 1]
            //   84c0                 | test                al, al
            //   75f6                 | jne                 0xfffffff8

        $sequence_6 = { 90 85f6 740b 83feff 0f859a000000 eb6c 8b1c8d10a24100 }
            // n = 7, score = 100
            //   90                   | nop                 
            //   85f6                 | test                esi, esi
            //   740b                 | je                  0xd
            //   83feff               | cmp                 esi, -1
            //   0f859a000000         | jne                 0xa0
            //   eb6c                 | jmp                 0x6e
            //   8b1c8d10a24100       | mov                 ebx, dword ptr [ecx*4 + 0x41a210]

        $sequence_7 = { e8???????? 83c414 ebe1 8b55ec 8b4de8 8b0495f8204200 807c082800 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14
            //   ebe1                 | jmp                 0xffffffe3
            //   8b55ec               | mov                 edx, dword ptr [ebp - 0x14]
            //   8b4de8               | mov                 ecx, dword ptr [ebp - 0x18]
            //   8b0495f8204200       | mov                 eax, dword ptr [edx*4 + 0x4220f8]
            //   807c082800           | cmp                 byte ptr [eax + ecx + 0x28], 0

        $sequence_8 = { 83c418 c745f803010000 8d45f8 50 8d4304 50 ff15???????? }
            // n = 7, score = 100
            //   83c418               | add                 esp, 0x18
            //   c745f803010000       | mov                 dword ptr [ebp - 8], 0x103
            //   8d45f8               | lea                 eax, [ebp - 8]
            //   50                   | push                eax
            //   8d4304               | lea                 eax, [ebx + 4]
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_9 = { ffd6 68f4010000 8bf0 ff15???????? 85ff 740e }
            // n = 6, score = 100
            //   ffd6                 | call                esi
            //   68f4010000           | push                0x1f4
            //   8bf0                 | mov                 esi, eax
            //   ff15????????         |                     
            //   85ff                 | test                edi, edi
            //   740e                 | je                  0x10

    condition:
        7 of them and filesize < 305152
}