rule win_akira_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.akira."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.akira"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0fb64718 8807 4863c1 48893cc2 e9???????? 0fb64718 8807 }
            // n = 7, score = 200
            //   0fb64718             | movups              xmm1, xmmword ptr [eax + 0x10]
            //   8807                 | movups              xmmword ptr [ecx + 0x10], xmm1
            //   4863c1               | dec                 eax
            //   48893cc2             | mov                 dword ptr [eax + 0x10], ebx
            //   e9????????           |                     
            //   0fb64718             | dec                 eax
            //   8807                 | mov                 dword ptr [eax + 0x18], 7

        $sequence_1 = { 498d4f18 e8???????? 84c0 742d 498d5718 488d8f18030000 }
            // n = 6, score = 200
            //   498d4f18             | xor                 esi, esi
            //   e8????????           |                     
            //   84c0                 | dec                 eax
            //   742d                 | lea                 edx, [0xfffa45b4]
            //   498d5718             | dec                 eax
            //   488d8f18030000       | movsx               eax, ax

        $sequence_2 = { 6642833c4000 75f5 488d559d 488d8de0080000 e8???????? 90 c645a700 }
            // n = 7, score = 200
            //   6642833c4000         | lea                 edx, [0x26f78]
            //   75f5                 | dec                 esp
            //   488d559d             | lea                 ecx, [0x26f84]
            //   488d8de0080000       | mov                 ecx, 0xb
            //   e8????????           |                     
            //   90                   | dec                 esp
            //   c645a700             | lea                 ecx, [0x3a48d]

        $sequence_3 = { e9???????? 488d8a20140000 e9???????? 488d8a40140000 e9???????? }
            // n = 5, score = 200
            //   e9????????           |                     
            //   488d8a20140000       | mov                 byte ptr [ebp + 0x31f], 0x1c
            //   e9????????           |                     
            //   488d8a40140000       | mov                 byte ptr [ebp + 0x41b], 0x1a
            //   e9????????           |                     

        $sequence_4 = { ffc3 48ffc0 4883f806 7cee 488bcf e8???????? 488b5c2450 }
            // n = 7, score = 200
            //   ffc3                 | dec                 eax
            //   48ffc0               | lea                 ecx, [ebp + 0x6c4]
            //   4883f806             | dec                 esp
            //   7cee                 | mov                 eax, esi
            //   488bcf               | dec                 eax
            //   e8????????           |                     
            //   488b5c2450           | lea                 ecx, [0x82849]

        $sequence_5 = { 4883c108 488b01 48c70100000000 4889442460 bb04000000 4885f6 744e }
            // n = 7, score = 200
            //   4883c108             | test                cl, 4
            //   488b01               | je                  0x13e3
            //   48c70100000000       | movzx               ecx, byte ptr [edx]
            //   4889442460           | and                 ecx, 0xf
            //   bb04000000           | dec                 edx
            //   4885f6               | movsx               eax, byte ptr [ecx + ebx + 0x6b190]
            //   744e                 | inc                 edx

        $sequence_6 = { 0f8456ffffff eb05 4084f6 7407 41c60630 49ffc6 498bd4 }
            // n = 7, score = 200
            //   0f8456ffffff         | lea                 ecx, [edx + 0xa0]
            //   eb05                 | dec                 eax
            //   4084f6               | lea                 ecx, [edx + 0x278]
            //   7407                 | dec                 eax
            //   41c60630             | lea                 ecx, [edx + 0xd8]
            //   49ffc6               | dec                 eax
            //   498bd4               | lea                 ecx, [edx + 0x168]

        $sequence_7 = { 488bda 4533ed 41f7411800400000 7528 410f1000 0f2945c0 4c8b11 }
            // n = 7, score = 200
            //   488bda               | mov                 edi, dword ptr [eax + 0x38]
            //   4533ed               | dec                 eax
            //   41f7411800400000     | mov                 dword ptr [ebx + 0x70], edi
            //   7528                 | dec                 eax
            //   410f1000             | mov                 dword ptr [ebx + 0x78], edi
            //   0f2945c0             | mov                 word ptr [ebx + 0x80], di
            //   4c8b11               | mov                 byte ptr [ebx + 0x82], 1

        $sequence_8 = { f00fc181a4000000 83f801 7506 e8???????? 90 488bc3 4883c420 }
            // n = 7, score = 200
            //   f00fc181a4000000     | je                  0x9d2
            //   83f801               | mov                 ecx, dword ptr [esp + 0x48]
            //   7506                 | dec                 eax
            //   e8????????           |                     
            //   90                   | lea                 edx, [0xfffa592e]
            //   488bc3               | inc                 esp
            //   4883c420             | mov                 esp, dword ptr [ebp + 0x170]

        $sequence_9 = { 48895110 4c8bc7 418bd6 e8???????? 4088341f e9???????? 488bc7 }
            // n = 7, score = 200
            //   48895110             | add                 eax, -8
            //   4c8bc7               | dec                 eax
            //   418bd6               | cmp                 eax, 0x1f
            //   e8????????           |                     
            //   4088341f             | ja                  0xefd
            //   e9????????           |                     
            //   488bc7               | nop                 

    condition:
        7 of them and filesize < 1286144
}