rule win_allaple_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.allaple."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.allaple"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8945f4 57 ff75fc e8???????? 8945f0 897de8 897dec }
            // n = 7, score = 300
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   57                   | push                edi
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   e8????????           |                     
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   897de8               | mov                 dword ptr [ebp - 0x18], edi
            //   897dec               | mov                 dword ptr [ebp - 0x14], edi

        $sequence_1 = { 83c704 c70704000000 83c704 6a18 ff7510 57 e8???????? }
            // n = 7, score = 300
            //   83c704               | add                 edi, 4
            //   c70704000000         | mov                 dword ptr [edi], 4
            //   83c704               | add                 edi, 4
            //   6a18                 | push                0x18
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   57                   | push                edi
            //   e8????????           |                     

        $sequence_2 = { c7420c76543210 8be5 5d c3 55 8bec }
            // n = 6, score = 300
            //   c7420c76543210       | mov                 dword ptr [edx + 0xc], 0x10325476
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp

        $sequence_3 = { 0345d8 50 e8???????? 83c408 a3???????? 6a03 ff35???????? }
            // n = 7, score = 300
            //   0345d8               | add                 eax, dword ptr [ebp - 0x28]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   a3????????           |                     
            //   6a03                 | push                3
            //   ff35????????         |                     

        $sequence_4 = { 8b45e4 33c2 8945e4 8b4dec 8b55f0 8d044a 0345b0 }
            // n = 7, score = 300
            //   8b45e4               | mov                 eax, dword ptr [ebp - 0x1c]
            //   33c2                 | xor                 eax, edx
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   8b4dec               | mov                 ecx, dword ptr [ebp - 0x14]
            //   8b55f0               | mov                 edx, dword ptr [ebp - 0x10]
            //   8d044a               | lea                 eax, [edx + ecx*2]
            //   0345b0               | add                 eax, dword ptr [ebp - 0x50]

        $sequence_5 = { 52 ff750c e8???????? 47 4b 83c604 0bdb }
            // n = 7, score = 300
            //   52                   | push                edx
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   e8????????           |                     
            //   47                   | inc                 edi
            //   4b                   | dec                 ebx
            //   83c604               | add                 esi, 4
            //   0bdb                 | or                  ebx, ebx

        $sequence_6 = { 50 ff75fc e8???????? 8d85c0feffff 50 8d85c4feffff }
            // n = 6, score = 300
            //   50                   | push                eax
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   e8????????           |                     
            //   8d85c0feffff         | lea                 eax, [ebp - 0x140]
            //   50                   | push                eax
            //   8d85c4feffff         | lea                 eax, [ebp - 0x13c]

        $sequence_7 = { 6a00 6a64 8d8544fdffff 50 e8???????? 6a00 }
            // n = 6, score = 300
            //   6a00                 | push                0
            //   6a64                 | push                0x64
            //   8d8544fdffff         | lea                 eax, [ebp - 0x2bc]
            //   50                   | push                eax
            //   e8????????           |                     
            //   6a00                 | push                0

        $sequence_8 = { 8b55fc 8b4238 3345f4 8b4df8 894138 8b55fc 8b423c }
            // n = 7, score = 300
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   8b4238               | mov                 eax, dword ptr [edx + 0x38]
            //   3345f4               | xor                 eax, dword ptr [ebp - 0xc]
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   894138               | mov                 dword ptr [ecx + 0x38], eax
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   8b423c               | mov                 eax, dword ptr [edx + 0x3c]

        $sequence_9 = { 8975f0 6a50 e8???????? 668945ee 6a10 8d45ec 50 }
            // n = 7, score = 300
            //   8975f0               | mov                 dword ptr [ebp - 0x10], esi
            //   6a50                 | push                0x50
            //   e8????????           |                     
            //   668945ee             | mov                 word ptr [ebp - 0x12], ax
            //   6a10                 | push                0x10
            //   8d45ec               | lea                 eax, [ebp - 0x14]
            //   50                   | push                eax

    condition:
        7 of them and filesize < 253952
}