rule win_alpc_lpe_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.alpc_lpe."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.alpc_lpe"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 33c9 0f1f440000 0fb70429 4883c102 6689440ffc 6685c0 }
            // n = 6, score = 100
            //   33c9                 | dec                 eax
            //   0f1f440000           | lea                 edx, [0xb647]
            //   0fb70429             | mov                 eax, dword ptr [ebp + 8]
            //   4883c102             | mov                 edi, eax
            //   6689440ffc           | dec                 eax
            //   6685c0               | lea                 ecx, [ebp - 0x30]

        $sequence_1 = { 48894540 c7455040000000 48c7454800000000 48c7455800000000 48c7456000000000 48c785c800000000000000 c785e800000000000000 }
            // n = 7, score = 100
            //   48894540             | mov                 dword ptr [esp + 0x48], eax
            //   c7455040000000       | dec                 eax
            //   48c7454800000000     | lea                 ecx, [0xa5f6]
            //   48c7455800000000     | dec                 eax
            //   48c7456000000000     | mov                 dword ptr [esp + 0x40], ecx
            //   48c785c800000000000000     | dec    esp
            //   c785e800000000000000     | lea    eax, [0xa69a]

        $sequence_2 = { 488bfc b932000000 b8cccccccc f3ab 488b8c24e8000000 488b85e0000000 488b4008 }
            // n = 7, score = 100
            //   488bfc               | pop                 edi
            //   b932000000           | dec                 eax
            //   b8cccccccc           | mov                 ecx, dword ptr [esp + 0x108]
            //   f3ab                 | xor                 edx, edx
            //   488b8c24e8000000     | dec                 eax
            //   488b85e0000000       | mov                 ecx, dword ptr [ebp + 0xe0]
            //   488b4008             | xor                 eax, eax

        $sequence_3 = { 488b8d00010000 e8???????? 488b8dd8000000 488bd1 488bc8 e8???????? }
            // n = 6, score = 100
            //   488b8d00010000       | dec                 eax
            //   e8????????           |                     
            //   488b8dd8000000       | lea                 ecx, [0xab16]
            //   488bd1               | dec                 eax
            //   488bc8               | add                 ecx, eax
            //   e8????????           |                     

        $sequence_4 = { 488d1d5c8e0000 8bf7 488b2b 4885ed 741b 837b0801 7415 }
            // n = 7, score = 100
            //   488d1d5c8e0000       | mov                 ecx, eax
            //   8bf7                 | dec                 esp
            //   488b2b               | mov                 eax, dword ptr [ebp + 0x108]
            //   4885ed               | xor                 edx, edx
            //   741b                 | dec                 eax
            //   837b0801             | mov                 ecx, eax
            //   7415                 | dec                 eax

        $sequence_5 = { 488bec 488bfc b932000000 b8cccccccc f3ab 488b8c24e8000000 488b85e0000000 }
            // n = 7, score = 100
            //   488bec               | dec                 eax
            //   488bfc               | cmp                 eax, dword ptr [ebp + 0x110]
            //   b932000000           | ja                  0xba6
            //   b8cccccccc           | dec                 eax
            //   f3ab                 | mov                 ecx, dword ptr [ebp + 0x100]
            //   488b8c24e8000000     | dec                 eax
            //   488b85e0000000       | sub                 ecx, eax

        $sequence_6 = { 488b8d08010000 488908 48837d0800 7418 488b8d00010000 e8???????? }
            // n = 6, score = 100
            //   488b8d08010000       | dec                 eax
            //   488908               | imul                eax, eax, 0x2b2
            //   48837d0800           | dec                 eax
            //   7418                 | lea                 ecx, [0x9dbb]
            //   488b8d00010000       | dec                 eax
            //   e8????????           |                     

        $sequence_7 = { 83f8ff 7526 4c8d2587860000 493bdc }
            // n = 4, score = 100
            //   83f8ff               | lea                 ecx, [esi]
            //   7526                 | mov                 edx, 0x31
            //   4c8d2587860000       | dec                 esp
            //   493bdc               | lea                 eax, [0xa1b3]

        $sequence_8 = { b8cccccccc f3ab 488b8c24e8000000 488b85e0000000 48c70000000000 488b85e0000000 488da5c8000000 }
            // n = 7, score = 100
            //   b8cccccccc           | arpl                dx, cx
            //   f3ab                 | mov                 al, byte ptr [ecx + ebx + 0x1c]
            //   488b8c24e8000000     | inc                 edx
            //   488b85e0000000       | mov                 byte ptr [ecx + eax + 0xea90], al
            //   48c70000000000       | mov                 ebx, eax
            //   488b85e0000000       | mov                 ebx, dword ptr [esp + 0x4c]
            //   488da5c8000000       | dec                 eax

        $sequence_9 = { 4c8b8500010000 488bd0 488d0d60b20000 e8???????? 48894508 8b4508 8bf8 }
            // n = 7, score = 100
            //   4c8b8500010000       | mov                 eax, dword ptr [esp + 0x30]
            //   488bd0               | dec                 eax
            //   488d0d60b20000       | add                 eax, 8
            //   e8????????           |                     
            //   48894508             | dec                 eax
            //   8b4508               | mov                 edi, eax
            //   8bf8                 | xor                 eax, eax

    condition:
        7 of them and filesize < 540672
}