rule win_alreay_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.alreay."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.alreay"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8a4f06 0bc2 33d2 8b742414 8a7704 8a5705 c1e208 }
            // n = 7, score = 200
            //   8a4f06               | mov                 cl, byte ptr [edi + 6]
            //   0bc2                 | or                  eax, edx
            //   33d2                 | xor                 edx, edx
            //   8b742414             | mov                 esi, dword ptr [esp + 0x14]
            //   8a7704               | mov                 dh, byte ptr [edi + 4]
            //   8a5705               | mov                 dl, byte ptr [edi + 5]
            //   c1e208               | shl                 edx, 8

        $sequence_1 = { 0f859ffdffff 8b8538010000 3bc3 741d 83f801 7418 899de8010000 }
            // n = 7, score = 200
            //   0f859ffdffff         | jne                 0xfffffda5
            //   8b8538010000         | mov                 eax, dword ptr [ebp + 0x138]
            //   3bc3                 | cmp                 eax, ebx
            //   741d                 | je                  0x1f
            //   83f801               | cmp                 eax, 1
            //   7418                 | je                  0x1a
            //   899de8010000         | mov                 dword ptr [ebp + 0x1e8], ebx

        $sequence_2 = { 8b6c2424 898760020000 8b442420 896e58 8b6c242c 896e68 89861c010000 }
            // n = 7, score = 200
            //   8b6c2424             | mov                 ebp, dword ptr [esp + 0x24]
            //   898760020000         | mov                 dword ptr [edi + 0x260], eax
            //   8b442420             | mov                 eax, dword ptr [esp + 0x20]
            //   896e58               | mov                 dword ptr [esi + 0x58], ebp
            //   8b6c242c             | mov                 ebp, dword ptr [esp + 0x2c]
            //   896e68               | mov                 dword ptr [esi + 0x68], ebp
            //   89861c010000         | mov                 dword ptr [esi + 0x11c], eax

        $sequence_3 = { 8bd0 0bd3 0f8419010000 33c9 8bd3 894c2420 894c2424 }
            // n = 7, score = 200
            //   8bd0                 | mov                 edx, eax
            //   0bd3                 | or                  edx, ebx
            //   0f8419010000         | je                  0x11f
            //   33c9                 | xor                 ecx, ecx
            //   8bd3                 | mov                 edx, ebx
            //   894c2420             | mov                 dword ptr [esp + 0x20], ecx
            //   894c2424             | mov                 dword ptr [esp + 0x24], ecx

        $sequence_4 = { b926020000 33c0 8bfe f3ab 8dbe10020000 57 e8???????? }
            // n = 7, score = 200
            //   b926020000           | mov                 ecx, 0x226
            //   33c0                 | xor                 eax, eax
            //   8bfe                 | mov                 edi, esi
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   8dbe10020000         | lea                 edi, [esi + 0x210]
            //   57                   | push                edi
            //   e8????????           |                     

        $sequence_5 = { 8b542418 51 57 52 ff15???????? 85c0 7508 }
            // n = 7, score = 200
            //   8b542418             | mov                 edx, dword ptr [esp + 0x18]
            //   51                   | push                ecx
            //   57                   | push                edi
            //   52                   | push                edx
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7508                 | jne                 0xa

        $sequence_6 = { 8d4c2414 56 33ed 8b38 895c244c 894c2414 e8???????? }
            // n = 7, score = 200
            //   8d4c2414             | lea                 ecx, [esp + 0x14]
            //   56                   | push                esi
            //   33ed                 | xor                 ebp, ebp
            //   8b38                 | mov                 edi, dword ptr [eax]
            //   895c244c             | mov                 dword ptr [esp + 0x4c], ebx
            //   894c2414             | mov                 dword ptr [esp + 0x14], ecx
            //   e8????????           |                     

        $sequence_7 = { 897c2418 89bc3490000000 8b7c241c 8bf7 8bdf c1e615 c1eb0b }
            // n = 7, score = 200
            //   897c2418             | mov                 dword ptr [esp + 0x18], edi
            //   89bc3490000000       | mov                 dword ptr [esp + esi + 0x90], edi
            //   8b7c241c             | mov                 edi, dword ptr [esp + 0x1c]
            //   8bf7                 | mov                 esi, edi
            //   8bdf                 | mov                 ebx, edi
            //   c1e615               | shl                 esi, 0x15
            //   c1eb0b               | shr                 ebx, 0xb

        $sequence_8 = { 8b7e34 3bfb 7436 8b4760 3bc3 740f 50 }
            // n = 7, score = 200
            //   8b7e34               | mov                 edi, dword ptr [esi + 0x34]
            //   3bfb                 | cmp                 edi, ebx
            //   7436                 | je                  0x38
            //   8b4760               | mov                 eax, dword ptr [edi + 0x60]
            //   3bc3                 | cmp                 eax, ebx
            //   740f                 | je                  0x11
            //   50                   | push                eax

        $sequence_9 = { 8beb 8aa760954700 33e8 c1e508 33c0 33db 8a442411 }
            // n = 7, score = 200
            //   8beb                 | mov                 ebp, ebx
            //   8aa760954700         | mov                 ah, byte ptr [edi + 0x479560]
            //   33e8                 | xor                 ebp, eax
            //   c1e508               | shl                 ebp, 8
            //   33c0                 | xor                 eax, eax
            //   33db                 | xor                 ebx, ebx
            //   8a442411             | mov                 al, byte ptr [esp + 0x11]

    condition:
        7 of them and filesize < 1867776
}